/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor.plugin;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.TabAction;
import net.sf.sdedit.editor.plugin.AbstractFileHandler;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.Utilities;

public class FileActionProvider {
    private Map<FileHandler, Map<String, Action>> actionMap;
    private Action openAction;
    public final Activator getOpenActivator = new Activator(){

        @Override
        public boolean isEnabled() {
            return true;
        }
    };
    public final Activator getSaveActivator = new Activator(){

        @Override
        public boolean isEnabled() {
            Tab tab = Editor.getEditor().getUI().currentTab();
            if (tab == null) {
                return false;
            }
            return tab.getFileHandler() != null && tab.getFileHandler().canSave();
        }
    };

    public FileActionProvider() {
        this.actionMap = new HashMap<FileHandler, Map<String, Action>>();
    }

    public Action getOpenAction(UserInterface ui) {
        if (this.openAction == null) {
            this.openAction = this.makeOpenAction(ui);
        }
        return this.openAction;
    }

    public Action getSaveAction(FileHandler handler, UserInterface ui) {
        Action action = this.getAction(handler, "SAVE");
        if (action == null) {
            action = this.makeSaveAction(handler, ui);
            this.setAction(handler, "SAVE", action);
        }
        return action;
    }

    public Action getSaveAsAction(FileHandler handler, UserInterface ui) {
        Action action = this.getAction(handler, "SAVE_AS");
        if (action == null) {
            action = this.makeSaveAsAction(handler, ui);
            this.setAction(handler, "SAVE_AS", action);
        }
        return action;
    }

    private Action getAction(FileHandler fileHandler, String type) {
        Map<String, Action> types = this.actionMap.get(fileHandler);
        return types == null ? null : types.get(type);
    }

    private void setAction(FileHandler fileHandler, String type, Action action) {
        Map<String, Action> types = this.actionMap.get(fileHandler);
        if (types == null) {
            types = new HashMap<String, Action>();
            this.actionMap.put(fileHandler, types);
        }
        types.put(type, action);
    }

    private Action makeOpenAction(final UserInterface ui) {
        return new AbstractAction(){
            {
                this.putValue("IconName", "open");
                this.putValue("ActionID", "OPEN_FILE");
                this.putValue("NewName", "Open File");
                this.putValue("ShortDescription", "Open File");
                this.putValue("Name", "Open File");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> filters = new ArrayList<String>();
                for (FileHandler h : Editor.getEditor().getFileHandlers()) {
                    for (int j = 0; j < h.getFileDescriptions().length; ++j) {
                        filters.add(h.getFileDescriptions()[j]);
                        filters.add(h.getFileTypes()[j]);
                    }
                }
                File[] files = Utilities.chooseFiles(AbstractFileHandler.FILE_CHOOSER, ui.currentTab(), true, true, "Open file", null, filters.toArray(new String[filters.size()]));
                if (files != null) {
                    for (File file : files) {
                        try {
                            Editor.getEditor().load(file.toURI().toURL());
                        }
                        catch (IOException e1) {
                            ui.errorMessage(e1, null, null);
                        }
                        catch (URISyntaxException e1) {
                            ui.errorMessage(e1, null, null);
                        }
                    }
                }
            }
        };
    }

    private Action makeSaveAction(final FileHandler handler, UserInterface ui) {
        return new TabAction<Tab>(Tab.class, ui){
            {
                super(tabClass, ui);
                this.putValue("IconName", "save");
                this.putValue("ActionID", "SAVE");
                this.putValue("NewName", handler.getSaveActionName());
                this.putValue("ShortDescription", handler.getSaveDescription());
                String actionName = handler.getSaveActionName();
                if (handler.getSaveShortCut() != null) {
                    actionName = handler.getSaveShortCut() + actionName;
                }
                this.putValue("Name", actionName);
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent e) {
                try {
                    handler.save(tab, false);
                    ((UserInterfaceImpl)this.ui).enableComponents();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.ui.errorMessage(ex, null, null);
                }
            }
        };
    }

    private Action makeSaveAsAction(final FileHandler handler, UserInterface ui) {
        return new TabAction<Tab>(Tab.class, ui){
            {
                super(tabClass, ui);
                this.putValue("IconName", "saveas");
                this.putValue("ActionID", "SAVE_AS");
                this.putValue("NewName", handler.getSaveAsActionName());
                this.putValue("ShortDescription", handler.getSaveAsDescription());
                String actionName = handler.getSaveAsActionName();
                if (handler.getSaveAsShortCut() != null) {
                    actionName = handler.getSaveAsShortCut() + actionName;
                }
                this.putValue("Name", actionName);
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent e) {
                try {
                    handler.save(tab, true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.ui.errorMessage(ex, null, null);
                }
            }
        };
    }
}

