/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SliceLeafAnalyzer {
    private static final Logger LOG = Logger.getInstance(SliceLeafAnalyzer.class);
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceLeafAnalyzer(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        if (leafEquality == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(1);
        }
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    static SliceNode filterTree(SliceNode oldRoot, NullableFunction<? super SliceNode, ? extends SliceNode> filter, PairProcessor<? super SliceNode, ? super List<SliceNode>> postProcessor) {
        boolean success2;
        SliceNode filtered = (SliceNode)filter.fun((Object)oldRoot);
        if (filtered == null) {
            return null;
        }
        ArrayList<SliceNode> childrenFiltered = new ArrayList<SliceNode>();
        if (oldRoot.myCachedChildren != null) {
            for (SliceNode child2 : oldRoot.myCachedChildren) {
                SliceNode childFiltered = SliceLeafAnalyzer.filterTree(child2, filter, postProcessor);
                if (childFiltered == null) continue;
                childrenFiltered.add(childFiltered);
            }
        }
        boolean bl = success2 = postProcessor == null || postProcessor.process((Object)filtered, childrenFiltered);
        if (!success2) {
            return null;
        }
        filtered.myCachedChildren = new ArrayList<SliceNode>(childrenFiltered);
        return filtered;
    }

    private void groupByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map) {
        if (leaves == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(2);
        }
        if (oldRoot == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(3);
        }
        if (map == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(4);
        }
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceRootNode root = this.createTreeGroupedByValues(leaves, oldRoot, map);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceUsage rootUsage = (SliceUsage)((Object)oldRootStart.getValue());
        String description = SliceManager.getElementDescription(null, rootUsage.getElement(), " (grouped by value)");
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, description);
    }

    @NotNull
    public SliceRootNode createTreeGroupedByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map) {
        if (leaves == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(5);
        }
        if (oldRoot == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(6);
        }
        if (map == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(7);
        }
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceRootNode root = oldRoot.copy();
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList(leaves.size());
        for (PsiElement psiElement : leaves) {
            SliceNode newNode = SliceLeafAnalyzer.filterTree(oldRootStart, (NullableFunction<? super SliceNode, ? extends SliceNode>)((NullableFunction)oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                if (!SliceLeafAnalyzer.node(oldNode, map).contains(leafExpression)) {
                    return null;
                }
                return oldNode.copy();
            }), (PairProcessor<? super SliceNode, ? super List<SliceNode>>)((PairProcessor)(node, children2) -> {
                if (!children2.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)((Object)((Object)((Object)node.getValue())))).getElement();
                if (element == null) {
                    return false;
                }
                return element.getManager().areElementsEquivalent(element, leafExpression);
            }));
            SliceLeafValueRootNode lvNode = new SliceLeafValueRootNode(root.getProject(), root, this.myProvider.createRootUsage(psiElement, ((SliceUsage)((Object)oldRoot.getValue())).params), Collections.singletonList(newNode));
            root.myCachedChildren.add(lvNode);
        }
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(8);
        }
        return sliceRootNode;
    }

    public void startAnalyzeValues(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        if (treeStructure == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(9);
        }
        if (finish == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(10);
        }
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, Collection<PsiElement>> map = this.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection<PsiElement> l = SliceLeafAnalyzer.this.calcLeafExpressions(root, treeStructure, map);
                leafExpressions.set(l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    Collection leaves = (Collection)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    if (leaves.isEmpty()) {
                        Messages.showErrorDialog((String)"Unable to find leaf expressions to group by", (String)"Cannot Group");
                        return;
                    }
                    SliceLeafAnalyzer.this.groupByValues(leaves, root, map);
                }
                finally {
                    finish.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/slicer/SliceLeafAnalyzer$1", "run"));
            }
        });
    }

    public Map<SliceNode, Collection<PsiElement>> createMap() {
        return ConcurrentFactoryMap.createMap(k -> ConcurrentCollectionFactory.createConcurrentSet(this.myLeafEquality), () -> ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy()));
    }

    private static Collection<PsiElement> node(SliceNode node, Map<SliceNode, Collection<PsiElement>> map) {
        return map.get(node);
    }

    @NotNull
    public Collection<PsiElement> calcLeafExpressions(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, Collection<PsiElement>> map) {
        if (root == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(11);
        }
        if (treeStructure == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(12);
        }
        if (map == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(13);
        }
        final SliceNodeGuide guide = new SliceNodeGuide(treeStructure);
        final AtomicInteger depth = new AtomicInteger();
        final boolean printToLog = LOG.isTraceEnabled();
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void elementStarted(@NotNull SliceNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                depth.incrementAndGet();
                super.elementStarted((Object)element);
            }

            public void visit(@NotNull SliceNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                element.calculateDupNode();
                SliceLeafAnalyzer.node(element, map).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceLeafAnalyzer.node(element, map).addAll(SliceLeafAnalyzer.node(duplicate, map));
                } else {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement value;
                        SliceUsage sliceUsage = (SliceUsage)((Object)((Object)element.getValue()));
                        Collection<SliceNode> children2 = element.getChildren();
                        if (printToLog) {
                            LOG.trace(StringUtil.repeat((String)"  ", (int)Math.max(depth.get(), 0)) + "analyzing usages of " + (Object)((Object)sliceUsage) + " (in " + (sliceUsage == null ? "null" : sliceUsage.getFile().getName() + ":" + sliceUsage.getLine()) + ")");
                        }
                        if (children2.isEmpty() && sliceUsage != null && sliceUsage.canBeLeaf() && (value = sliceUsage.getElement()) != null) {
                            SliceLeafAnalyzer.node(element, map).addAll(ContainerUtil.singleton((Object)value, (TObjectHashingStrategy)SliceLeafAnalyzer.this.myLeafEquality));
                        }
                    });
                    super.visit((Object)element);
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                depth.decrementAndGet();
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceLeafAnalyzer.node(parent, map).addAll(SliceLeafAnalyzer.node(element, map));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        walkingState.visit((Object)root);
        Collection<PsiElement> collection = SliceLeafAnalyzer.node(root, map);
        if (collection == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafEquality";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaves";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceLeafAnalyzer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeGroupedByValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLeafExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "groupByValues";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeGroupedByValues";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startAnalyzeValues";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcLeafExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SliceNodeGuide
    implements WalkingState.TreeGuide<SliceNode> {
        private final AbstractTreeStructure myTreeStructure;

        SliceNodeGuide(@NotNull AbstractTreeStructure treeStructure) {
            if (treeStructure == null) {
                SliceNodeGuide.$$$reportNull$$$0(0);
            }
            this.myTreeStructure = treeStructure;
        }

        public SliceNode getNextSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent;
            if (element == null) {
                SliceNodeGuide.$$$reportNull$$$0(1);
            }
            if ((parent = element.getParent()) == null) {
                return null;
            }
            return element.getNext((List)parent.getChildren());
        }

        public SliceNode getPrevSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent;
            if (element == null) {
                SliceNodeGuide.$$$reportNull$$$0(2);
            }
            if ((parent = element.getParent()) == null) {
                return null;
            }
            return element.getPrev((List)parent.getChildren());
        }

        public SliceNode getFirstChild(@NotNull SliceNode element) {
            Object[] children2;
            if (element == null) {
                SliceNodeGuide.$$$reportNull$$$0(3);
            }
            return (children2 = this.myTreeStructure.getChildElements((Object)element)).length == 0 ? null : (SliceNode)children2[0];
        }

        public SliceNode getParent(@NotNull SliceNode element) {
            AbstractTreeNode parent;
            if (element == null) {
                SliceNodeGuide.$$$reportNull$$$0(4);
            }
            return (parent = element.getParent()) instanceof SliceNode ? (SliceNode)parent : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeStructure";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer$SliceNodeGuide";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNextSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrevSibling";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

