/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ExtendableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreatePatchFromChangesAction
extends ExtendableAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CreatePatchFromChangesAction.class);
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_DIALOG = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Dialog.ExtensionProvider");
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_CLIPBOARD = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Clipboard.ExtensionProvider");
    private final boolean mySilentClipboard;

    private CreatePatchFromChangesAction(boolean silentClipboard) {
        super(silentClipboard ? EP_NAME_CLIPBOARD : EP_NAME_DIALOG);
        this.mySilentClipboard = silentClipboard;
    }

    @Override
    public void defaultActionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Object[] changes2 = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (ArrayUtil.isEmpty((Object[])changes2)) {
            return;
        }
        String commitMessage2 = CreatePatchFromChangesAction.extractCommitMessage(e);
        CreatePatchFromChangesAction.createPatch(project, commitMessage2, Arrays.asList(changes2), this.mySilentClipboard);
    }

    @Nullable
    private static String extractCommitMessage(@NotNull AnActionEvent e) {
        String message;
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(1);
        }
        if ((message = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE)) != null) {
            return message;
        }
        List<ShelvedChangeList> shelvedChangeLists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        if (!shelvedChangeLists.isEmpty()) {
            return shelvedChangeLists.get((int)0).DESCRIPTION;
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0) {
            return changeLists[0].getComment();
        }
        return null;
    }

    public static void createPatch(@Nullable Project project, @Nullable String commitMessage2, @NotNull List<Change> changes2) {
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(2);
        }
        CreatePatchFromChangesAction.createPatch(project, commitMessage2, changes2, false);
    }

    public static void createPatch(@Nullable Project project, @Nullable String commitMessage2, @NotNull List<Change> changes2, boolean silentClipboard) {
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(3);
        }
        Project project2 = project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        if (silentClipboard) {
            CreatePatchFromChangesAction.createIntoClipboard(project, changes2);
        } else {
            CreatePatchFromChangesAction.createWithDialog(project, commitMessage2, changes2);
        }
    }

    private static void createWithDialog(@NotNull Project project, @Nullable String commitMessage2, @NotNull List<Change> changes2) {
        SessionDialog sessionDialog;
        CreatePatchCommitExecutor executor;
        CommitSession commitSession;
        if (project == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(4);
        }
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(5);
        }
        if ((commitSession = (executor = CreatePatchCommitExecutor.getInstance(project)).createCommitSession()) instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)commitSession).setContext(new CommitContext());
        }
        if (!(sessionDialog = new SessionDialog(executor.getActionText(), project, commitSession, changes2, commitMessage2)).showAndGet()) {
            return;
        }
        CreatePatchFromChangesAction.preloadContent(project, changes2);
        commitSession.execute(changes2, commitMessage2);
    }

    private static void createIntoClipboard(@NotNull Project project, @NotNull List<Change> changes2) {
        if (project == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(6);
        }
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                String base = PatchWriter.calculateBaseForWritingPatch(project, changes2).getPath();
                List<FilePatch> patches2 = IdeaTextPatchBuilder.buildPatch(project, changes2, base, false);
                PatchWriter.writeAsPatchToClipboard(project, patches2, base, new CommitContext());
                VcsNotifier.getInstance(project).notifySuccess("Patch copied to clipboard");
            }
            catch (VcsException | IOException exception) {
                LOG.error("Can't create patch", exception);
                VcsNotifier.getInstance(project).notifyWeakError("Patch creation failed");
            }
        }, VcsBundle.message((String)"create.patch.commit.action.progress", (Object[])new Object[0]), true, project);
    }

    private static void preloadContent(Project project, final List<Change> changes2) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Change change : changes2) {
                    this.checkLoadContent(change.getBeforeRevision());
                    this.checkLoadContent(change.getAfterRevision());
                }
            }

            private void checkLoadContent(ContentRevision revision) {
                ProgressManager.checkCanceled();
                if (revision != null && !(revision instanceof BinaryContentRevision)) {
                    try {
                        revision.getContent();
                    }
                    catch (VcsException vcsException) {
                        // empty catch block
                    }
                }
            }
        }, VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true, project);
    }

    @Override
    public void defaultUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(8);
        }
        Boolean haveSelectedChanges = (Boolean)e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List<ShelvedChangeList> shelveChangelists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        int changelistNum = changeLists == null ? 0 : changeLists.length;
        e.getPresentation().setEnabled(!Boolean.FALSE.equals(haveSelectedChanges) && (changelistNum += shelveChangelists.size()) <= 1 && !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/CreatePatchFromChangesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCommitMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPatch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createWithDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createIntoClipboard";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Clipboard
    extends CreatePatchFromChangesAction {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends CreatePatchFromChangesAction {
        public Dialog() {
            super(false);
        }
    }
}

