/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

public enum ChannelStatus {
    EAP("eap", "Early Access Program"),
    MILESTONE("milestone", "Milestone EAP Builds"),
    BETA("beta", "Beta Releases or Public Previews"),
    RELEASE("release", "Stable Releases");

    private final String myCode;
    private final String myDisplayName;

    private ChannelStatus(String code, String displayName) {
        this.myCode = code;
        this.myDisplayName = displayName;
    }

    public static ChannelStatus fromCode(String code) {
        for (ChannelStatus type : ChannelStatus.values()) {
            if (!type.getCode().equalsIgnoreCase(code)) continue;
            return type;
        }
        return RELEASE;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String toString() {
        return this.myDisplayName;
    }
}

