/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ClipDetector;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntObjectHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorPainter
implements TextDrawingCallback {
    private static final Color CARET_LIGHT = Gray._255;
    private static final Color CARET_DARK = Gray._0;
    private static final Stroke IME_COMPOSED_TEXT_UNDERLINE_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    private static final int CARET_DIRECTION_MARK_SIZE = 5;
    private static final char IDEOGRAPHIC_SPACE = '\u3000';
    private static final String WHITESPACE_CHARS = " \t\u3000";
    private static final Key<TextAttributes> INNER_HIGHLIGHTING = Key.create((String)"inner.highlighting");
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final Document myDocument;
    private XCorrector myCorrector;

    EditorPainter(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myCorrector = XCorrector.create(this.myView);
    }

    void paint(Graphics2D g) {
        this.myCorrector = this.myCorrector.align(this.myView);
        Rectangle clip = g.getClipBounds();
        if (this.myEditor.getContentComponent().isOpaque()) {
            g.setColor(this.myEditor.getBackgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.paintPlaceholderText(g)) {
            this.paintCaret(g, 0);
            return;
        }
        int startLine = this.myView.yToVisualLine(clip.y);
        int endLine = this.myView.yToVisualLine(clip.y + clip.height - 1);
        int startOffset = this.myView.visualLineToOffset(startLine);
        int endOffset = this.myView.visualLineToOffset(endLine + 1);
        ClipDetector clipDetector = new ClipDetector(this.myEditor, clip);
        IterationState.CaretData caretData = this.myEditor.isPaintSelection() ? IterationState.createCaretData(this.myEditor) : null;
        TIntObjectHashMap extensionData = new TIntObjectHashMap();
        int yShift = -clip.y;
        g.translate(0, -yShift);
        MarginPositions marginWidths = this.paintBackground(g, clip, yShift, startLine, endLine, caretData, (TIntObjectHashMap<List<LineExtensionData>>)extensionData);
        this.paintRightMargin(g, clip, startLine, endLine, marginWidths);
        this.paintCustomRenderers(g, yShift, startOffset, endOffset);
        MarkupModelEx docMarkup = this.myEditor.getFilteredDocumentMarkupModel();
        this.paintLineMarkersSeparators(g, clip, yShift, docMarkup, startOffset, endOffset);
        this.paintLineMarkersSeparators(g, clip, yShift, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintTextWithEffects(g, clip, yShift, startLine, endLine, caretData, (TIntObjectHashMap<List<LineExtensionData>>)extensionData);
        this.paintHighlightersAfterEndOfLine(g, yShift, docMarkup, startOffset, endOffset);
        this.paintHighlightersAfterEndOfLine(g, yShift, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, yShift, this.myEditor.getHighlighter(), startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, yShift, docMarkup, startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, yShift, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintBlockInlays(g, yShift, startLine, endLine);
        this.paintCaret(g, yShift);
        this.paintComposedTextDecoration(g, yShift);
        g.translate(0, yShift);
    }

    private boolean paintPlaceholderText(Graphics2D g) {
        CharSequence hintText = this.myEditor.getPlaceholder();
        EditorComponentImpl editorComponent = this.myEditor.getContentComponent();
        if (this.myDocument.getTextLength() > 0 || hintText == null || hintText.length() == 0 || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == editorComponent && !this.myEditor.getShowPlaceholderWhenFocused()) {
            return false;
        }
        hintText = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), hintText.toString(), null, 0, 0, 0, 0, SwingUtilities.calculateInnerArea(editorComponent, null), new Rectangle(), new Rectangle(), 0);
        EditorFontType fontType = EditorFontType.PLAIN;
        Color color = this.myEditor.getFoldingModel().getPlaceholderAttributes().getForegroundColor();
        TextAttributes attributes = this.myEditor.getPlaceholderAttributes();
        if (attributes != null) {
            int type = attributes.getFontType();
            if (type == 2) {
                fontType = EditorFontType.ITALIC;
            } else if (type == 1) {
                fontType = EditorFontType.BOLD;
            } else if (type == 3) {
                fontType = EditorFontType.BOLD_ITALIC;
            }
            Color attColor = attributes.getForegroundColor();
            if (attColor != null) {
                color = attColor;
            }
        }
        g.setColor(color);
        g.setFont(this.myEditor.getColorsScheme().getFont(fontType));
        Insets insets = this.myView.getInsets();
        g.drawString(hintText.toString(), insets.left, insets.top + this.myView.getAscent());
        return true;
    }

    private void paintRightMargin(Graphics g, Rectangle clip, int startVisualLine, int endVisualLine, MarginPositions marginWidths) {
        if (!this.isMarginShown()) {
            return;
        }
        g.setColor(this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR));
        float baseMarginWidth = EditorPainter.getBaseMarginWidth(this.myView);
        if (marginWidths == null) {
            int x = this.myCorrector.marginX(baseMarginWidth);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)0.0, (double)x, (double)clip.height);
        } else {
            int lineHeight = this.myView.getLineHeight();
            int displayedLinesCount = marginWidths.x.length - 1;
            for (int i = 0; i <= displayedLinesCount; ++i) {
                int nextX;
                int y = marginWidths.y[i];
                int yStart = i == 0 ? 0 : y;
                int yEnd = i == displayedLinesCount ? clip.y + clip.height : y + lineHeight;
                float width = marginWidths.x[i];
                if (width == 0.0f) {
                    width = baseMarginWidth;
                }
                int x = this.myCorrector.marginX(width);
                g.fillRect(x, yStart, 1, yEnd - yStart);
                if (i >= displayedLinesCount) continue;
                float nextWidth = marginWidths.x[i + 1];
                if (nextWidth == 0.0f) {
                    nextWidth = baseMarginWidth;
                }
                if ((nextX = this.myCorrector.marginX(nextWidth)) == x) continue;
                g.fillRect(Math.min(x, nextX), y + lineHeight - 1, Math.abs(x - nextX) + 1, 1);
            }
        }
        Color visualGuidesColor = this.myEditor.getColorsScheme().getColor(EditorColors.VISUAL_INDENT_GUIDE_COLOR);
        if (visualGuidesColor != null) {
            g.setColor(visualGuidesColor);
            for (Integer marginX : this.myCorrector.softMarginsX()) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)marginX.intValue(), (double)0.0, (double)marginX.intValue(), (double)clip.height);
            }
        }
    }

    private static float getBaseMarginWidth(EditorView view) {
        EditorImpl editor = view.getEditor();
        return (float)editor.getSettings().getRightMargin(editor.getProject()) * view.getPlainSpaceWidth();
    }

    private boolean isMarginShown() {
        return EditorPainter.isMarginShown(this.myEditor);
    }

    public static boolean isMarginShown(@NotNull Editor editor) {
        if (editor == null) {
            EditorPainter.$$$reportNull$$$0(0);
        }
        return editor.getSettings().isRightMarginShown() && editor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR) != null && (Registry.is((String)"editor.show.right.margin.in.read.only.files") || editor.getDocument().isWritable());
    }

    private MarginPositions paintBackground(Graphics2D g, Rectangle clip, int yShift, int startVisualLine, int endVisualLine, IterationState.CaretData caretData, final TIntObjectHashMap<List<LineExtensionData>> extensionData) {
        int visualLine;
        int lineCount = this.myEditor.getVisibleLineCount();
        boolean calculateMarginWidths = Registry.is((String)"editor.adjust.right.margin") && this.isMarginShown() && startVisualLine < lineCount;
        MarginPositions marginWidths = calculateMarginWidths ? new MarginPositions(Math.min(endVisualLine, lineCount - 1) - startVisualLine + 2) : null;
        int maxVisualLine = endVisualLine + (calculateMarginWidths ? 1 : 0);
        final Map<Integer, Couple<Integer>> virtualSelectionMap = this.createVirtualSelectionMap(startVisualLine, endVisualLine);
        final VisualPosition primarySelectionStart = this.myEditor.getSelectionModel().getSelectionStartPosition();
        final VisualPosition primarySelectionEnd = this.myEditor.getSelectionModel().getSelectionEndPosition();
        LineLayout prefixLayout = this.myView.getPrefixLayout();
        if (startVisualLine == 0 && prefixLayout != null) {
            float width2 = prefixLayout.getWidth();
            this.paintBackground(g, this.myView.getPrefixAttributes(), this.myCorrector.startX(startVisualLine), yShift + this.myView.visualLineToY(0), width2);
        }
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= maxVisualLine) {
            int y = visLinesIterator.getY() + yShift;
            if (calculateMarginWidths) {
                ((MarginPositions)marginWidths).y[visualLine - startVisualLine] = y;
            }
            final boolean dryRun = visualLine > endVisualLine;
            this.paintLineFragments(g, clip, visLinesIterator, caretData, y, new LineFragmentPainter(){

                @Override
                public void paintBeforeLineStart(Graphics2D g, TextAttributes attributes, boolean hasSoftWrap, int columnEnd, float xEnd, int y) {
                    if (dryRun) {
                        return;
                    }
                    EditorPainter.this.paintBackground(g, attributes, ((EditorPainter)EditorPainter.this).myView.getInsets().left, y, xEnd);
                    if (!hasSoftWrap) {
                        return;
                    }
                    EditorPainter.this.paintSelectionOnSecondSoftWrapLineIfNecessary(g, visualLine, columnEnd, xEnd, y, primarySelectionStart, primarySelectionEnd);
                }

                @Override
                public void paint(Graphics2D g, VisualLineFragmentsIterator.Fragment fragment, int start2, int end, TextAttributes attributes, float xStart, float xEnd, int y) {
                    if (dryRun) {
                        return;
                    }
                    FoldRegion foldRegion = fragment.getCurrentFoldRegion();
                    if (foldRegion != null && Registry.is((String)"editor.highlight.foldings")) {
                        EditorPainter.this.paintFoldingBackground(g, attributes, xStart, y, xEnd - xStart, foldRegion);
                    } else {
                        EditorPainter.this.paintBackground(g, attributes, xStart, y, xEnd - xStart);
                    }
                }

                @Override
                public void paintAfterLineEnd(Graphics2D g, Rectangle clip, IterationState it, int columnStart, float x, int y) {
                    if (dryRun) {
                        return;
                    }
                    EditorPainter.this.paintBackground(g, it.getPastLineEndBackgroundAttributes(), x, y, (float)(clip.x + clip.width) - x);
                    int offset = it.getEndOffset();
                    SoftWrap softWrap = EditorPainter.this.myEditor.getSoftWrapModel().getSoftWrap(offset);
                    if (softWrap == null) {
                        EditorPainter.this.collectExtensions(visualLine, offset, (TIntObjectHashMap<List<LineExtensionData>>)extensionData);
                        EditorPainter.this.paintLineExtensionsBackground(g, visualLine, x, y, (TIntObjectHashMap<List<LineExtensionData>>)extensionData);
                        EditorPainter.this.paintVirtualSelectionIfNecessary(g, visualLine, virtualSelectionMap, columnStart, x, clip.x + clip.width, y);
                    } else {
                        EditorPainter.this.paintSelectionOnFirstSoftWrapLineIfNecessary(g, visualLine, columnStart, x, clip.x + clip.width, y, primarySelectionStart, primarySelectionEnd);
                    }
                }
            }, calculateMarginWidths && !visLinesIterator.endsWithSoftWrap() && !visLinesIterator.startsWithSoftWrap() ? width -> {
                ((MarginPositions)marginWidths).x[visualLine - startVisualLine] = width;
            } : null);
            visLinesIterator.advance();
        }
        if (calculateMarginWidths && endVisualLine >= lineCount - 1) {
            ((MarginPositions)marginWidths).y[((MarginPositions)marginWidths).y.length - 1] = marginWidths.y[marginWidths.y.length - 2] + this.myView.getLineHeight();
        }
        return marginWidths;
    }

    private void paintFoldingBackground(Graphics2D g, TextAttributes attributes, float x, int y, float width, FoldRegion foldRegion) {
        TextAttributes innerAttributes = this.getInnerHighlighterAttributes(foldRegion);
        if (innerAttributes != null) {
            foldRegion.putUserData(INNER_HIGHLIGHTING, (Object)innerAttributes);
            if (innerAttributes.getBackgroundColor() != null && !EditorPainter.isSelected(foldRegion)) {
                Shape border;
                this.paintBackground(g, innerAttributes, x, y, width);
                Color borderColor = this.myEditor.getColorsScheme().getColor(EditorColors.FOLDED_TEXT_BORDER_COLOR);
                if (borderColor != null && (border = EditorPainter.getBorderShape(x, y, width, this.myView.getLineHeight(), 2, false)) != null) {
                    g.setColor(borderColor);
                    g.fill(border);
                }
                return;
            }
        }
        this.paintBackground(g, attributes, x, y, width);
    }

    private Map<Integer, Couple<Integer>> createVirtualSelectionMap(int startVisualLine, int endVisualLine) {
        HashMap<Integer, Couple<Integer>> map = new HashMap<Integer, Couple<Integer>>();
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            int line;
            if (!caret.hasSelection()) continue;
            VisualPosition selectionStart = caret.getSelectionStartPosition();
            VisualPosition selectionEnd = caret.getSelectionEndPosition();
            if (selectionStart.line != selectionEnd.line || (line = selectionStart.line) < startVisualLine || line > endVisualLine) continue;
            map.put(line, (Couple<Integer>)Couple.of((Object)selectionStart.column, (Object)selectionEnd.column));
        }
        return map;
    }

    private void paintVirtualSelectionIfNecessary(Graphics2D g, int visualLine, Map<Integer, Couple<Integer>> virtualSelectionMap, int columnStart, float xStart, float xEnd, int y) {
        Couple<Integer> selectionRange = virtualSelectionMap.get(visualLine);
        if (selectionRange == null || (Integer)selectionRange.second <= columnStart) {
            return;
        }
        float startX = (Integer)selectionRange.first <= columnStart ? xStart : (float)this.myView.visualPositionToXY(new VisualPosition(visualLine, ((Integer)selectionRange.first).intValue())).getX();
        float endX = (float)Math.min((double)xEnd, this.myView.visualPositionToXY(new VisualPosition(visualLine, ((Integer)selectionRange.second).intValue())).getX());
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintSelectionOnSecondSoftWrapLineIfNecessary(Graphics2D g, int visualLine, int columnEnd, float xEnd, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
        if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionStartPosition.line && selectionStartPosition.column >= columnEnd) {
            return;
        }
        float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > 0 ? (float)this.myView.visualPositionToXY(selectionStartPosition).getX() : this.myCorrector.startX(visualLine);
        float endX = selectionEndPosition.line == visualLine && selectionEndPosition.column < columnEnd ? (float)this.myView.visualPositionToXY(selectionEndPosition).getX() : xEnd;
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintSelectionOnFirstSoftWrapLineIfNecessary(Graphics2D g, int visualLine, int columnStart, float xStart, float xEnd, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
        if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionEndPosition.line && selectionEndPosition.column <= columnStart) {
            return;
        }
        float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > columnStart ? (float)this.myView.visualPositionToXY(selectionStartPosition).getX() : xStart;
        float endX = selectionEndPosition.line == visualLine ? (float)this.myView.visualPositionToXY(selectionEndPosition).getX() : xEnd;
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintBackground(Graphics2D g, TextAttributes attributes, float x, int y, float width) {
        if (attributes == null) {
            return;
        }
        this.paintBackground(g, attributes.getBackgroundColor(), x, y, width);
    }

    private void paintBackground(Graphics2D g, Color color, float x, int y, float width) {
        if (width <= 0.0f || color == null || color.equals(this.myEditor.getColorsScheme().getDefaultBackground()) || color.equals(this.myEditor.getBackgroundColor())) {
            return;
        }
        g.setColor(color);
        g.fill(new Rectangle2D.Float(x, y, width, this.myView.getLineHeight()));
    }

    private void paintCustomRenderers(Graphics2D g, int yShift, int startOffset, int endOffset) {
        g.translate(0, yShift);
        this.myEditor.getMarkupModel().processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            CustomHighlighterRenderer customRenderer = highlighter.getCustomRenderer();
            if (customRenderer != null && startOffset < highlighter.getEndOffset() && highlighter.getStartOffset() < endOffset) {
                customRenderer.paint((Editor)this.myEditor, (RangeHighlighter)highlighter, (Graphics)g);
            }
            return true;
        }));
        g.translate(0, -yShift);
    }

    private void paintLineMarkersSeparators(Graphics g, Rectangle clip, int yShift, MarkupModelEx markupModel, int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset - 1, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            this.paintLineMarkerSeparator((RangeHighlighter)highlighter, clip, g, yShift);
            return true;
        }));
    }

    private void paintLineMarkerSeparator(RangeHighlighter marker, Rectangle clip, Graphics g, int yShift) {
        Color separatorColor = marker.getLineSeparatorColor();
        LineSeparatorRenderer lineSeparatorRenderer = marker.getLineSeparatorRenderer();
        if (separatorColor == null && lineSeparatorRenderer == null) {
            return;
        }
        int line = this.myDocument.getLineNumber(marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? marker.getStartOffset() : marker.getEndOffset());
        int visualLine = this.myView.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)(line + (marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? 0 : 1)), (int)0), (boolean)false).line;
        int y = (visualLine == 0 ? -1 : this.myView.visualLineToY(visualLine - 1) + this.myView.getLineHeight() - 1) + yShift;
        int startX = this.myCorrector.lineSeparatorStart(clip.x);
        int endX = this.myCorrector.lineSeparatorEnd(clip.x + clip.width);
        g.setColor(separatorColor);
        if (lineSeparatorRenderer != null) {
            lineSeparatorRenderer.drawLine(g, startX, endX, y);
        } else {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)startX, (double)y, (double)endX, (double)y);
        }
    }

    private void paintTextWithEffects(Graphics2D g, Rectangle clip, int yShift, int startVisualLine, int endVisualLine, IterationState.CaretData caretData, final TIntObjectHashMap<List<LineExtensionData>> extensionData) {
        int visualLine;
        final CharSequence text = this.myDocument.getImmutableCharSequence();
        final LineWhitespacePaintingStrategy whitespacePaintingStrategy = new LineWhitespacePaintingStrategy(this.myEditor.getSettings());
        boolean paintAllSoftWraps = this.myEditor.getSettings().isAllSoftWrapsShown();
        int lineCount = this.myEditor.getVisibleLineCount();
        final int whiteSpaceStrokeWidth = JBUI.scale((int)1);
        final BasicStroke whiteSpaceStroke = new BasicStroke(whiteSpaceStrokeWidth);
        LineLayout prefixLayout = this.myView.getPrefixLayout();
        if (startVisualLine == 0 && prefixLayout != null) {
            TextAttributes attributes = this.myView.getPrefixAttributes();
            g.setColor(attributes.getForegroundColor());
            this.paintLineLayoutWithEffect(g, prefixLayout, this.myCorrector.startX(startVisualLine), this.myView.getAscent() + yShift + this.myView.visualLineToY(0), attributes.getEffectColor(), attributes.getEffectType());
        }
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= endVisualLine && visualLine < lineCount) {
            int y = visLinesIterator.getY() + yShift;
            final boolean paintSoftWraps = paintAllSoftWraps || this.myEditor.getCaretModel().getLogicalPosition().line == visLinesIterator.getStartLogicalLine();
            final int[] currentLogicalLine = new int[]{-1};
            this.paintLineFragments(g, clip, visLinesIterator, caretData, y + this.myView.getAscent(), new LineFragmentPainter(){

                @Override
                public void paintBeforeLineStart(Graphics2D g, TextAttributes attributes, boolean hasSoftWrap, int columnEnd, float xEnd, int y) {
                    if (paintSoftWraps && hasSoftWrap) {
                        SoftWrapModelImpl softWrapModel = EditorPainter.this.myEditor.getSoftWrapModel();
                        int symbolWidth = softWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                        softWrapModel.doPaint(g, SoftWrapDrawingType.AFTER_SOFT_WRAP, (int)xEnd - symbolWidth, y - EditorPainter.this.myView.getAscent(), EditorPainter.this.myView.getLineHeight());
                    }
                }

                @Override
                public void paint(Graphics2D g, VisualLineFragmentsIterator.Fragment fragment, int start2, int end, TextAttributes attributes, float xStart, float xEnd, int y) {
                    int lineHeight = EditorPainter.this.myView.getLineHeight();
                    Inlay inlay = fragment.getCurrentInlay();
                    if (inlay != null) {
                        inlay.getRenderer().paint(inlay, (Graphics)g, new Rectangle((int)xStart, y - EditorPainter.this.myView.getAscent(), inlay.getWidthInPixels(), lineHeight), attributes);
                        return;
                    }
                    FoldRegion foldRegion = fragment.getCurrentFoldRegion();
                    if (foldRegion != null && Registry.is((String)"editor.highlight.foldings")) {
                        attributes = EditorPainter.getFoldingInnerAttributes(attributes, foldRegion);
                    }
                    if (attributes != null && EditorPainter.hasTextEffect(attributes.getEffectColor(), attributes.getEffectType(), foldRegion != null)) {
                        EditorPainter.this.paintTextEffect(g, xStart, xEnd, y, attributes.getEffectColor(), attributes.getEffectType(), foldRegion != null);
                    }
                    if (attributes != null && attributes.getForegroundColor() != null) {
                        g.setColor(attributes.getForegroundColor());
                        fragment.draw(g, xStart, y, start2, end);
                    }
                    if (foldRegion == null) {
                        int logicalLine = fragment.getStartLogicalLine();
                        if (logicalLine != currentLogicalLine[0]) {
                            whitespacePaintingStrategy.update(text, EditorPainter.this.myDocument.getLineStartOffset(logicalLine), EditorPainter.this.myDocument.getLineEndOffset(logicalLine));
                            currentLogicalLine[0] = logicalLine;
                        }
                        EditorPainter.this.paintWhitespace(g, text, xStart, y, start2, end, whitespacePaintingStrategy, fragment, whiteSpaceStroke, whiteSpaceStrokeWidth);
                    }
                }

                @Override
                public void paintAfterLineEnd(Graphics2D g, Rectangle clip, IterationState iterationState, int columnStart, float x, int y) {
                    int offset = iterationState.getEndOffset();
                    SoftWrapModelImpl softWrapModel = EditorPainter.this.myEditor.getSoftWrapModel();
                    if (softWrapModel.getSoftWrap(offset) == null) {
                        EditorPainter.this.paintLineExtensions(g, visualLine, offset, x, y, (TIntObjectHashMap<List<LineExtensionData>>)extensionData);
                    } else if (paintSoftWraps) {
                        softWrapModel.doPaint(g, SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, (int)x, y - EditorPainter.this.myView.getAscent(), EditorPainter.this.myView.getLineHeight());
                    }
                }
            }, null);
            visLinesIterator.advance();
        }
        ComplexTextFragment.flushDrawingCache(g);
    }

    private static TextAttributes getFoldingInnerAttributes(TextAttributes basicAttributes, FoldRegion foldRegion) {
        TextAttributes innerAttributes = (TextAttributes)foldRegion.getUserData(INNER_HIGHLIGHTING);
        if (innerAttributes != null) {
            basicAttributes = TextAttributes.merge((TextAttributes)basicAttributes, (TextAttributes)innerAttributes);
            foldRegion.putUserData(INNER_HIGHLIGHTING, null);
        }
        return basicAttributes;
    }

    @Nullable
    private TextAttributes getInnerHighlighterAttributes(@NotNull FoldRegion region) {
        if (region == null) {
            EditorPainter.$$$reportNull$$$0(1);
        }
        if (region.areInnerHighlightersMuted()) {
            return null;
        }
        ArrayList<RangeHighlighterEx> innerHighlighters = new ArrayList<RangeHighlighterEx>();
        EditorPainter.collectVisibleInnerHighlighters(region, this.myEditor.getMarkupModel(), innerHighlighters);
        EditorPainter.collectVisibleInnerHighlighters(region, this.myEditor.getFilteredDocumentMarkupModel(), innerHighlighters);
        if (innerHighlighters.isEmpty()) {
            return null;
        }
        innerHighlighters.sort(IterationState.BY_LAYER_THEN_ATTRIBUTES);
        Color fgColor = null;
        Color bgColor = null;
        Color effectColor = null;
        EffectType effectType = null;
        for (RangeHighlighter rangeHighlighter : innerHighlighters) {
            EffectType type;
            TextAttributes attrs = rangeHighlighter.getTextAttributes();
            if (attrs == null) continue;
            if (fgColor == null && attrs.getForegroundColor() != null) {
                fgColor = attrs.getForegroundColor();
            }
            if (bgColor == null && attrs.getBackgroundColor() != null) {
                bgColor = attrs.getBackgroundColor();
            }
            if (effectColor != null || attrs.getEffectColor() == null || (type = attrs.getEffectType()) == null || type == EffectType.BOXED || type == EffectType.ROUNDED_BOX || type == EffectType.STRIKEOUT) continue;
            effectColor = attrs.getEffectColor();
            effectType = type;
        }
        return new TextAttributes(fgColor, bgColor, effectColor, effectType, 0);
    }

    private static void collectVisibleInnerHighlighters(@NotNull FoldRegion region, @NotNull MarkupModelEx markupModel, @NotNull List<? super RangeHighlighterEx> highlighters) {
        if (region == null) {
            EditorPainter.$$$reportNull$$$0(2);
        }
        if (markupModel == null) {
            EditorPainter.$$$reportNull$$$0(3);
        }
        if (highlighters == null) {
            EditorPainter.$$$reportNull$$$0(4);
        }
        int startOffset = region.getStartOffset();
        int endOffset = region.getEndOffset();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)h -> {
            if (h.isVisibleIfFolded() && h.getAffectedAreaStartOffset() >= startOffset && h.getAffectedAreaEndOffset() <= endOffset) {
                highlighters.add((RangeHighlighterEx)h);
            }
            return true;
        }));
    }

    private float paintLineLayoutWithEffect(Graphics2D g, LineLayout layout, float x, float y, @Nullable Color effectColor, @Nullable EffectType effectType) {
        if (EditorPainter.hasTextEffect(effectColor, effectType, false)) {
            this.paintTextEffect(g, x, x + layout.getWidth(), (int)y, effectColor, effectType, false);
        }
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(x)) {
            fragment.draw(g, fragment.getStartX(), y);
            x = fragment.getEndX();
        }
        return x;
    }

    private static boolean hasTextEffect(@Nullable Color effectColor, @Nullable EffectType effectType, boolean allowBorder) {
        return effectColor != null && (effectType == EffectType.LINE_UNDERSCORE || effectType == EffectType.BOLD_LINE_UNDERSCORE || effectType == EffectType.BOLD_DOTTED_LINE || effectType == EffectType.WAVE_UNDERSCORE || effectType == EffectType.STRIKEOUT || allowBorder && (effectType == EffectType.BOXED || effectType == EffectType.ROUNDED_BOX));
    }

    private void paintTextEffect(Graphics2D g, float xFrom, float xTo, int y, Color effectColor, EffectType effectType, boolean allowBorder) {
        g.setColor(effectColor);
        int xStart = (int)xFrom;
        int xEnd = (int)xTo;
        if (effectType == EffectType.LINE_UNDERSCORE) {
            EffectPainter.LINE_UNDERSCORE.paint(g, xStart, y, xEnd - xStart, this.myView.getDescent(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
            EffectPainter.BOLD_LINE_UNDERSCORE.paint(g, xStart, y, xEnd - xStart, this.myView.getDescent(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        } else if (effectType == EffectType.STRIKEOUT) {
            EffectPainter.STRIKE_THROUGH.paint(g, xStart, y, xEnd - xStart, this.myView.getCharHeight(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        } else if (effectType == EffectType.WAVE_UNDERSCORE) {
            EffectPainter.WAVE_UNDERSCORE.paint(g, xStart, y, xEnd - xStart, this.myView.getDescent(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
            EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g, xStart, y, xEnd - xStart, this.myView.getDescent(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        } else if (allowBorder && (effectType == EffectType.BOXED || effectType == EffectType.ROUNDED_BOX)) {
            this.drawSimpleBorder(g, xFrom, xTo, y - this.myView.getAscent(), effectType == EffectType.ROUNDED_BOX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWhitespace(Graphics2D g, CharSequence text, float x, int y, int start2, int end, LineWhitespacePaintingStrategy whitespacePaintingStrategy, VisualLineFragmentsIterator.Fragment fragment, Stroke stroke, int strokeWidth) {
        Stroke oldStroke = g.getStroke();
        try {
            g.setColor(this.myEditor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR));
            g.setStroke(stroke);
            boolean isRtl = fragment.isRtl();
            int baseStartOffset = fragment.getStartOffset();
            int startOffset = isRtl ? baseStartOffset - start2 : baseStartOffset + start2;
            --y;
            for (int i = start2; i < end; ++i) {
                int charOffset = isRtl ? baseStartOffset - i - 1 : baseStartOffset + i;
                char c = text.charAt(charOffset);
                if (WHITESPACE_CHARS.indexOf(c) < 0 || !whitespacePaintingStrategy.showWhitespaceAtOffset(charOffset)) continue;
                int startX = (int)fragment.offsetToX(x, startOffset, isRtl ? baseStartOffset - i : baseStartOffset + i);
                int endX = (int)fragment.offsetToX(x, startOffset, isRtl ? baseStartOffset - i - 1 : baseStartOffset + i + 1);
                if (c == ' ') {
                    g.fillRect((startX + endX - strokeWidth) / 2, y - strokeWidth + 1, strokeWidth, strokeWidth);
                    continue;
                }
                if (c == '\t') {
                    endX = (int)((float)endX - this.myView.getPlainSpaceWidth() / 4.0f);
                    int height = this.myView.getCharHeight();
                    int halfHeight = height / 2;
                    int mid = y - halfHeight;
                    int top = y - height;
                    LinePainter2D.paint((Graphics2D)g, (double)startX, (double)mid, (double)endX, (double)mid);
                    LinePainter2D.paint((Graphics2D)g, (double)endX, (double)y, (double)endX, (double)top);
                    g.fillPolygon(new int[]{endX - halfHeight, endX - halfHeight, endX}, new int[]{y, y - height, y - halfHeight}, 3);
                    continue;
                }
                if (c != '\u3000') continue;
                int charHeight = this.myView.getCharHeight();
                g.drawRect(startX + JBUI.scale((int)2) + strokeWidth / 2, y - charHeight + strokeWidth / 2, endX - startX - JBUI.scale((int)4) - (strokeWidth - 1), charHeight - (strokeWidth - 1));
            }
        }
        finally {
            g.setStroke(oldStroke);
        }
    }

    private void collectExtensions(int visualLine, int offset, TIntObjectHashMap<List<LineExtensionData>> extensionData) {
        this.myEditor.processLineExtensions(this.myDocument.getLineNumber(offset), (Processor<? super LineExtensionInfo>)((Processor)info -> {
            ArrayList<LineExtensionData> list2 = (ArrayList<LineExtensionData>)extensionData.get(visualLine);
            if (list2 == null) {
                list2 = new ArrayList<LineExtensionData>();
                extensionData.put(visualLine, list2);
            }
            list2.add(new LineExtensionData((LineExtensionInfo)info, LineLayout.create(this.myView, info.getText(), info.getFontType())));
            return true;
        }));
    }

    private void paintLineExtensionsBackground(Graphics2D g, int visualLine, float x, int y, TIntObjectHashMap<List<LineExtensionData>> extensionData) {
        List data = (List)extensionData.get(visualLine);
        if (data == null) {
            return;
        }
        for (LineExtensionData datum : data) {
            float width = datum.layout.getWidth();
            this.paintBackground(g, datum.info.getBgColor(), x, y, width);
            x += width;
        }
    }

    private void paintLineExtensions(Graphics2D g, int visualLine, int offset, float x, int y, TIntObjectHashMap<List<LineExtensionData>> extensionData) {
        EditorSizeManager sizeManager;
        List data = (List)extensionData.get(visualLine);
        if (data == null) {
            return;
        }
        for (LineExtensionData datum : data) {
            g.setColor(datum.info.getColor());
            x = this.paintLineLayoutWithEffect(g, datum.layout, x, y, datum.info.getEffectColor(), datum.info.getEffectType());
        }
        int currentLineWidth = this.myCorrector.lineWidth(visualLine, x);
        if (currentLineWidth > (sizeManager = this.myView.getSizeManager()).getMaxLineWithExtensionWidth()) {
            sizeManager.setMaxLineWithExtensionWidth(this.myDocument.getLineNumber(offset), currentLineWidth);
            this.myEditor.getContentComponent().revalidate();
        }
    }

    private void paintHighlightersAfterEndOfLine(Graphics2D g, int yShift, MarkupModelEx markupModel, int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            if (highlighter.getStartOffset() >= startOffset) {
                this.paintHighlighterAfterEndOfLine(g, yShift, (RangeHighlighterEx)highlighter);
            }
            return true;
        }));
    }

    private void paintHighlighterAfterEndOfLine(Graphics2D g, int yShift, RangeHighlighterEx highlighter) {
        if (!highlighter.isAfterEndOfLine()) {
            return;
        }
        int startOffset = highlighter.getStartOffset();
        int lineEndOffset = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(startOffset));
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            return;
        }
        Point2D lineEnd = this.myView.offsetToXY(lineEndOffset, true, false);
        float x = (float)lineEnd.getX();
        int y = (int)lineEnd.getY() + yShift;
        TextAttributes attributes = highlighter.getTextAttributes();
        this.paintBackground(g, attributes, x, y, this.myView.getPlainSpaceWidth());
        if (attributes != null && EditorPainter.hasTextEffect(attributes.getEffectColor(), attributes.getEffectType(), false)) {
            this.paintTextEffect(g, x, x + this.myView.getPlainSpaceWidth() - 1.0f, y + this.myView.getAscent(), attributes.getEffectColor(), attributes.getEffectType(), false);
        }
    }

    private void paintBorderEffect(Graphics2D g, ClipDetector clipDetector, int yShift, EditorHighlighter highlighter, int clipStartOffset, int clipEndOffset) {
        HighlighterIterator it = highlighter.createIterator(clipStartOffset);
        while (!it.atEnd() && it.getStart() < clipEndOffset) {
            TextAttributes attributes = it.getTextAttributes();
            if (EditorPainter.isBorder(attributes)) {
                this.paintBorderEffect(g, clipDetector, yShift, it.getStart(), it.getEnd(), attributes);
            }
            it.advance();
        }
    }

    private void paintBorderEffect(Graphics2D g, ClipDetector clipDetector, int yShift, MarkupModelEx markupModel, int clipStartOffset, int clipEndOffset) {
        markupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
            TextAttributes attributes = rangeHighlighter.getTextAttributes();
            if (EditorPainter.isBorder(attributes)) {
                this.paintBorderEffect(g, clipDetector, yShift, rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset(), attributes);
            }
            return true;
        }));
    }

    private static boolean isBorder(TextAttributes attributes) {
        return attributes != null && (attributes.getEffectType() == EffectType.BOXED || attributes.getEffectType() == EffectType.ROUNDED_BOX) && attributes.getEffectColor() != null;
    }

    private void paintBorderEffect(Graphics2D g, ClipDetector clipDetector, int yShift, int startOffset, int endOffset, TextAttributes attributes) {
        int endLine;
        if (!clipDetector.rangeCanBeVisible(startOffset = DocumentUtil.alignToCodePointBoundary(this.myDocument, startOffset), endOffset = DocumentUtil.alignToCodePointBoundary(this.myDocument, endOffset))) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(startOffset);
        if (startLine + 1 == (endLine = this.myDocument.getLineNumber(endOffset)) && startOffset == this.myDocument.getLineStartOffset(startLine) && endOffset == this.myDocument.getLineStartOffset(endLine)) {
            endOffset = this.myDocument.getLineEndOffset(--endLine);
        }
        boolean rounded = attributes.getEffectType() == EffectType.ROUNDED_BOX;
        g.setColor(attributes.getEffectColor());
        VisualPosition startPosition = this.myView.offsetToVisualPosition(startOffset, true, false);
        VisualPosition endPosition = this.myView.offsetToVisualPosition(endOffset, false, true);
        if (startPosition.line == endPosition.line) {
            int y = this.myView.visualLineToY(startPosition.line) + yShift;
            TFloatArrayList ranges = this.adjustedLogicalRangeToVisualRanges(startOffset, endOffset);
            for (int i = 0; i < ranges.size() - 1; i += 2) {
                float startX = this.myCorrector.singleLineBorderStart(ranges.get(i));
                float endX = this.myCorrector.singleLineBorderEnd(ranges.get(i + 1));
                this.drawSimpleBorder(g, startX, endX, y, rounded);
            }
        } else {
            TFloatArrayList leadingRanges = this.adjustedLogicalRangeToVisualRanges(startOffset, this.myView.visualPositionToOffset(new VisualPosition(startPosition.line, Integer.MAX_VALUE, true)));
            TFloatArrayList trailingRanges = this.adjustedLogicalRangeToVisualRanges(this.myView.visualPositionToOffset(new VisualPosition(endPosition.line, 0)), endOffset);
            if (!leadingRanges.isEmpty() && !trailingRanges.isEmpty()) {
                int minX = Math.min(this.myCorrector.minX(startPosition.line, endPosition.line), (int)leadingRanges.get(0));
                int maxX = Math.max(this.myCorrector.maxX(startPosition.line, endPosition.line), (int)trailingRanges.get(trailingRanges.size() - 1));
                boolean containsInnerLines = endPosition.line > startPosition.line + 1;
                int lineHeight = this.myView.getLineHeight() - 1;
                int leadingTopY = this.myView.visualLineToY(startPosition.line) + yShift;
                int leadingBottomY = leadingTopY + lineHeight;
                int trailingTopY = this.myView.visualLineToY(endPosition.line) + yShift;
                int trailingBottomY = trailingTopY + lineHeight;
                float start2 = 0.0f;
                float end = 0.0f;
                float leftGap = leadingRanges.get(0) - (containsInnerLines ? (float)minX : trailingRanges.get(0));
                int adjustY = leftGap == 0.0f ? 2 : (leftGap > 0.0f ? 1 : 0);
                for (int i = 0; i < leadingRanges.size() - 1; i += 2) {
                    start2 = leadingRanges.get(i);
                    end = leadingRanges.get(i + 1);
                    if (i > 0) {
                        EditorPainter.drawLine(g, leadingRanges.get(i - 1), leadingBottomY, start2, leadingBottomY, rounded);
                    }
                    EditorPainter.drawLine(g, start2, leadingBottomY + (i == 0 ? adjustY : 0), start2, leadingTopY, rounded);
                    if (i + 2 >= leadingRanges.size()) continue;
                    EditorPainter.drawLine(g, start2, leadingTopY, end, leadingTopY, rounded);
                    EditorPainter.drawLine(g, end, leadingTopY, end, leadingBottomY, rounded);
                }
                end = Math.max(end, (float)maxX);
                EditorPainter.drawLine(g, start2, leadingTopY, end, leadingTopY, rounded);
                EditorPainter.drawLine(g, end, leadingTopY, end, trailingTopY - 1, rounded);
                float targetX = trailingRanges.get(trailingRanges.size() - 1);
                EditorPainter.drawLine(g, end, trailingTopY - 1, targetX, trailingTopY - 1, rounded);
                adjustY = end == targetX ? -2 : -1;
                for (int i = trailingRanges.size() - 2; i >= 0; i -= 2) {
                    start2 = trailingRanges.get(i);
                    end = trailingRanges.get(i + 1);
                    EditorPainter.drawLine(g, end, trailingTopY + (i == 0 ? adjustY : 0), end, trailingBottomY, rounded);
                    EditorPainter.drawLine(g, end, trailingBottomY, start2, trailingBottomY, rounded);
                    EditorPainter.drawLine(g, start2, trailingBottomY, start2, trailingTopY, rounded);
                    if (i <= 0) continue;
                    EditorPainter.drawLine(g, start2, trailingTopY, trailingRanges.get(i - 1), trailingTopY, rounded);
                }
                float lastX = start2;
                if (containsInnerLines) {
                    if (start2 != (float)minX) {
                        EditorPainter.drawLine(g, start2, trailingTopY, start2, trailingTopY - 1, rounded);
                        EditorPainter.drawLine(g, start2, trailingTopY - 1, minX, trailingTopY - 1, rounded);
                        EditorPainter.drawLine(g, minX, trailingTopY - 1, minX, leadingBottomY + 1, rounded);
                    } else {
                        EditorPainter.drawLine(g, minX, trailingTopY, minX, leadingBottomY + 1, rounded);
                    }
                    lastX = minX;
                }
                if (lastX < (targetX = leadingRanges.get(0))) {
                    EditorPainter.drawLine(g, lastX, leadingBottomY + 1, targetX, leadingBottomY + 1, rounded);
                } else {
                    EditorPainter.drawLine(g, lastX, leadingBottomY + 1, lastX, leadingBottomY, rounded);
                    EditorPainter.drawLine(g, lastX, leadingBottomY, targetX, leadingBottomY, rounded);
                }
            }
        }
    }

    private void drawSimpleBorder(Graphics2D g, float xStart, float xEnd, float y, boolean rounded) {
        Shape border = EditorPainter.getBorderShape(xStart, y, xEnd - xStart, this.myView.getLineHeight(), 1, rounded);
        if (border != null) {
            Object old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fill(border);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
    }

    private static Shape getBorderShape(float x, float y, float width, int height, int thickness, boolean rounded) {
        if (width <= 0.0f || height <= 0) {
            return null;
        }
        RectangularShape outer = rounded ? new RoundRectangle2D.Float(x, y, width, height, 2.0f, 2.0f) : new Rectangle2D.Float(x, y, width, height);
        int doubleThickness = 2 * thickness;
        if (width <= (float)doubleThickness || height <= doubleThickness) {
            return outer;
        }
        Rectangle2D.Float inner = new Rectangle2D.Float(x + (float)thickness, y + (float)thickness, width - (float)doubleThickness, height - doubleThickness);
        Path2D.Float path = new Path2D.Float(0);
        path.append(outer, false);
        path.append(inner, false);
        return path;
    }

    private static void drawLine(Graphics2D g, float x1, int y1, float x2, int y2, boolean rounded) {
        if (rounded) {
            UIUtil.drawLinePickedOut((Graphics)g, (int)((int)x1), (int)y1, (int)((int)x2), (int)y2);
        } else {
            LinePainter2D.paint((Graphics2D)g, (double)((int)x1), (double)y1, (double)((int)x2), (double)y2);
        }
    }

    private TFloatArrayList adjustedLogicalRangeToVisualRanges(int startOffset, int endOffset) {
        TFloatArrayList ranges = this.logicalRangeToVisualRanges(startOffset, endOffset);
        for (int i = 0; i < ranges.size() - 1; i += 2) {
            float endX;
            float startX = ranges.get(i);
            if (startX == (endX = ranges.get(i + 1))) {
                if (startX > 0.0f) {
                    startX -= 1.0f;
                } else {
                    endX += 1.0f;
                }
            } else {
                endX -= 1.0f;
            }
            ranges.set(i, startX);
            ranges.set(i + 1, endX);
        }
        return ranges;
    }

    private TFloatArrayList logicalRangeToVisualRanges(int startOffset, int endOffset) {
        assert (startOffset <= endOffset);
        TFloatArrayList result2 = new TFloatArrayList();
        if (this.myDocument.getTextLength() == 0) {
            int minX = this.myCorrector.emptyTextX();
            result2.add((float)minX);
            result2.add((float)minX);
        } else {
            float lastX = -1.0f;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, startOffset, false, true)) {
                float x2;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (startOffset == endOffset) {
                    lastX = fragment.getEndX();
                    Inlay inlay = fragment.getCurrentInlay();
                    if (inlay != null && !inlay.isRelatedToPrecedingText() || startOffset < minOffset || startOffset >= maxOffset) continue;
                    float x = fragment.offsetToX(startOffset);
                    result2.add(x);
                    result2.add(x);
                    break;
                }
                if (startOffset >= maxOffset || endOffset <= minOffset) continue;
                float x1 = minOffset == maxOffset ? fragment.getStartX() : fragment.offsetToX(Math.max(minOffset, startOffset));
                float f = x2 = minOffset == maxOffset ? fragment.getEndX() : fragment.offsetToX(Math.min(maxOffset, endOffset));
                if (x1 > x2) {
                    float tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                if (result2.isEmpty() || x1 > result2.get(result2.size() - 1)) {
                    result2.add(x1);
                    result2.add(x2);
                    continue;
                }
                result2.set(result2.size() - 1, x2);
            }
            if (startOffset == endOffset && result2.isEmpty() && lastX >= 0.0f) {
                result2.add(lastX);
                result2.add(lastX);
            }
        }
        return result2;
    }

    private void paintComposedTextDecoration(Graphics2D g, int yShift) {
        TextRange composedTextRange = this.myEditor.getComposedTextRange();
        if (composedTextRange != null) {
            Point2D p1 = this.myView.offsetToXY(Math.min(composedTextRange.getStartOffset(), this.myDocument.getTextLength()), true, false);
            Point2D p2 = this.myView.offsetToXY(Math.min(composedTextRange.getEndOffset(), this.myDocument.getTextLength()), false, true);
            int y = (int)p1.getY() + this.myView.getAscent() + 1 + yShift;
            g.setStroke(IME_COMPOSED_TEXT_UNDERLINE_STROKE);
            g.setColor(this.myEditor.getColorsScheme().getDefaultForeground());
            LinePainter2D.paint((Graphics2D)g, (double)((int)p1.getX()), (double)y, (double)((int)p2.getX()), (double)y);
        }
    }

    private void paintBlockInlays(Graphics2D g, int yShift, int startVisualLine, int endVisualLine) {
        int visualLine;
        if (!this.myEditor.getInlayModel().hasBlockElements()) {
            return;
        }
        int lineCount = this.myEditor.getVisibleLineCount();
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= endVisualLine && visualLine < lineCount) {
            int y;
            int curY = y = visLinesIterator.getY() + yShift;
            List<Inlay> inlaysAbove = visLinesIterator.getBlockInlaysAbove();
            for (Inlay inlay : inlaysAbove) {
                int height = inlay.getHeightInPixels();
                int newY = curY - height;
                inlay.getRenderer().paint(inlay, (Graphics)g, new Rectangle(0, newY, inlay.getWidthInPixels(), height), TextAttributes.ERASE_MARKER);
                curY = newY;
            }
            curY = y + this.myEditor.getLineHeight();
            List<Inlay> inlaysBelow = visLinesIterator.getBlockInlaysBelow();
            for (Inlay inlay : inlaysBelow) {
                int height = inlay.getHeightInPixels();
                inlay.getRenderer().paint(inlay, (Graphics)g, new Rectangle(0, curY, inlay.getWidthInPixels(), height), TextAttributes.ERASE_MARKER);
                curY += height;
            }
            visLinesIterator.advance();
        }
    }

    private void paintCaret(Graphics2D g_, int yShift) {
        EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations(true);
        if (locations == null) {
            return;
        }
        Graphics2D g = IdeBackgroundUtil.getOriginalGraphics(g_);
        int nominalLineHeight = this.myView.getNominalLineHeight();
        int topOverhang = this.myView.getTopOverhang();
        EditorSettings settings = this.myEditor.getSettings();
        Color caretColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        if (caretColor == null) {
            caretColor = new JBColor(CARET_DARK, CARET_LIGHT);
        }
        int minX = this.myView.getInsets().left;
        for (EditorImpl.CaretRectangle location : locations) {
            float x = location.myPoint.x;
            int y = location.myPoint.y - topOverhang + yShift;
            Caret caret = location.myCaret;
            CaretVisualAttributes attr = caret == null ? CaretVisualAttributes.DEFAULT : caret.getVisualAttributes();
            g.setColor(attr.getColor() != null ? attr.getColor() : caretColor);
            boolean isRtl = location.myIsRtl;
            if (this.myEditor.isInsertMode() != settings.isBlockCursor()) {
                int lineWidth = JBUI.scale((int)attr.getWidth(settings.getLineCursorWidth()));
                if (x > (float)minX && lineWidth > 1) {
                    x -= 1.0f / JBUI.sysScale((Graphics2D)g);
                }
                g.fill(new Rectangle2D.Float(x, y, lineWidth, nominalLineHeight));
                if (this.myDocument.getTextLength() <= 0 || caret == null || this.myView.getTextLayoutCache().getLineLayout(caret.getLogicalPosition().line).isLtr()) continue;
                GeneralPath triangle = new GeneralPath(1, 3);
                triangle.moveTo(isRtl ? x + (float)lineWidth : x, y);
                triangle.lineTo(isRtl ? x + (float)lineWidth - 5.0f : x + 5.0f, y);
                triangle.lineTo(isRtl ? x + (float)lineWidth : x, y + 5);
                triangle.closePath();
                g.fill(triangle);
                continue;
            }
            int width = location.myWidth;
            float startX = Math.max((float)minX, isRtl ? x - (float)width : x);
            g.fill(new Rectangle2D.Float(startX, y, width, nominalLineHeight));
            if (this.myDocument.getTextLength() <= 0 || caret == null) continue;
            int targetVisualColumn = caret.getVisualPosition().column - (isRtl ? 1 : 0);
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, caret.getVisualLineStart(), false)) {
                if (fragment.getCurrentInlay() != null) continue;
                int startVisualColumn = fragment.getStartVisualColumn();
                int endVisualColumn = fragment.getEndVisualColumn();
                if (startVisualColumn > targetVisualColumn || targetVisualColumn >= endVisualColumn) continue;
                g.setColor(ColorUtil.isDark((Color)caretColor) ? CARET_LIGHT : CARET_DARK);
                fragment.draw(g, startX, y + topOverhang + this.myView.getAscent(), fragment.visualColumnToOffset(targetVisualColumn - startVisualColumn), fragment.visualColumnToOffset(targetVisualColumn + 1 - startVisualColumn));
                break;
            }
            ComplexTextFragment.flushDrawingCache(g);
        }
    }

    void repaintCarets() {
        EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations(false);
        if (locations == null) {
            return;
        }
        int nominalLineHeight = this.myView.getNominalLineHeight();
        int topOverhang = this.myView.getTopOverhang();
        for (EditorImpl.CaretRectangle location : locations) {
            int x = location.myPoint.x;
            int y = location.myPoint.y - topOverhang;
            int width = Math.max(location.myWidth, 5);
            this.myEditor.getContentComponent().repaintEditorComponentExact(x - width, y, width * 2, nominalLineHeight);
        }
    }

    private void paintLineFragments(Graphics2D g, Rectangle clip, VisualLinesIterator visLineIterator, IterationState.CaretData caretData, int y, LineFragmentPainter painter, MarginWidthConsumer marginWidthConsumer) {
        int endLogicalColumn;
        int visualLine = visLineIterator.getVisualLine();
        float x = this.myCorrector.startX(visualLine) + (visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
        int offset = visLineIterator.getVisualLineStartOffset();
        int visualLineEndOffset = visLineIterator.getVisualLineEndOffset();
        IterationState it = null;
        int prevEndOffset = -1;
        boolean firstFragment = true;
        int maxColumn = 0;
        int marginColumns = this.myEditor.getSettings().getRightMargin(this.myEditor.getProject());
        int endLogicalLine = visLineIterator.getEndLogicalLine();
        boolean marginReached = false;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visLineIterator, null, true)) {
            FoldRegion foldRegion;
            int fragmentStartOffset;
            int start2 = fragmentStartOffset = fragment.getStartOffset();
            int end = fragment.getEndOffset();
            x = fragment.getStartX();
            if (firstFragment) {
                boolean hasSoftWrap;
                firstFragment = false;
                SoftWrap softWrap = this.myEditor.getSoftWrapModel().getSoftWrap(offset);
                boolean bl = hasSoftWrap = softWrap != null;
                if (hasSoftWrap || this.myEditor.isRightAligned()) {
                    prevEndOffset = offset;
                    it = new IterationState(this.myEditor, offset == 0 ? 0 : DocumentUtil.getPreviousCodePointOffset(this.myDocument, offset), visualLineEndOffset, caretData, false, false, false, false);
                    if (it.getEndOffset() <= offset) {
                        it.advance();
                    }
                    if ((double)x >= clip.getMinX()) {
                        TextAttributes attributes = it.getStartOffset() == offset ? it.getBeforeLineStartBackgroundAttributes() : it.getMergedAttributes();
                        painter.paintBeforeLineStart(g, attributes, hasSoftWrap, fragment.getStartVisualColumn(), x, y);
                    }
                }
            }
            if ((foldRegion = fragment.getCurrentFoldRegion()) == null) {
                if (start2 != prevEndOffset) {
                    it = new IterationState(this.myEditor, start2, fragment.isRtl() ? offset : visualLineEndOffset, caretData, false, false, false, fragment.isRtl());
                }
                prevEndOffset = end;
                assert (it != null);
                if (start2 == end) {
                    if (start2 == it.getEndOffset() && !it.atEnd()) {
                        it.advance();
                    }
                    TextAttributes attributes = it.getStartOffset() == start2 ? it.getBreakAttributes() : it.getMergedAttributes();
                    float xNew = fragment.getEndX();
                    if ((double)xNew >= clip.getMinX()) {
                        painter.paint(g, fragment, 0, 0, attributes, x, xNew, y);
                    }
                    x = xNew;
                } else {
                    while (fragment.isRtl() ? start2 > end : start2 < end) {
                        if (fragment.isRtl() ? it.getEndOffset() >= start2 : it.getEndOffset() <= start2) {
                            assert (!it.atEnd());
                            it.advance();
                        }
                        TextAttributes attributes = it.getMergedAttributes();
                        int curEnd = fragment.isRtl() ? Math.max(it.getEndOffset(), end) : Math.min(it.getEndOffset(), end);
                        float xNew = fragment.offsetToX(x, start2, curEnd);
                        if ((double)xNew >= clip.getMinX()) {
                            painter.paint(g, fragment, fragment.isRtl() ? fragmentStartOffset - start2 : start2 - fragmentStartOffset, fragment.isRtl() ? fragmentStartOffset - curEnd : curEnd - fragmentStartOffset, attributes, x, xNew, y);
                        }
                        x = xNew;
                        start2 = curEnd;
                    }
                    if (marginWidthConsumer != null && fragment.getEndLogicalLine() == endLogicalLine && fragment.getStartLogicalColumn() <= marginColumns && fragment.getEndLogicalColumn() > marginColumns) {
                        marginWidthConsumer.process(fragment.visualColumnToX(fragment.logicalToVisualColumn(marginColumns)));
                        marginReached = true;
                    }
                }
            } else {
                float xNew = fragment.getEndX();
                if ((double)xNew >= clip.getMinX()) {
                    painter.paint(g, fragment, 0, fragment.getVisualLength(), this.getFoldRegionAttributes(foldRegion), x, xNew, y);
                }
                x = xNew;
                prevEndOffset = -1;
                it = null;
            }
            if ((double)x > clip.getMaxX()) {
                return;
            }
            maxColumn = fragment.getEndVisualColumn();
        }
        if (firstFragment && this.myEditor.isRightAligned()) {
            it = new IterationState(this.myEditor, offset, visualLineEndOffset, caretData, false, false, false, false);
            if (it.getEndOffset() <= offset) {
                it.advance();
            }
            painter.paintBeforeLineStart(g, it.getBeforeLineStartBackgroundAttributes(), false, maxColumn, x, y);
        }
        if (it == null || it.getEndOffset() != visualLineEndOffset) {
            it = new IterationState(this.myEditor, visualLineEndOffset == offset ? visualLineEndOffset : DocumentUtil.getPreviousCodePointOffset(this.myDocument, visualLineEndOffset), visualLineEndOffset, caretData, false, false, false, false);
        }
        if (!it.atEnd()) {
            it.advance();
        }
        assert (it.atEnd());
        painter.paintAfterLineEnd(g, clip, it, maxColumn, x, y);
        if (marginWidthConsumer != null && !marginReached && (visualLine == this.myEditor.getCaretModel().getVisualPosition().line || x > (float)marginColumns * this.myView.getPlainSpaceWidth()) && (endLogicalColumn = this.myView.offsetToLogicalPosition((int)visualLineEndOffset).column) <= marginColumns) {
            marginWidthConsumer.process(x + (float)(marginColumns - endLogicalColumn) * this.myView.getPlainSpaceWidth());
        }
    }

    private TextAttributes getFoldRegionAttributes(FoldRegion foldRegion) {
        TextAttributes selectionAttributes = EditorPainter.isSelected(foldRegion) ? this.myEditor.getSelectionModel().getTextAttributes() : null;
        TextAttributes foldAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
        TextAttributes defaultAttributes = this.getDefaultAttributes();
        return EditorPainter.mergeAttributes(EditorPainter.mergeAttributes(selectionAttributes, foldAttributes), defaultAttributes);
    }

    private TextAttributes getDefaultAttributes() {
        TextAttributes attributes = this.myEditor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (attributes.getForegroundColor() == null) {
            attributes.setForegroundColor(Color.black);
        }
        if (attributes.getBackgroundColor() == null) {
            attributes.setBackgroundColor(Color.white);
        }
        return attributes;
    }

    private static boolean isSelected(FoldRegion foldRegion) {
        int regionStart = foldRegion.getStartOffset();
        int regionEnd = foldRegion.getEndOffset();
        int[] selectionStarts = foldRegion.getEditor().getSelectionModel().getBlockSelectionStarts();
        int[] selectionEnds = foldRegion.getEditor().getSelectionModel().getBlockSelectionEnds();
        for (int i = 0; i < selectionStarts.length; ++i) {
            int start2 = selectionStarts[i];
            int end = selectionEnds[i];
            if (regionStart < start2 || regionEnd > end) continue;
            return true;
        }
        return false;
    }

    private static TextAttributes mergeAttributes(TextAttributes primary, TextAttributes secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        return new TextAttributes(primary.getForegroundColor() == null ? secondary.getForegroundColor() : primary.getForegroundColor(), primary.getBackgroundColor() == null ? secondary.getBackgroundColor() : primary.getBackgroundColor(), primary.getEffectColor() == null ? secondary.getEffectColor() : primary.getEffectColor(), primary.getEffectType() == null ? secondary.getEffectType() : primary.getEffectType(), primary.getFontType() == 0 ? secondary.getFontType() : primary.getFontType());
    }

    @Override
    public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start2, int end, int x, int y, Color color, FontInfo fontInfo) {
        if (g == null) {
            EditorPainter.$$$reportNull$$$0(5);
        }
        if (data == null) {
            EditorPainter.$$$reportNull$$$0(6);
        }
        g.setFont(fontInfo.getFont());
        g.setColor(color);
        g.drawChars(data, start2, end - start2, x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarginShown";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInnerHighlighterAttributes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectVisibleInnerHighlighters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "drawChars";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MarginPositions {
        private final float[] x;
        private final int[] y;

        private MarginPositions(int size) {
            this.x = new float[size];
            this.y = new int[size];
        }
    }

    private static class LineExtensionData {
        private final LineExtensionInfo info;
        private final LineLayout layout;

        private LineExtensionData(LineExtensionInfo info, LineLayout layout) {
            this.info = info;
            this.layout = layout;
        }
    }

    private static interface XCorrector {
        public float startX(int var1);

        public int lineWidth(int var1, float var2);

        public int emptyTextX();

        public int minX(int var1, int var2);

        public int maxX(int var1, int var2);

        public int lineSeparatorStart(int var1);

        public int lineSeparatorEnd(int var1);

        public float singleLineBorderStart(float var1);

        public float singleLineBorderEnd(float var1);

        public int marginX(float var1);

        public List<Integer> softMarginsX();

        @NotNull
        default public XCorrector align(@NotNull EditorView view) {
            boolean rightAligned;
            if (view == null) {
                XCorrector.$$$reportNull$$$0(0);
            }
            XCorrector xCorrector = (rightAligned = view.getEditor().isRightAligned()) && this instanceof RightAligned || !rightAligned && this instanceof LeftAligned ? this : XCorrector.create(view);
            if (xCorrector == null) {
                XCorrector.$$$reportNull$$$0(1);
            }
            return xCorrector;
        }

        @NotNull
        public static XCorrector create(@NotNull EditorView view) {
            if (view == null) {
                XCorrector.$$$reportNull$$$0(2);
            }
            XCorrector xCorrector = view.getEditor().isRightAligned() ? new RightAligned(view) : new LeftAligned(view);
            if (xCorrector == null) {
                XCorrector.$$$reportNull$$$0(3);
            }
            return xCorrector;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "align";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "align";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class RightAligned
        implements XCorrector {
            private final EditorView myView;

            private RightAligned(@NotNull EditorView view) {
                if (view == null) {
                    RightAligned.$$$reportNull$$$0(0);
                }
                this.myView = view;
            }

            @Override
            public float startX(int line) {
                return this.myView.getRightAlignmentLineStartX(line);
            }

            @Override
            public int lineWidth(int line, float x) {
                return (int)(x - this.myView.getRightAlignmentLineStartX(line));
            }

            @Override
            public int emptyTextX() {
                return this.myView.getRightAlignmentMarginX();
            }

            @Override
            public int minX(int startLine, int endLine) {
                return this.myView.getRightAlignmentMarginX() - this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
            }

            @Override
            public int maxX(int startLine, int endLine) {
                return this.myView.getRightAlignmentMarginX() - 1;
            }

            @Override
            public float singleLineBorderStart(float x) {
                return x - 1.0f;
            }

            @Override
            public float singleLineBorderEnd(float x) {
                return x;
            }

            @Override
            public int lineSeparatorStart(int minX) {
                return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.max(this.marginX(EditorPainter.getBaseMarginWidth(this.myView)), minX) : minX;
            }

            @Override
            public int lineSeparatorEnd(int maxX) {
                return maxX;
            }

            @Override
            public int marginX(float marginWidth) {
                return (int)((float)this.myView.getRightAlignmentMarginX() - marginWidth);
            }

            @Override
            public List<Integer> softMarginsX() {
                List margins = this.myView.getEditor().getSettings().getSoftMargins();
                ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
                for (Integer margin : margins) {
                    result2.add((int)((float)this.myView.getRightAlignmentMarginX() - (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector$RightAligned", "<init>"));
            }
        }

        public static class LeftAligned
        implements XCorrector {
            private final EditorView myView;

            private LeftAligned(@NotNull EditorView view) {
                if (view == null) {
                    LeftAligned.$$$reportNull$$$0(0);
                }
                this.myView = view;
            }

            @Override
            public float startX(int line) {
                return this.myView.getInsets().left;
            }

            @Override
            public int emptyTextX() {
                return this.myView.getInsets().left;
            }

            @Override
            public int minX(int startLine, int endLine) {
                return this.myView.getInsets().left;
            }

            @Override
            public int maxX(int startLine, int endLine) {
                return this.minX(startLine, endLine) + this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
            }

            @Override
            public float singleLineBorderStart(float x) {
                return x;
            }

            @Override
            public float singleLineBorderEnd(float x) {
                return x + 1.0f;
            }

            @Override
            public int lineWidth(int line, float x) {
                return (int)x - this.myView.getInsets().left;
            }

            @Override
            public int lineSeparatorStart(int maxX) {
                return this.myView.getInsets().left;
            }

            @Override
            public int lineSeparatorEnd(int maxX) {
                return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.min(this.marginX(EditorPainter.getBaseMarginWidth(this.myView)), maxX) : maxX;
            }

            @Override
            public int marginX(float marginWidth) {
                return (int)((float)this.myView.getInsets().left + marginWidth);
            }

            @Override
            public List<Integer> softMarginsX() {
                List margins = this.myView.getEditor().getSettings().getSoftMargins();
                ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
                for (Integer margin : margins) {
                    result2.add((int)((float)this.myView.getInsets().left + (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector$LeftAligned", "<init>"));
            }
        }
    }

    private static class LineWhitespacePaintingStrategy {
        private final boolean myWhitespaceShown;
        private final boolean myLeadingWhitespaceShown;
        private final boolean myInnerWhitespaceShown;
        private final boolean myTrailingWhitespaceShown;
        private int currentLeadingEdge;
        private int currentTrailingEdge;

        LineWhitespacePaintingStrategy(EditorSettings settings) {
            this.myWhitespaceShown = settings.isWhitespacesShown();
            this.myLeadingWhitespaceShown = settings.isLeadingWhitespaceShown();
            this.myInnerWhitespaceShown = settings.isInnerWhitespaceShown();
            this.myTrailingWhitespaceShown = settings.isTrailingWhitespaceShown();
        }

        private void update(CharSequence chars, int lineStart, int lineEnd) {
            if (!(!this.myWhitespaceShown || !this.myLeadingWhitespaceShown && !this.myInnerWhitespaceShown && !this.myTrailingWhitespaceShown || this.myLeadingWhitespaceShown && this.myInnerWhitespaceShown && this.myTrailingWhitespaceShown)) {
                this.currentTrailingEdge = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineStart, (int)(lineEnd - 1), (String)EditorPainter.WHITESPACE_CHARS) + 1;
                this.currentLeadingEdge = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (int)this.currentTrailingEdge, (String)EditorPainter.WHITESPACE_CHARS);
            }
        }

        private boolean showWhitespaceAtOffset(int offset) {
            return this.myWhitespaceShown && (offset < this.currentLeadingEdge ? this.myLeadingWhitespaceShown : (offset >= this.currentTrailingEdge ? this.myTrailingWhitespaceShown : this.myInnerWhitespaceShown));
        }
    }

    static interface LineFragmentPainter {
        public void paintBeforeLineStart(Graphics2D var1, TextAttributes var2, boolean var3, int var4, float var5, int var6);

        public void paint(Graphics2D var1, VisualLineFragmentsIterator.Fragment var2, int var3, int var4, TextAttributes var5, float var6, float var7, int var8);

        public void paintAfterLineEnd(Graphics2D var1, Rectangle var2, IterationState var3, int var4, float var5, int var6);
    }

    private static interface MarginWidthConsumer {
        public void process(float var1);
    }
}

