/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.Patches;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.featureStatistics.fusCollectors.AppLifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.CommandLineApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.ui.Splash;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.layout.PlatformDefaults;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaApplication {
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    public static final String IDEA_IS_UNIT_TEST = "idea.is.unit.test";
    private static final String[] SAFE_JAVA_ENV_PARAMETERS = new String[]{"idea.required.plugins.id"};
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.IdeaApplication");
    private static IdeaApplication ourInstance;
    @NotNull
    private final String[] myArgs;
    private static boolean myPerformProjectLoad;
    private ApplicationStarter myStarter;
    private volatile boolean myLoaded;

    public static IdeaApplication getInstance() {
        return ourInstance;
    }

    public static boolean isLoaded() {
        return ourInstance != null && IdeaApplication.ourInstance.myLoaded;
    }

    public static void initApplication(String[] args) {
        IdeaApplication app = new IdeaApplication(args);
        SwingUtilities.invokeLater(() -> {
            PluginManager.installExceptionHandler();
            app.run();
        });
    }

    public IdeaApplication(@NotNull String[] args) {
        if (args == null) {
            IdeaApplication.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(ourInstance == null);
        ourInstance = this;
        this.myArgs = IdeaApplication.processProgramArguments(args);
        boolean isInternal = Boolean.getBoolean(IDEA_IS_INTERNAL_PROPERTY);
        boolean isUnitTest = Boolean.getBoolean(IDEA_IS_UNIT_TEST);
        boolean headless = Main.isHeadless();
        IdeaApplication.patchSystem(headless);
        if (Main.isCommandLine()) {
            if (CommandLineApplication.ourInstance == null) {
                new CommandLineApplication(isInternal, isUnitTest, headless);
            }
            if (isUnitTest) {
                this.myLoaded = true;
            }
        } else {
            Splash splash = null;
            this.myStarter = this.getStarter();
            if (this.myStarter instanceof IdeStarter) {
                splash = ((IdeStarter)this.myStarter).showSplash(this.myArgs);
            }
            ApplicationManagerEx.createApplication(isInternal, isUnitTest, false, false, "idea", splash);
        }
        if (this.myStarter == null) {
            this.myStarter = this.getStarter();
        }
        if (headless && this.myStarter instanceof ApplicationStarterEx && !((ApplicationStarterEx)this.myStarter).isHeadless()) {
            Main.showMessage((String)"Startup Error", (String)"Application cannot start in headless mode", (boolean)true);
            System.exit(1);
        }
        this.myStarter.premain(args);
    }

    @NotNull
    private static String[] processProgramArguments(@NotNull String[] args) {
        if (args == null) {
            IdeaApplication.$$$reportNull$$$0(1);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        List<String> safeKeys = Arrays.asList(SAFE_JAVA_ENV_PARAMETERS);
        for (String arg : args) {
            String[] keyValue;
            if (arg.startsWith("-D") && (keyValue = arg.substring(2).split("=")).length == 2 && safeKeys.contains(keyValue[0])) {
                System.setProperty(keyValue[0], keyValue[1]);
                continue;
            }
            arguments.add(arg);
        }
        String[] stringArray = ArrayUtil.toStringArray(arguments);
        if (stringArray == null) {
            IdeaApplication.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static void patchSystem(boolean headless) {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)headless);
        LOG.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        System.setProperty("sun.awt.noerasebackground", "true");
        IdeEventQueue.getInstance();
        if (headless) {
            return;
        }
        if (Patches.REPAINT_MANAGER_LEAK) {
            RepaintManager.setCurrentManager(new IdeRepaintManager());
        }
        if (SystemInfo.isXWindow) {
            String wmName = X11UiUtil.getWmName();
            LOG.info("WM detected: " + wmName);
            if (wmName != null) {
                X11UiUtil.patchDetectedWm(wmName);
            }
        }
        PlatformDefaults.setLogicalPixelBase((int)100);
        IconLoader.activate();
        new JFrame().pack();
    }

    @NotNull
    public ApplicationStarter getStarter() {
        if (this.myArgs.length > 0) {
            PluginManagerCore.getPlugins();
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.appStarter");
            ApplicationStarter[] starters = (ApplicationStarter[])point.getExtensions();
            String key = this.myArgs[0];
            for (ApplicationStarter o : starters) {
                if (!Comparing.equal((String)o.getCommandName(), (String)key)) continue;
                ApplicationStarter applicationStarter = o;
                if (applicationStarter == null) {
                    IdeaApplication.$$$reportNull$$$0(3);
                }
                return applicationStarter;
            }
        }
        IdeStarter ideStarter = new IdeStarter();
        if (ideStarter == null) {
            IdeaApplication.$$$reportNull$$$0(4);
        }
        return ideStarter;
    }

    public void run() {
        try {
            ApplicationManagerEx.getApplicationEx().load();
            this.myLoaded = true;
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> this.myStarter.main(this.myArgs));
            this.myStarter = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initLAF() {
        try {
            Class.forName("com.jgoodies.looks.plastic.PlasticLookAndFeel");
            if (SystemInfo.isWindows) {
                UIManager.installLookAndFeel("JGoodies Windows L&F", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            }
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.myLoaded = false;
        IdeEventQueue.applicationClose();
        ShutDownTracker.getInstance().run();
    }

    @NotNull
    public String[] getCommandLineArguments() {
        if (this.myArgs == null) {
            IdeaApplication.$$$reportNull$$$0(5);
        }
        return this.myArgs;
    }

    public void disableProjectLoad() {
        myPerformProjectLoad = false;
    }

    static {
        myPerformProjectLoad = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaApplication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaApplication";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processProgramArguments";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStarter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processProgramArguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IdeStarter
    extends ApplicationStarterEx {
        private Splash mySplash;

        public boolean isHeadless() {
            return false;
        }

        public String getCommandName() {
            return null;
        }

        public void premain(String[] args) {
            IdeaApplication.initLAF();
        }

        @Nullable
        private Splash showSplash(String[] args) {
            if (StartupUtil.shouldShowSplash(args)) {
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                SplashScreen splashScreen = IdeStarter.getSplashScreen();
                if (splashScreen == null) {
                    this.mySplash = new Splash(appInfo);
                    this.mySplash.show();
                    return this.mySplash;
                }
                IdeStarter.updateSplashScreen(appInfo, splashScreen);
            }
            return null;
        }

        private static void updateSplashScreen(@NotNull ApplicationInfoEx appInfo, @NotNull SplashScreen splashScreen) {
            if (appInfo == null) {
                IdeStarter.$$$reportNull$$$0(0);
            }
            if (splashScreen == null) {
                IdeStarter.$$$reportNull$$$0(1);
            }
            Graphics2D graphics = splashScreen.createGraphics();
            Dimension size = splashScreen.getSize();
            if (Splash.showLicenseeInfo(graphics, 0, 0, size.height, appInfo.getSplashTextColor(), appInfo)) {
                splashScreen.update();
            }
        }

        @Nullable
        private static SplashScreen getSplashScreen() {
            try {
                return SplashScreen.getSplashScreen();
            }
            catch (Throwable t) {
                LOG.warn(t);
                return null;
            }
        }

        public boolean canProcessExternalCommandLine() {
            return true;
        }

        public void processExternalCommandLine(@NotNull String[] args, @Nullable String currentDirectory) {
            if (args == null) {
                IdeStarter.$$$reportNull$$$0(2);
            }
            LOG.info("Request to open in " + currentDirectory + " with parameters: " + StringUtil.join((String[])args, (String)","));
            if (args.length > 0) {
                VirtualFile virtualFile;
                String filename = args[0];
                File file2 = new File(currentDirectory, filename);
                if (file2.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2)) != null) {
                    int line = -1;
                    if (args.length > 2 && "--line".equals(args[1])) {
                        try {
                            line = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException ex) {
                            LOG.error("Wrong line number:" + args[2]);
                        }
                    }
                    EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
                    PlatformProjectOpenProcessor.doOpenProject(virtualFile, null, line, null, options);
                }
                throw new IncorrectOperationException("Can't find file:" + file2);
            }
        }

        private static Project loadProjectFromExternalCommandLine(String[] args) {
            Project project = null;
            if (args != null && args.length > 0 && args[0] != null) {
                LOG.info("IdeaApplication.loadProject");
                project = CommandLineProcessor.processExternalCommandLine(Arrays.asList(args), null);
            }
            return project;
        }

        public void main(String[] args) {
            SystemDock.updateMenu();
            RecentProjectsManager.getInstance();
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
            IdeEventQueue.getInstance().setWindowManager(windowManager);
            Ref willOpenProject = new Ref((Object)Boolean.FALSE);
            AppLifecycleListener lifecyclePublisher = (AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecyclePublisher.appFrameCreated(args, (Ref<Boolean>)willOpenProject);
            LOG.info("App initialization took " + (System.nanoTime() - PluginManager.startupStart) / 1000000L + " ms");
            PluginManagerCore.dumpPluginClassStatistics();
            if (Registry.is((String)"ide.popup.enablePopupType")) {
                System.setProperty("jbre.popupwindow.settype", "true");
            }
            if (JetBrainsProtocolHandler.getCommand() != null || !((Boolean)willOpenProject.get()).booleanValue()) {
                WelcomeFrame.showNow();
                lifecyclePublisher.welcomeScreenDisplayed();
            } else {
                windowManager.showFrame();
            }
            if (this.mySplash != null) {
                app.invokeLater(() -> {
                    this.mySplash.dispose();
                    this.mySplash = null;
                }, ModalityState.any());
            }
            TransactionGuard.submitTransaction((Disposable)app, () -> {
                Project projectFromCommandLine = myPerformProjectLoad ? IdeStarter.loadProjectFromExternalCommandLine(args) : null;
                ((AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).appStarting(projectFromCommandLine);
                SwingUtilities.invokeLater(PluginManager::reportPluginError);
                FUSApplicationUsageTrigger.getInstance().trigger(AppLifecycleUsageTriggerCollector.class, "ide.start");
                FeatureUsageLogger.INSTANCE.log("lifecycle", "app.started");
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splashScreen";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/IdeaApplication$IdeStarter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSplashScreen";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processExternalCommandLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

