/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.BundleBase;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectTask;
import com.intellij.find.impl.FindResultUsageInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectUtil {
    private static final int USAGES_PER_READ_ACTION = 100;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(@NotNull FindModel model, @NotNull DataContext dataContext) {
        Module module;
        VirtualFile virtualFile;
        if (model == null) {
            FindInProjectUtil.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project != null && editor == null && !DumbServiceImpl.getInstance(project).isDumb()) {
            try {
                psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if (directoryName == null && (virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && virtualFile.isDirectory()) {
            directoryName = virtualFile.getPresentableUrl();
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model.setModuleName(module.getName());
            model.setDirectoryName(null);
            model.setCustomScope(false);
        }
        if ((model.getModuleName() == null || editor == null) && directoryName != null) {
            model.setDirectoryName(directoryName);
            model.setCustomScope(false);
        }
        if (directoryName == null && module == null && project != null) {
            NamedScope namedScope;
            ChangeList changeList = (ChangeList)ArrayUtil.getFirstElement((Object[])((Object[])dataContext.getData(VcsDataKeys.CHANGE_LISTS)));
            if (changeList == null) {
                Change change = (Change)ArrayUtil.getFirstElement((Object[])((Object[])dataContext.getData(VcsDataKeys.CHANGES)));
                changeList = change == null ? null : ChangeListManager.getInstance((Project)project).getChangeList(change);
            }
            NamedScope namedScope2 = namedScope = changeList == null ? null : ChangeListsScopesProvider.getInstance(project).getCustomScope(changeList.getName());
            if (namedScope != null) {
                model.setCustomScope(true);
                model.setCustomScopeName(namedScope.getName());
                model.setCustomScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope));
            }
        }
        model.setProjectScope(model.getDirectoryName() == null && model.getModuleName() == null && !model.isCustomScope());
    }

    @Deprecated
    @Nullable
    public static PsiDirectory getPsiDirectory(@NotNull FindModel findModel, @NotNull Project project) {
        VirtualFile directory;
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(3);
        }
        return (directory = FindInProjectUtil.getDirectory(findModel)) == null ? null : PsiManager.getInstance((Project)project).findDirectory(directory);
    }

    @Nullable
    public static VirtualFile getDirectory(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(4);
        }
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            VirtualFileSystem[] fileSystems;
            virtualFile = null;
            for (VirtualFileSystem fs : fileSystems = (VirtualFileSystem[])ApplicationManager.getApplication().getComponents(VirtualFileSystem.class)) {
                VirtualFile file2;
                if (!(fs instanceof LocalFileProvider) || (file2 = ((LocalFileProvider)fs).findLocalVirtualFileByPath(path)) == null || !file2.isDirectory()) continue;
                if (file2.getChildren().length > 0) {
                    virtualFile = file2;
                    break;
                }
                if (virtualFile != null) continue;
                virtualFile = file2;
            }
        }
        return virtualFile;
    }

    @NotNull
    public static Condition<CharSequence> createFileMaskCondition(@Nullable String filter) throws PatternSyntaxException {
        if (filter == null) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                FindInProjectUtil.$$$reportNull$$$0(5);
            }
            return condition;
        }
        String pattern = "";
        String negativePattern = "";
        List masks = StringUtil.split((String)filter, (String)",");
        for (String mask : masks) {
            if (StringUtil.startsWith((CharSequence)(mask = mask.trim()), (CharSequence)"!")) {
                negativePattern = negativePattern + (negativePattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask.substring(1)) + ")";
                continue;
            }
            pattern = pattern + (pattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask) + ")";
        }
        if (pattern.isEmpty()) {
            pattern = PatternUtil.convertToRegex((String)"*");
        }
        final String finalPattern = pattern;
        final String finalNegativePattern = negativePattern;
        Condition<CharSequence> condition = new Condition<CharSequence>(){
            final Pattern regExp;
            final Pattern negativeRegExp;
            {
                this.regExp = Pattern.compile(finalPattern, 2);
                this.negativeRegExp = StringUtil.isEmpty((String)finalNegativePattern) ? null : Pattern.compile(finalNegativePattern, 2);
            }

            public boolean value(CharSequence input) {
                return this.regExp.matcher(input).matches() && (this.negativeRegExp == null || !this.negativeRegExp.matcher(input).matches());
            }
        };
        if (condition == null) {
            FindInProjectUtil.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Deprecated
    public static void findUsages(@NotNull FindModel findModel, @Nullable PsiDirectory psiDirectory, @NotNull Project project, @NotNull Processor<? super UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(9);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(10);
        }
        FindInProjectUtil.findUsages(findModel, project, consumer, processPresentation);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project, @NotNull Processor<? super UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(13);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(14);
        }
        FindInProjectUtil.findUsages(findModel, project, processPresentation, Collections.emptySet(), consumer);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Set<? extends VirtualFile> filesToStart, @NotNull Processor<? super UsageInfo> consumer) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(16);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(17);
        }
        if (filesToStart == null) {
            FindInProjectUtil.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(19);
        }
        new FindInProjectTask(findModel, project, filesToStart).findUsages(processPresentation, consumer);
    }

    static int processUsagesInFile(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile, @NotNull FindModel findModel, @NotNull Processor<? super UsageInfo> consumer) {
        int found;
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(21);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(23);
        }
        if (findModel.getStringToFind().isEmpty()) {
            if (!((Boolean)ReadAction.compute(() -> consumer.process((Object)new UsageInfo(psiFile)))).booleanValue()) {
                throw new ProcessCanceledException();
            }
            return 1;
        }
        if (virtualFile.getFileType().isBinary()) {
            return 0;
        }
        Document document = (Document)ReadAction.compute(() -> virtualFile.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null);
        if (document == null) {
            return 0;
        }
        int[] offset = new int[]{0};
        int count = 0;
        ProgressIndicator indicator = ProgressWrapper.unwrap(ProgressManager.getInstance().getProgressIndicator());
        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(indicator);
        do {
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            found = (Integer)ReadAction.compute(() -> {
                if (!psiFile.isValid()) {
                    return 0;
                }
                return FindInProjectUtil.addToUsages(document, findModel, psiFile, offset, 100, consumer);
            });
            count += found;
        } while (found != 0);
        return count;
    }

    private static int addToUsages(@NotNull Document document, @NotNull FindModel findModel, @NotNull PsiFile psiFile, @NotNull int[] offsetRef, int maxUsages, @NotNull Processor<? super UsageInfo> consumer) {
        FindResult result2;
        if (document == null) {
            FindInProjectUtil.$$$reportNull$$$0(24);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(25);
        }
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(26);
        }
        if (offsetRef == null) {
            FindInProjectUtil.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(28);
        }
        int count = 0;
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        int offset = offsetRef[0];
        Project project = psiFile.getProject();
        FindManager findManager = FindManager.getInstance((Project)project);
        while (offset < textLength && (result2 = findManager.findString(text, offset, findModel, psiFile.getVirtualFile())).isStringFound()) {
            TextRange range2;
            SearchScope customScope;
            int prevOffset = offset;
            if (prevOffset == (offset = result2.getEndOffset()) || offset == result2.getStartOffset()) {
                ++offset;
            }
            if ((customScope = findModel.getCustomScope()) instanceof LocalSearchScope && !((LocalSearchScope)customScope).containsRange(psiFile, range2 = new TextRange(result2.getStartOffset(), result2.getEndOffset()))) continue;
            FindResultUsageInfo info = new FindResultUsageInfo(findManager, psiFile, prevOffset, findModel, result2);
            if (!consumer.process((Object)info)) {
                throw new ProcessCanceledException();
            }
            if (maxUsages <= 0 || ++count < maxUsages) continue;
            break;
        }
        offsetRef[0] = offset;
        return count;
    }

    @NotNull
    private static String getTitleForScope(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(29);
        }
        String scopeName = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        String result2 = scopeName;
        if (findModel.getFileFilter() != null) {
            result2 = result2 + " " + FindBundle.message("find.scope.files.with.mask", findModel.getFileFilter());
        }
        String string = result2;
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(31);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        FindInProjectUtil.setupViewPresentation(presentation, toOpenInNewTab, findModel);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(32);
        }
        return usageViewPresentation;
    }

    public static void setupViewPresentation(UsageViewPresentation presentation, boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(33);
        }
        String scope = FindInProjectUtil.getTitleForScope(findModel);
        String stringToFind = findModel.getStringToFind();
        presentation.setScopeText(scope);
        if (stringToFind.isEmpty()) {
            presentation.setTabText("Files");
            presentation.setToolwindowTitle(BundleBase.format((String)"Files in {0}", (Object[])new Object[]{scope}));
            presentation.setUsagesString("files");
        } else {
            FindModel.SearchContext searchContext = findModel.getSearchContext();
            String contextText = "";
            if (searchContext != FindModel.SearchContext.ANY) {
                contextText = FindBundle.message("find.context.presentation.scope.label", FindDialog.getPresentableName(searchContext));
            }
            presentation.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind, contextText));
            presentation.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope, contextText));
            presentation.setUsagesString(FindBundle.message("find.usage.view.usages.text", stringToFind));
            presentation.setUsagesWord(FindBundle.message("occurrence", new Object[0]));
            presentation.setCodeUsagesString(FindBundle.message("found.occurrences", new Object[0]));
            presentation.setContextText(contextText);
        }
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
        if (findModel.isReplaceState() && findModel.isRegularExpressions()) {
            presentation.setSearchPattern(findModel.compileRegExp());
            try {
                presentation.setReplacePattern(Pattern.compile(findModel.getStringToReplace()));
            }
            catch (Exception e) {
                presentation.setReplacePattern(null);
            }
        } else {
            presentation.setSearchPattern(null);
            presentation.setReplacePattern(null);
        }
        presentation.setReplaceMode(findModel.isReplaceState());
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project, boolean showPanelIfOnlyOneUsage, @NotNull UsageViewPresentation presentation) {
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(34);
        }
        if (presentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(35);
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        processPresentation.setProgressIndicatorFactory(() -> new FindProgressIndicator(project, presentation.getScopeText()));
        FindUsagesProcessPresentation findUsagesProcessPresentation = processPresentation;
        if (findUsagesProcessPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(36);
        }
        return findUsagesProcessPresentation;
    }

    private static List<PsiElement> getTopLevelRegExpChars(String regExpText, Project project) {
        PsiElement[] children2;
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("A.regexp", regExpText);
        List<PsiElement> result2 = null;
        for (PsiElement child2 : children2 = file2.getChildren()) {
            PsiElement[] grandChildren = child2.getChildren();
            if (grandChildren.length != 1) {
                return Collections.emptyList();
            }
            for (PsiElement grandGrandChild : grandChildren[0].getChildren()) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiElement>();
                }
                result2.add(grandGrandChild);
            }
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String buildStringToFindForIndicesFromRegExp(@NotNull String stringToFind, @NotNull Project project) {
        if (stringToFind == null) {
            FindInProjectUtil.$$$reportNull$$$0(37);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(38);
        }
        if (!Registry.is((String)"idea.regexp.search.uses.indices")) {
            if ("" == null) {
                FindInProjectUtil.$$$reportNull$$$0(39);
            }
            return "";
        }
        String string = (String)ReadAction.compute(() -> {
            final List<PsiElement> topLevelRegExpChars = FindInProjectUtil.getTopLevelRegExpChars("a", project);
            if (topLevelRegExpChars.size() != 1) {
                return "";
            }
            return StringUtil.join(FindInProjectUtil.getTopLevelRegExpChars(stringToFind, project), (Function)new Function<PsiElement, String>(){
                final Class regExpCharPsiClass;
                {
                    this.regExpCharPsiClass = ((PsiElement)topLevelRegExpChars.get(0)).getClass();
                }

                public String fun(PsiElement element) {
                    String text;
                    if (this.regExpCharPsiClass.isInstance(element) && !(text = element.getText()).startsWith("\\")) {
                        return text;
                    }
                    return " ";
                }
            }, (String)"");
        });
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    public static void initStringToFindFromDataContext(FindModel findModel, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(41);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FindUtil.initStringToFindWithSelection(findModel, editor);
        if (editor == null || !editor.getSelectionModel().hasSelection()) {
            FindUtil.useFindStringFromFindInFileModel(findModel, (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext));
        }
    }

    private static void addSourceDirectoriesFromLibraries(@NotNull Project project, @NotNull VirtualFile directory, @NotNull Collection<? super VirtualFile> outSourceRoots) {
        ProjectFileIndex index;
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(42);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(43);
        }
        if (outSourceRoots == null) {
            FindInProjectUtil.$$$reportNull$$$0(44);
        }
        if (!(index = ProjectFileIndex.SERVICE.getInstance((Project)project)).isInLibraryClasses(directory)) {
            return;
        }
        VirtualFile classRoot = index.getClassRootForFile(directory);
        if (classRoot == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)directory, (VirtualFile)classRoot);
        if (relativePath == null) {
            return;
        }
        THashSet otherSourceRoots = new THashSet();
        block0: for (OrderEntry entry : index.getOrderEntriesForFile(directory)) {
            if (entry instanceof LibraryOrderEntry) {
                String[] sourceUrls;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library == null) continue;
                for (String sourceUrl : sourceUrls = library.getUrls(OrderRootType.SOURCES)) {
                    if (!VfsUtilCore.isEqualOrAncestor((String)sourceUrl, (String)directory.getUrl())) continue;
                    otherSourceRoots.clear();
                    break block0;
                }
            }
            for (VirtualFile sourceRoot : entry.getFiles(OrderRootType.SOURCES)) {
                VirtualFile sourceFile = sourceRoot.findFileByRelativePath(relativePath);
                if (sourceFile == null) continue;
                otherSourceRoots.add(sourceFile);
            }
        }
        outSourceRoots.addAll((Collection<? super VirtualFile>)otherSourceRoots);
    }

    @NotNull
    static SearchScope getScopeFromModel(@NotNull Project project, @NotNull FindModel findModel) {
        Module module;
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(45);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(46);
        }
        SearchScope customScope = findModel.getCustomScope();
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        Module module2 = module = findModel.getModuleName() == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(findModel.getModuleName());
        Object object = findModel.isCustomScope() && customScope != null ? customScope.intersectWith((SearchScope)GlobalSearchScope.allScope((Project)project)) : (directory != null ? FindInProjectUtil.forDirectory(project, findModel.isWithSubdirectories(), directory) : (module != null ? module.getModuleContentScope() : (findModel.isProjectScope() ? ProjectScope.getContentScope((Project)project) : GlobalSearchScope.allScope((Project)project))));
        if (object == null) {
            FindInProjectUtil.$$$reportNull$$$0(47);
        }
        return object;
    }

    @NotNull
    private static GlobalSearchScope forDirectory(@NotNull Project project, boolean withSubdirectories, @NotNull VirtualFile directory) {
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(48);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(49);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        result2.add(directory);
        FindInProjectUtil.addSourceDirectoriesFromLibraries(project, directory, result2);
        VirtualFile[] array = result2.toArray(VirtualFile.EMPTY_ARRAY);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)withSubdirectories, (VirtualFile[])array);
        if (globalSearchScope == null) {
            FindInProjectUtil.$$$reportNull$$$0(50);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 25: 
            case 29: 
            case 31: 
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: 
            case 34: 
            case 38: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 9: 
            case 13: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToStart";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetRef";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileMaskCondition";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForScope";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "setupViewPresentation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setupProcessPresentation";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeFromModel";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "forDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 50: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addToUsages";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTitleForScope";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupViewPresentation";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setupProcessPresentation";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "initStringToFindFromDataContext";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addSourceDirectoriesFromLibraries";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromModel";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "forDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation,
    TypeSafeDataProvider {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final FindModel myFindModel;

        public StringUsageTarget(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                StringUsageTarget.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                StringUsageTarget.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFindModel = findModel.clone();
        }

        @NotNull
        public String getPresentableText() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = presentation.getToolwindowTitle();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getLongDescriptiveName() {
            String string = this.getPresentableText();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String getLocationString() {
            return this.myFindModel + "!!";
        }

        public Icon getIcon(boolean open2) {
            return AllIcons.Actions.Find;
        }

        public void findUsages() {
            FindInProjectManager.getInstance(this.myProject).startFindInProject(this.myFindModel);
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                StringUsageTarget.$$$reportNull$$$0(4);
            }
        }

        public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor, boolean clearHighlights) {
            if (file2 == null) {
                StringUsageTarget.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                StringUsageTarget.$$$reportNull$$$0(6);
            }
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        public String getName() {
            return this.myFindModel.getStringToFind().isEmpty() ? this.myFindModel.getFileFilter() : this.myFindModel.getStringToFind();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void showSettings() {
            Content selectedContent = UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component = selectedContent == null ? null : selectedContent.getComponent();
            FindInProjectManager findInProjectManager = FindInProjectManager.getInstance(this.myProject);
            findInProjectManager.findInProject(DataManager.getInstance().getDataContext((Component)component), this.myFindModel);
        }

        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("FindInPath");
        }

        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                StringUsageTarget.$$$reportNull$$$0(7);
            }
            if (sink == null) {
                StringUsageTarget.$$$reportNull$$$0(8);
            }
            if (UsageView.USAGE_SCOPE.equals(key)) {
                SearchScope scope = FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel);
                sink.put(UsageView.USAGE_SCOPE, (Object)scope);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLongDescriptiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findUsagesInEditor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightUsages";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

