/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPassFactory;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId) {
        PsiFile psiFile;
        Project project;
        Document document;
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = (psiFile = session2.getPsiFile()).getProject())).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        ShowAutoImportPassFactory autoImportPassFactory = (ShowAutoImportPassFactory)project.getComponent(ShowAutoImportPassFactory.class);
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (modificationStamp != document.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
                EditorColorsScheme scheme2 = session2.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project, document, priorityIntersection, scheme2, infos, (MarkupModelEx)markupModel, groupId);
            }
            if (editor != null && !editor.isDisposed()) {
                TextEditorHighlightingPass highlightingPass;
                if (!DumbService.isDumb((Project)project) && (highlightingPass = autoImportPassFactory.createHighlightingPass(psiFile, editor)) != null) {
                    highlightingPass.doApplyInformationToEditor();
                }
                ErrorStripeUpdateManager.getInstance(project).repaintErrorStripePanel(editor);
            }
        });
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        PsiFile psiFile;
        Project project;
        Document document;
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(4);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(5);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(6);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(7);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = (psiFile = session2.getPsiFile()).getProject())).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (project.isDisposed() || modificationStamp != document.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme2 = session2.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project, document, psiFile, infos, scheme2, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), groupId);
            if (editor != null) {
                ErrorStripeUpdateManager.getInstance(project).repaintErrorStripePanel(editor);
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session2, @NotNull TextRange elementRange, @Nullable List<? extends HighlightInfo> infos) {
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(8);
        }
        if (elementRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(9);
        }
        PsiFile psiFile = session2.getPsiFile();
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(psiFile, elementRange, infos, session2);
    }

    private static void killAbandonedHighlightsUnder(@NotNull PsiFile psiFile, @NotNull TextRange range2, @Nullable List<? extends HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        Project project;
        Document document;
        if (psiFile == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(10);
        }
        if (range2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(11);
        }
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(12);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = psiFile.getProject())).getDocument(psiFile)) == null) {
            return;
        }
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range2.getStartOffset(), range2.getEndOffset(), (Processor<? super HighlightInfo>)((Processor)existing -> {
            if (existing.isBijective() && existing.getGroup() == 4 && range2.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                if (infos != null) {
                    for (HighlightInfo created : infos) {
                        if (!existing.equalsByActualOffset(created)) continue;
                        return true;
                    }
                }
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighterFor((HighlightInfo)existing);
            }
            return true;
        }));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session2, @NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(13);
        }
        if (info == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(14);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(15);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(16);
        }
        ((HighlightingSessionImpl)session2).queueHighlightInfo(info, restrictedRange, groupId);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, @Nullable Editor editor, double progress) {
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(17);
        }
        PsiFile file2 = highlightingSession.getPsiFile();
        this.repaintTrafficIcon(file2, editor, progress);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, @Nullable Editor editor, double progress) {
        if (file2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor;
                if (myeditor == null) {
                    myeditor = PsiUtilBase.findEditor((PsiElement)file2);
                }
                if (myeditor == null || myeditor.isDisposed()) {
                    return;
                }
                EditorMarkupModelImpl markup = (EditorMarkupModelImpl)myeditor.getMarkupModel();
                markup.repaintTrafficLightIcon();
                ErrorStripeUpdateManager.getInstance(myProject).repaintErrorStripePanel(myeditor);
            }, 50, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSession";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsInsideVisiblePartAreProduced";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsOutsideVisiblePartAreProduced";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "allHighlightsForRangeAreProduced";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "killAbandonedHighlightsUnder";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "infoIsAvailable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "progressIsAdvanced";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintTrafficIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

