/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class TreeState
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(TreeState.class);
    public static final Key<WeakReference<ActionCallback>> CALLBACK = Key.create((String)"Callback");
    private static final Key<Promise<Void>> EXPANDING = Key.create((String)"TreeExpanding");
    private static final String EXPAND_TAG = "expand";
    private static final String SELECT_TAG = "select";
    private static final String PATH_TAG = "path";
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;
    private boolean myScrollToSelection;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myScrollToSelection = true;
    }

    public boolean isEmpty() {
        return this.myExpandedPaths.isEmpty() && this.mySelectedPaths.isEmpty();
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.readExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void readExternal(Element root, List<? super List<PathElement>> list, String name) throws InvalidDataException {
        list.clear();
        for (Element element : root.getChildren(name)) {
            for (Element child : element.getChildren(PATH_TAG)) {
                Object[] path2 = (PathElement[])XmlSerializer.deserialize((Element)child, PathElement[].class);
                list.add((List<PathElement>)ContainerUtil.immutableList((Object[])path2));
            }
        }
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull DefaultMutableTreeNode treeNode) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(0);
        }
        if (treeNode == null) {
            TreeState.$$$reportNull$$$0(1);
        }
        TreeState treeState = TreeState.createOn(tree, new TreePath(treeNode.getPath()));
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(2);
        }
        return treeState;
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull TreePath rootPath) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(3);
        }
        if (rootPath == null) {
            TreeState.$$$reportNull$$$0(4);
        }
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree, rootPath)), TreeState.createPaths(tree, TreeUtil.collectSelectedPaths(tree, rootPath)));
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(5);
        }
        return treeState;
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(6);
        }
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree)), new ArrayList<List<PathElement>>());
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(7);
        }
        return treeState;
    }

    @NotNull
    public static TreeState createFrom(@Nullable Element element) {
        TreeState state = new TreeState(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
        try {
            if (element != null) {
                state.readExternal(element);
            }
        }
        catch (InvalidDataException e) {
            LOG.warn((Throwable)e);
        }
        TreeState treeState = state;
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(8);
        }
        return treeState;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeState.writeExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void writeExternal(Element element, List<? extends List<PathElement>> list, String name) throws WriteExternalException {
        Element root = new Element(name);
        for (List<PathElement> list2 : list) {
            Element e = XmlSerializer.serialize((Object)list2.toArray());
            e.setName(PATH_TAG);
            root.addContent(e);
        }
        element.addContent(root);
    }

    @NotNull
    private static List<List<PathElement>> createPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            TreeState.$$$reportNull$$$0(10);
        }
        List list = JBIterable.from(paths).filter(o -> o.getPathCount() > 1 || tree.isRootVisible()).map(o -> TreeState.createPath(tree.getModel(), o)).toList();
        if (list == null) {
            TreeState.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<PathElement> createPath(@NotNull TreeModel model, @NotNull TreePath treePath) {
        if (model == null) {
            TreeState.$$$reportNull$$$0(12);
        }
        if (treePath == null) {
            TreeState.$$$reportNull$$$0(13);
        }
        Object prev = null;
        int count = treePath.getPathCount();
        PathElement[] result2 = new PathElement[count];
        for (int i = 0; i < count; ++i) {
            Object cur = treePath.getPathComponent(i);
            Object userObject = TreeUtil.getUserObject(cur);
            int childIndex = prev == null ? 0 : model.getIndexOfChild(prev, cur);
            result2[i] = new PathElement(TreeState.calcId(userObject), TreeState.calcType(userObject), childIndex, userObject);
            prev = cur;
        }
        List<PathElement> list = Arrays.asList(result2);
        if (list == null) {
            TreeState.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static String calcId(@Nullable Object userObject) {
        Object value;
        if (userObject == null) {
            if ("" == null) {
                TreeState.$$$reportNull$$$0(15);
            }
            return "";
        }
        Object object = userObject instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)userObject).getKey() : (value = userObject instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : userObject);
        if (value instanceof NavigationItem) {
            String string;
            try {
                String name = ((NavigationItem)value).getName();
                string = name != null ? name : StringUtil.notNullize((String)value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                TreeState.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)userObject.toString());
        if (string == null) {
            TreeState.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String calcType(@Nullable Object userObject) {
        if (userObject == null) {
            if ("" == null) {
                TreeState.$$$reportNull$$$0(18);
            }
            return "";
        }
        String name = userObject.getClass().getName();
        String string = Integer.toHexString(StringHash.murmur((String)name, (int)31)) + ":" + StringUtil.getShortName((String)name);
        if (string == null) {
            TreeState.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void applyTo(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(20);
        }
        this.applyTo(tree, tree.getModel().getRoot());
    }

    public void applyTo(final @NotNull JTree tree, final @Nullable Object root) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(21);
        }
        LOG.debug((Throwable)new IllegalStateException("restore paths"));
        if (this.visit(tree)) {
            return;
        }
        if (root == null) {
            return;
        }
        final TreeFacade facade = TreeFacade.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone(new TreeRunnable("TreeState.applyTo: on done facade init"){

            @Override
            public void perform() {
                facade.batch(indicator -> TreeState.this.applyExpandedTo(facade, new TreePath(root), indicator));
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone(new TreeRunnable("TreeState.applyTo: on done"){

                @Override
                public void perform() {
                    if (tree.getSelectionCount() == 0) {
                        TreeState.this.applySelectedTo(tree);
                    }
                }
            });
        }
    }

    private void applyExpandedTo(@NotNull TreeFacade tree, @NotNull TreePath rootPath, @NotNull ProgressIndicator indicator) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(22);
        }
        if (rootPath == null) {
            TreeState.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            TreeState.$$$reportNull$$$0(24);
        }
        indicator.checkCanceled();
        if (rootPath.getPathCount() <= 0) {
            return;
        }
        for (List<PathElement> path2 : this.myExpandedPaths) {
            int index2;
            if (path2.isEmpty() || !path2.get(index2 = rootPath.getPathCount() - 1).isMatchTo(rootPath.getPathComponent(index2))) continue;
            TreeState.expandImpl(0, path2, rootPath, tree, indicator);
        }
    }

    private void applySelectedTo(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(25);
        }
        ArrayList selection = new ArrayList();
        for (List<PathElement> path2 : this.mySelectedPaths) {
            TreeModel model = tree.getModel();
            TreePath treePath = new TreePath(model.getRoot());
            for (int i = 1; treePath != null && i < path2.size(); ++i) {
                treePath = TreeState.findMatchedChild(model, treePath, path2.get(i));
            }
            ContainerUtil.addIfNotNull(selection, (Object)treePath);
        }
        if (selection.isEmpty()) {
            return;
        }
        for (TreePath treePath : selection) {
            tree.setSelectionPath(treePath);
        }
        if (this.myScrollToSelection) {
            TreeUtil.showRowCentered(tree, tree.getRowForPath((TreePath)selection.get(0)), true, true);
        }
    }

    @Nullable
    private static TreePath findMatchedChild(@NotNull TreeModel model, @NotNull TreePath treePath, @NotNull PathElement pathElement) {
        Object child;
        Object parent;
        int childCount;
        if (model == null) {
            TreeState.$$$reportNull$$$0(26);
        }
        if (treePath == null) {
            TreeState.$$$reportNull$$$0(27);
        }
        if (pathElement == null) {
            TreeState.$$$reportNull$$$0(28);
        }
        if ((childCount = model.getChildCount(parent = treePath.getLastPathComponent())) <= 0) {
            return null;
        }
        boolean idMatchedFound = false;
        Object idMatchedChild = null;
        for (int j = 0; j < childCount; ++j) {
            child = model.getChild(parent, j);
            Match match = pathElement.getMatchTo(child);
            if (match == Match.OBJECT) {
                return treePath.pathByAddingChild(child);
            }
            if (match != Match.ID_TYPE || idMatchedFound) continue;
            idMatchedChild = child;
            idMatchedFound = true;
        }
        if (idMatchedFound) {
            return treePath.pathByAddingChild(idMatchedChild);
        }
        int index2 = Math.max(0, Math.min(pathElement.index, childCount - 1));
        child = model.getChild(parent, index2);
        return treePath.pathByAddingChild(child);
    }

    private static void expandImpl(final int positionInPath, final List<? extends PathElement> path2, final TreePath treePath, final TreeFacade tree, final ProgressIndicator indicator) {
        tree.expand(treePath).doWhenDone(new TreeRunnable("TreeState.applyTo"){

            @Override
            public void perform() {
                PathElement next;
                indicator.checkCanceled();
                PathElement pathElement = next = positionInPath == path2.size() - 1 ? null : (PathElement)path2.get(positionInPath + 1);
                if (next == null) {
                    return;
                }
                Object parent = treePath.getLastPathComponent();
                TreeModel model = tree.tree.getModel();
                int childCount = model.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    Object child = tree.tree.getModel().getChild(parent, j);
                    if (!next.isMatchTo(child)) continue;
                    TreeState.expandImpl(positionInPath + 1, path2, treePath.pathByAddingChild(child), tree, indicator);
                    break;
                }
            }
        });
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    public String toString() {
        String content;
        Element st = new Element("TreeState");
        try {
            this.writeExternal(st);
            content = JDOMUtil.writeChildren((Element)st, (String)"\n");
        }
        catch (IOException e) {
            content = ExceptionUtil.getThrowableText((Throwable)e);
        }
        return "TreeState(" + this.myScrollToSelection + ")\n" + content;
    }

    @Deprecated
    public static void expand(@NotNull JTree tree, @NotNull Consumer<? super AsyncPromise<Void>> consumer) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(29);
        }
        if (consumer == null) {
            TreeState.$$$reportNull$$$0(30);
        }
        Promise<Void> expanding = (Promise<Void>)UIUtil.getClientProperty((Object)tree, EXPANDING);
        LOG.debug("EXPANDING: ", new Object[]{expanding});
        if (expanding == null) {
            expanding = Promises.resolvedPromise();
        }
        expanding.onProcessed(value -> {
            AsyncPromise promise = new AsyncPromise();
            UIUtil.putClientProperty((JComponent)tree, EXPANDING, promise);
            consumer.accept(promise);
        });
    }

    private static boolean isSelectionNeeded(List<TreePath> list, @NotNull JTree tree, AsyncPromise<Void> promise) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(31);
        }
        if (list != null && tree.isSelectionEmpty()) {
            return true;
        }
        if (promise != null) {
            promise.setResult(null);
        }
        return false;
    }

    private Promise<List<TreePath>> expand(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(32);
        }
        return TreeUtil.promiseExpand(tree, this.myExpandedPaths.stream().map(elements -> new Visitor((List<PathElement>)elements)));
    }

    private Promise<List<TreePath>> select(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(33);
        }
        return TreeUtil.promiseSelect(tree, this.mySelectedPaths.stream().map(elements -> new Visitor((List<PathElement>)elements)));
    }

    private boolean visit(@NotNull JTree tree) {
        TreeModel model;
        if (tree == null) {
            TreeState.$$$reportNull$$$0(34);
        }
        if (!((model = tree.getModel()) instanceof TreeVisitor.Acceptor)) {
            return false;
        }
        TreeState.expand(tree, promise -> this.expand(tree).onProcessed(expanded -> {
            if (TreeState.isSelectionNeeded(expanded, tree, promise)) {
                this.select(tree).onProcessed(selected -> promise.setResult(null));
            }
        }));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrom";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcId";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPaths";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandedTo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applySelectedTo";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedChild";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = EXPAND_TAG;
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionNeeded";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = SELECT_TAG;
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Visitor
    implements TreeVisitor {
        private final List<PathElement> elements;

        Visitor(List<PathElement> elements) {
            this.elements = elements;
        }

        @Override
        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path2) {
            int count;
            if (path2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((count = path2.getPathCount()) > this.elements.size()) {
                TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
                if (action == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                return action;
            }
            boolean matches = this.elements.get(count - 1).isMatchTo(path2.getLastPathComponent());
            TreeVisitor.Action action = !matches ? TreeVisitor.Action.SKIP_CHILDREN : (count < this.elements.size() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT);
            if (action == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TreeState.PATH_TAG;
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$Visitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BuilderFacade
    extends TreeFacade {
        private final AbstractTreeBuilder myBuilder;

        BuilderFacade(AbstractTreeBuilder builder) {
            super((JTree)ObjectUtils.notNull((Object)builder.getTree()));
            this.myBuilder = builder;
        }

        @Override
        public ActionCallback getInitialized() {
            return this.myBuilder.getReady(this);
        }

        @Override
        public void batch(Progressive progressive) {
            this.myBuilder.batch(progressive);
        }

        @Override
        public ActionCallback expand(TreePath treePath) {
            NodeDescriptor desc = TreeUtil.getLastUserObject(NodeDescriptor.class, treePath);
            if (desc == null) {
                return ActionCallback.REJECTED;
            }
            Object element = this.myBuilder.getTreeStructureElement(desc);
            ActionCallback result2 = new ActionCallback();
            this.myBuilder.expand(element, result2.createSetDoneRunnable());
            return result2;
        }
    }

    static class JTreeFacade
    extends TreeFacade {
        JTreeFacade(JTree tree) {
            super(tree);
        }

        @Override
        public ActionCallback expand(@NotNull TreePath treePath) {
            if (treePath == null) {
                JTreeFacade.$$$reportNull$$$0(0);
            }
            this.tree.expandPath(treePath);
            return ActionCallback.DONE;
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)UIUtil.getClientProperty((Object)this.tree, CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return ActionCallback.DONE;
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run(new EmptyProgressIndicator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState$JTreeFacade", TreeState.EXPAND_TAG));
        }
    }

    static abstract class TreeFacade {
        final JTree tree;

        TreeFacade(@NotNull JTree tree) {
            if (tree == null) {
                TreeFacade.$$$reportNull$$$0(0);
            }
            this.tree = tree;
        }

        abstract ActionCallback getInitialized();

        abstract ActionCallback expand(TreePath var1);

        abstract void batch(Progressive var1);

        static TreeFacade getFacade(JTree tree) {
            AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
            return builder != null ? new BuilderFacade(builder) : new JTreeFacade(tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState$TreeFacade", "<init>"));
        }
    }

    @Tag(value="item")
    static class PathElement {
        @Attribute(value="name")
        public String id;
        @Attribute(value="type")
        public String type;
        @Attribute(value="user")
        public String userStr;
        Object userObject;
        final int index;

        PathElement() {
            this(null, null, -1, null);
        }

        PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.id = itemId;
            this.type = itemType;
            this.index = itemIndex;
            this.userStr = userObject instanceof String ? (String)userObject : null;
            this.userObject = userObject;
        }

        public String toString() {
            return this.id + ": " + this.type;
        }

        private boolean isMatchTo(Object object) {
            return this.getMatchTo(object) != null;
        }

        private Match getMatchTo(Object object) {
            Object userObject = TreeUtil.getUserObject(object);
            if (this.userObject != null && this.userObject.equals(userObject)) {
                return Match.OBJECT;
            }
            return Comparing.equal((String)this.id, (String)TreeState.calcId(userObject)) && Comparing.equal((String)this.type, (String)TreeState.calcType(userObject)) ? Match.ID_TYPE : null;
        }
    }

    private static enum Match {
        OBJECT,
        ID_TYPE;

    }
}

