/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.GuiUtils;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotificationsManager myNotificationsManager;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(0);
        }
        return (GitExecutableProblemsNotifier)ServiceManager.getService((Project)project, GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project, @NotNull NotificationsManager notificationsManager) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(1);
        }
        if (notificationsManager == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myNotificationsManager = notificationsManager;
    }

    public static void showUnsupportedVersionDialog(@NotNull GitVersion version, @Nullable Project project) {
        if (version == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(3);
        }
        GuiUtils.invokeLaterIfNeeded(() -> Messages.showWarningDialog((Project)project, (String)GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation()), (String)GitBundle.message("git.executable.validation.error.version.title", version.getPresentation())), (ModalityState)ModalityState.defaultModalityState());
    }

    public static void showExecutionErrorDialog(@NotNull Throwable e, @Nullable Project project) {
        if (e == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(4);
        }
        boolean xcodeLicenseError = GitExecutableProblemsNotifier.isXcodeLicenseError(e);
        GuiUtils.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)(xcodeLicenseError ? GitBundle.getString("git.executable.validation.error.xcode.message") : GitExecutableProblemsNotifier.getPrettyErrorMessage(e)), (String)(xcodeLicenseError ? GitBundle.getString("git.executable.validation.error.xcode.title") : GitBundle.getString("git.executable.validation.error.start.title"))), (ModalityState)ModalityState.defaultModalityState());
    }

    public void notifyUnsupportedVersion(@NotNull GitVersion version) {
        if (version == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(5);
        }
        UnsupportedGitVersionNotification notification = new UnsupportedGitVersionNotification(version);
        ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
        this.notify(notification);
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(6);
        }
        if (GitExecutableProblemsNotifier.isXcodeLicenseError(exception)) {
            this.notify(new XcodeLicenseNotAcceptedNotification());
        } else {
            ErrorRunningGitNotification notification = new ErrorRunningGitNotification(GitExecutableProblemsNotifier.getPrettyErrorMessage(exception));
            ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
            this.notify(notification);
        }
    }

    private void notify(@NotNull BadGitExecutableNotification notification) {
        if (notification == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(7);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.ensureSingularOfType(((Object)((Object)notification)).getClass())) {
                notification.notify(this.myProject);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private boolean ensureSingularOfType(@NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications;
        int notificationsCount;
        if (notificationType == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(8);
        }
        if ((notificationsCount = (currentNotifications = (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)).length) <= 0) {
            return true;
        }
        for (int i = 0; i < notificationsCount - 1; ++i) {
            currentNotifications[i].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(9);
        }
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? "File not found: " + cause.getMessage() : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                String string = exception.getMessage();
                if (string == null) {
                    GitExecutableProblemsNotifier.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = exception.getClass().getName();
            if (string == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = errorMessage;
        if (string == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isXcodeLicenseError(@NotNull Throwable exception) {
        Throwable cause;
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(13);
        }
        String message = exception instanceof GitVersionIdentificationException ? ((cause = exception.getCause()) != null ? cause.getMessage() : null) : exception.getMessage();
        return message != null && SystemInfo.isMac && message.contains("Agreeing to the Xcode/iOS license");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationsManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUnsupportedVersionDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showExecutionErrorDialog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyUnsupportedVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyExecutionError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureSingularOfType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyErrorMessage";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeLicenseError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            if (groupDisplayId == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(0);
            }
            if (type == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(1);
            }
            super(groupDisplayId, icon, title, subtitle, content, type, listener);
        }

        private void addConfigureGitActions(@NotNull Project project) {
            if (project == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(2);
            }
            this.addAction((AnAction)new BrowseNotificationAction(GitBundle.getString("git.executable.validation.error.action.download"), GitBundle.getString("git.executable.validation.error.action.download.link")));
            this.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.getString("git.executable.validation.error.action.setting"), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "Git")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier$BadGitExecutableNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addConfigureGitActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class XcodeLicenseNotAcceptedNotification
    extends BadGitExecutableNotification {
        XcodeLicenseNotAcceptedNotification() {
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.xcode.title"), null, GitBundle.getString("git.executable.validation.error.xcode.message"), NotificationType.ERROR, null);
        }
    }

    private static class ErrorRunningGitNotification
    extends BadGitExecutableNotification {
        ErrorRunningGitNotification(@NotNull String error) {
            if (error == null) {
                ErrorRunningGitNotification.$$$reportNull$$$0(0);
            }
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.start.title"), null, error, NotificationType.ERROR, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/config/GitExecutableProblemsNotifier$ErrorRunningGitNotification", "<init>"));
        }
    }

    private static class UnsupportedGitVersionNotification
    extends BadGitExecutableNotification {
        UnsupportedGitVersionNotification(@NotNull GitVersion unsupportedVersion) {
            if (unsupportedVersion == null) {
                UnsupportedGitVersionNotification.$$$reportNull$$$0(0);
            }
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.message("git.executable.validation.error.version.title", unsupportedVersion.getPresentation()), null, GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation()), NotificationType.WARNING, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsupportedVersion", "git4idea/config/GitExecutableProblemsNotifier$UnsupportedGitVersionNotification", "<init>"));
        }
    }
}

