/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittestLegacy;

import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.AbstractPythonTestRunConfigurationParams;
import com.jetbrains.python.testing.PythonTestLegacyRunConfigurationForm;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfiguration;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfigurationParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PythonUnitTestRunConfigurationForm
implements PythonUnitTestRunConfigurationParams {
    private final JPanel myRootPanel = new JPanel(new BorderLayout());
    private final JCheckBox myIsPureUnittest;
    private final PythonTestLegacyRunConfigurationForm myTestRunConfigurationForm;

    public PythonUnitTestRunConfigurationForm(Project project, final PythonUnitTestRunConfiguration configuration) {
        this.myTestRunConfigurationForm = new PythonTestLegacyRunConfigurationForm(project, configuration);
        this.myIsPureUnittest = new JCheckBox("Inspect only subclasses of unittest.TestCase");
        this.myIsPureUnittest.setSelected(configuration.isPureUnittest());
        ActionListener testTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonUnitTestRunConfigurationForm.this.myIsPureUnittest.setVisible(PythonUnitTestRunConfigurationForm.this.myTestRunConfigurationForm.getTestType() != AbstractPythonLegacyTestRunConfiguration.TestType.TEST_FUNCTION);
            }
        };
        this.myTestRunConfigurationForm.addTestTypeListener(testTypeListener);
        this.myIsPureUnittest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration.setPureUnittest(PythonUnitTestRunConfigurationForm.this.myIsPureUnittest.isSelected());
            }
        });
        this.myTestRunConfigurationForm.getAdditionalPanel().add(this.myIsPureUnittest);
        TitledBorder border = (TitledBorder)this.myTestRunConfigurationForm.getTestsPanel().getBorder();
        border.setTitle(PyBundle.message("runcfg.unittest.display_name", new Object[0]));
        this.myTestRunConfigurationForm.setParamsVisible();
        this.myTestRunConfigurationForm.getParamCheckBox().setSelected(configuration.useParam());
        this.myRootPanel.add((Component)this.myTestRunConfigurationForm.getPanel(), "Center");
    }

    @Override
    public AbstractPythonTestRunConfigurationParams getTestRunConfigurationParams() {
        return this.myTestRunConfigurationForm;
    }

    @Override
    public boolean isPureUnittest() {
        return this.myIsPureUnittest.isSelected();
    }

    @Override
    public void setPureUnittest(boolean isPureUnittest) {
        this.myIsPureUnittest.setSelected(isPureUnittest);
    }

    @Override
    public String getParams() {
        return this.myTestRunConfigurationForm.getParams();
    }

    @Override
    public void setParams(String params) {
        this.myTestRunConfigurationForm.setParams(params);
    }

    @Override
    public boolean useParam() {
        return this.myTestRunConfigurationForm.getParamCheckBox().isSelected();
    }

    @Override
    public void useParam(boolean useParam) {
        this.myTestRunConfigurationForm.getParamCheckBox().setSelected(useParam);
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }
}

