/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014J\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/run/PyVirtualEnvReader;", "Lcom/intellij/util/EnvironmentUtil$ShellEnvReader;", "virtualEnvSdkPath", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "activate", "Lkotlin/Pair;", "getActivate", "()Lkotlin/Pair;", "getVirtualEnvSdkPath", "()Ljava/lang/String;", "getShell", "getShellProcessCommand", "", "readPythonEnv", "", "Companion", "intellij.python.community.impl"})
public final class PyVirtualEnvReader
extends EnvironmentUtil.ShellEnvReader {
    private final Logger LOG;
    @Nullable
    private final Pair<String, String> activate;
    @NotNull
    private final String virtualEnvSdkPath;
    @NotNull
    private static final List<String> virtualEnvVars;
    public static final Companion Companion;

    @Nullable
    public final Pair<String, String> getActivate() {
        return this.activate;
    }

    @Nullable
    protected String getShell() {
        if (new File("/bin/bash").exists()) {
            return "/bin/bash";
        }
        if (new File("/bin/sh").exists()) {
            return "/bin/sh";
        }
        return super.getShell();
    }

    @NotNull
    public final Map<String, String> readPythonEnv() {
        try {
            if (SystemInfo.isUnix) {
                Map map2 = super.readShellEnv(EnvironmentUtil.getEnvironmentMap());
                Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"super.readShellEnv(Envir\u2026Util.getEnvironmentMap())");
                return map2;
            }
            if (this.activate != null) {
                Map map3 = this.readBatEnv(new File((String)this.activate.getFirst()), ContainerUtil.createMaybeSingletonList((Object)this.activate.getSecond()));
                Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"readBatEnv(File(activate\u2026tonList(activate.second))");
                return map3;
            }
            this.LOG.error("Can't find activate script for " + this.virtualEnvSdkPath);
        }
        catch (Exception e) {
            this.LOG.warn("Couldn't read shell environment: " + e.getMessage());
        }
        return new LinkedHashMap();
    }

    @NotNull
    protected List<String> getShellProcessCommand() {
        List list;
        String shellPath = this.getShell();
        if (shellPath == null || !new File(shellPath).canExecute()) {
            throw (Throwable)new Exception("shell:" + shellPath);
        }
        if (this.activate != null) {
            String activateArg = this.activate.getSecond() != null ? '\'' + (String)this.activate.getFirst() + "' '" + (String)this.activate.getSecond() + '\'' : '\'' + (String)this.activate.getFirst() + '\'';
            list = CollectionsKt.mutableListOf((Object[])new String[]{shellPath, "-c", ". " + activateArg});
        } else {
            List list2 = super.getShellProcessCommand();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"super.getShellProcessCommand()");
        }
        return list;
    }

    @NotNull
    public final String getVirtualEnvSdkPath() {
        return this.virtualEnvSdkPath;
    }

    public PyVirtualEnvReader(@NotNull String virtualEnvSdkPath) {
        Intrinsics.checkParameterIsNotNull((Object)virtualEnvSdkPath, (String)"virtualEnvSdkPath");
        this.virtualEnvSdkPath = virtualEnvSdkPath;
        Logger logger = Logger.getInstance((String)"#com.jetbrains.python.run.PyVirtualEnvReader");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026.run.PyVirtualEnvReader\")");
        this.LOG = logger;
        this.activate = PyVirtualEnvReaderKt.findActivateScript(this.virtualEnvSdkPath, this.getShell());
    }

    static {
        Companion = new Companion(null);
        virtualEnvVars = CollectionsKt.listOf((Object[])new String[]{"PATH", "PS1", "VIRTUAL_ENV", "PYTHONHOME", "PROMPT", "_OLD_VIRTUAL_PROMPT", "_OLD_VIRTUAL_PYTHONHOME", "_OLD_VIRTUAL_PATH"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/run/PyVirtualEnvReader$Companion;", "", "()V", "virtualEnvVars", "", "", "getVirtualEnvVars", "()Ljava/util/List;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final List<String> getVirtualEnvVars() {
            return virtualEnvVars;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

