/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteAnalyzeStacktraceFilter
extends PythonTracebackFilter {
    public PyRemoteAnalyzeStacktraceFilter(Project project) {
        super(project);
    }

    @Override
    @Nullable
    protected VirtualFile findFileByName(@NotNull String fileName) {
        VirtualFile vFile;
        if (fileName == null) {
            PyRemoteAnalyzeStacktraceFilter.$$$reportNull$$$0(0);
        }
        if ((vFile = super.findFileByName(fileName)) != null) {
            return vFile;
        }
        for (Module m : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            PyRemoteSdkAdditionalDataBase data;
            Sdk s = PythonSdkType.findPythonSdk(m);
            if (!PySdkUtil.isRemote(s) || (data = (PyRemoteSdkAdditionalDataBase)s.getSdkAdditionalData()) == null) continue;
            for (PathMappingProvider provider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)data)) {
                PathMappingSettings mappingSettings = provider.getPathMappingSettings(this.getProject(), (RemoteSdkAdditionalData)data);
                String localFile = mappingSettings.convertToLocal(fileName);
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(localFile);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/python/run/PyRemoteAnalyzeStacktraceFilter", "findFileByName"));
    }
}

