/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyPackagingSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPIPackageUtil {
    private static final Logger LOG = Logger.getInstance(PyPIPackageUtil.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String PYPI_HOST = "https://pypi.python.org";
    public static final String PYPI_URL = "https://pypi.python.org/pypi";
    public static final String PYPI_LIST_URL = "https://pypi.python.org/simple";
    public static final ImmutableMap<String, List<String>> PACKAGES_TOPLEVEL = PyPIPackageUtil.loadPackageAliases();
    public static final PyPIPackageUtil INSTANCE = new PyPIPackageUtil();
    private final LoadingCache<String, List<String>> myAdditionalPackagesReleases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(@NotNull String key) throws Exception {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            LOG.debug("Searching for versions of package '" + key + "' in additional repositories");
            List<String> repositories = PyPackageService.getInstance().additionalRepositories;
            for (String repository : repositories) {
                try {
                    String packageUrl = StringUtil.trimEnd((String)repository, (String)"/") + "/" + key;
                    List versions = PyPIPackageUtil.parsePackageVersionsFromArchives(packageUrl, key);
                    if (versions.isEmpty()) continue;
                    LOG.debug("Found versions " + versions + "of " + key + " at " + repository);
                    return Collections.unmodifiableList(versions);
                }
                catch (HttpRequests.HttpStatusException e) {
                    if (e.getStatusCode() == 404) continue;
                    LOG.debug("Cannot access " + e.getUrl() + ": " + e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$1", "load"));
        }
    });
    protected final LoadingCache<String, List<RepoPackage>> myAdditionalPackages = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<RepoPackage>>(){

        public List<RepoPackage> load(@NotNull String key) throws Exception {
            if (key == null) {
                2.$$$reportNull$$$0(0);
            }
            return PyPIPackageUtil.getPackagesFromAdditionalRepository(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$2", "load"));
        }
    });
    private final LoadingCache<String, PackageDetails> myPackageToDetails = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PackageDetails>(){

        public PackageDetails load(@NotNull String key) throws Exception {
            if (key == null) {
                3.$$$reportNull$$$0(0);
            }
            LOG.debug("Fetching details for the package '" + key + "' on PyPI");
            return (PackageDetails)HttpRequests.request((String)("https://pypi.python.org/pypi/" + key + "/json")).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> (PackageDetails)GSON.fromJson((Reader)request.getReader(), PackageDetails.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$3", "load"));
        }
    });
    private final Object myPyPIPackageCacheUpdateLock = new Object();

    @NotNull
    private static String getUserAgent() {
        String string = ApplicationNamesInfo.getInstance().getProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static ImmutableMap<String, List<String>> loadPackageAliases() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Files.lines(Paths.get(PythonHelpersLocator.getHelperPath("/tools/packages"), new String[0])).forEach(line -> {
                List split = StringUtil.split((String)line, (String)" ");
                builder.put(split.get(0), (Object)new SmartList((Collection)ContainerUtil.subList((List)split, (int)1)));
            });
        }
        catch (IOException e) {
            LOG.error("Cannot find \"packages\". " + e.getMessage());
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            PyPIPackageUtil.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    public static boolean isPyPIRepository(@Nullable String repository) {
        return repository != null && repository.startsWith(PYPI_HOST);
    }

    @NotNull
    public List<RepoPackage> getAdditionalPackages(@NotNull List<String> repositories) {
        if (repositories == null) {
            PyPIPackageUtil.$$$reportNull$$$0(2);
        }
        List list = StreamEx.of((Collection)this.myAdditionalPackages.getAllPresent(repositories).values()).flatMap(StreamEx::of).toList();
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void loadAdditionalPackages(@NotNull List<String> repositories, boolean alwaysRefresh) throws IOException {
        if (repositories == null) {
            PyPIPackageUtil.$$$reportNull$$$0(4);
        }
        if (alwaysRefresh) {
            for (String url : repositories) {
                this.myAdditionalPackages.refresh((Object)url);
            }
        } else {
            for (String url : repositories) {
                PyPIPackageUtil.getCachedValueOrRethrowIO(this.myAdditionalPackages, url);
            }
        }
    }

    @NotNull
    private static List<RepoPackage> getPackagesFromAdditionalRepository(@NotNull String url) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(5);
        }
        List<RepoPackage> list = PyPIPackageUtil.parsePyPIListFromWeb(url).stream().map(s -> new RepoPackage(s, url, null)).collect(Collectors.toList());
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void fillPackageDetails(@NotNull String packageName, @NotNull CatchingConsumer<PackageDetails.Info, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                PackageDetails packageDetails = this.refreshAndGetPackageDetailsFromPyPI(packageName, false);
                callback.consume((Object)packageDetails.getInfo());
            }
            catch (IOException e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private PackageDetails refreshAndGetPackageDetailsFromPyPI(@NotNull String packageName, boolean alwaysRefresh) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(9);
        }
        if (alwaysRefresh) {
            this.myPackageToDetails.invalidate((Object)packageName);
        }
        PackageDetails packageDetails = PyPIPackageUtil.getCachedValueOrRethrowIO(this.myPackageToDetails, packageName);
        if (packageDetails == null) {
            PyPIPackageUtil.$$$reportNull$$$0(10);
        }
        return packageDetails;
    }

    public void usePackageReleases(@NotNull String packageName, @NotNull CatchingConsumer<List<String>, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String> releasesFromSimpleIndex = this.getPackageVersionsFromAdditionalRepositories(packageName);
                if (releasesFromSimpleIndex.isEmpty()) {
                    List<String> releasesFromPyPI = this.getPackageVersionsFromPyPI(packageName, true);
                    callback.consume(releasesFromPyPI);
                } else {
                    callback.consume(releasesFromSimpleIndex);
                }
            }
            catch (Exception e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private List<String> getPackageVersionsFromPyPI(@NotNull String packageName, boolean force) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(13);
        }
        PackageDetails details = this.refreshAndGetPackageDetailsFromPyPI(packageName, force);
        List<String> result = details.getReleases();
        result.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
        List<String> list = Collections.unmodifiableList(result);
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private String getLatestPackageVersionFromPyPI(@NotNull Project project, @NotNull String packageName) throws IOException {
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(15);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(16);
        }
        LOG.debug("Requesting the latest PyPI version for the package " + packageName);
        List<String> versions = this.getPackageVersionsFromPyPI(packageName, true);
        return PyPackagingSettings.getInstance(project).selectLatestVersion(versions);
    }

    @NotNull
    private List<String> getPackageVersionsFromAdditionalRepositories(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(17);
        }
        List<String> list = PyPIPackageUtil.getCachedValueOrRethrowIO(this.myAdditionalPackagesReleases, packageName);
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static <T> T getCachedValueOrRethrowIO(@NotNull LoadingCache<String, ? extends T> cache2, @NotNull String key) throws IOException {
        Object object;
        if (cache2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(19);
        }
        if (key == null) {
            PyPIPackageUtil.$$$reportNull$$$0(20);
        }
        try {
            object = cache2.get((Object)key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException("Unexpected non-IO error", cause);
        }
        if (object == null) {
            PyPIPackageUtil.$$$reportNull$$$0(21);
        }
        return (T)object;
    }

    @Nullable
    private String getLatestPackageVersionFromAdditionalRepositories(@NotNull Project project, @NotNull String packageName) throws IOException {
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(22);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(23);
        }
        List<String> versions = this.getPackageVersionsFromAdditionalRepositories(packageName);
        return PyPackagingSettings.getInstance(project).selectLatestVersion(versions);
    }

    @Nullable
    public String fetchLatestPackageVersion(@NotNull Project project, @NotNull String packageName) throws IOException {
        String extraVersion;
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(25);
        }
        String version = null;
        if (PyPIPackageCache.getInstance().containsPackage(packageName)) {
            version = this.getLatestPackageVersionFromPyPI(project, packageName);
        }
        if (!PyPackageService.getInstance().additionalRepositories.isEmpty() && (extraVersion = this.getLatestPackageVersionFromAdditionalRepositories(project, packageName)) != null) {
            version = extraVersion;
        }
        return version;
    }

    @NotNull
    private static List<String> parsePackageVersionsFromArchives(final @NotNull String archivesUrl, final @NotNull String packageName) throws IOException {
        if (archivesUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(26);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(27);
        }
        List list = (List)HttpRequests.request((String)archivesUrl).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> {
            final ArrayList<String> versions = new ArrayList<String>();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
                    this.myTag = tag;
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    if (data == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        String artifactName = String.valueOf(data);
                        String version = PyPIPackageUtil.extractVersionFromArtifactName(artifactName, packageName);
                        if (version != null) {
                            versions.add(version);
                        } else {
                            LOG.debug("Could not extract version from " + artifactName + " at " + archivesUrl);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/packaging/PyPIPackageUtil$4", "handleText"));
                }
            }, true);
            versions.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
            return versions;
        });
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    private static String extractVersionFromArtifactName(@NotNull String artifactName, @NotNull String packageName) {
        String suffix;
        if (artifactName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(29);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(30);
        }
        String withoutExtension = artifactName.endsWith(".tar.gz") ? StringUtil.trimEnd((String)artifactName, (String)".tar.gz") : FileUtil.getNameWithoutExtension((String)artifactName);
        String packageNameWithUnderscores = packageName.replace('-', '_');
        if (withoutExtension.startsWith(packageName)) {
            suffix = StringUtil.trimStart((String)withoutExtension, (String)packageName);
        } else if (withoutExtension.startsWith(packageNameWithUnderscores)) {
            suffix = StringUtil.trimStart((String)withoutExtension, (String)packageNameWithUnderscores);
        } else {
            return null;
        }
        String version = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)suffix, (String)"-"));
        if (StringUtil.isNotEmpty((String)version)) {
            return version;
        }
        return null;
    }

    public void updatePyPICache() throws IOException {
        PyPackageService service = PyPackageService.getInstance();
        if (service.PYPI_REMOVED.booleanValue()) {
            return;
        }
        PyPIPackageCache.reload(PyPIPackageUtil.parsePyPIListFromWeb(PYPI_LIST_URL));
        service.LAST_TIME_CHECKED = System.currentTimeMillis();
    }

    @NotNull
    private static List<String> parsePyPIListFromWeb(@NotNull String url) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(31);
        }
        LOG.debug("Fetching index of all packages available on " + url);
        List list = (List)HttpRequests.request((String)url).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> {
            final ArrayList packages = new ArrayList();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;

                @Override
                public void handleStartTag(@NotNull HTML.Tag tag, @NotNull MutableAttributeSet set, int i) {
                    if (tag == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (set == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    this.myTag = tag;
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    if (data == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        packages.add(String.valueOf(data));
                    }
                }

                @Override
                public void handleEndTag(@NotNull HTML.Tag t, int pos) {
                    if (t == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    this.myTag = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tag";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "set";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "t";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleStartTag";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleText";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEndTag";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            return packages;
        });
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPackages() throws IOException {
        Object object = this.myPyPIPackageCacheUpdateLock;
        synchronized (object) {
            PyPIPackageCache cache2 = PyPIPackageCache.getInstance();
            if (cache2.getPackageNames().isEmpty()) {
                this.updatePyPICache();
            }
        }
    }

    public boolean isInPyPI(@NotNull String packageName) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(33);
        }
        return PyPIPackageCache.getInstance().containsPackage(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivesUrl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPackageAliases";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromPyPI";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValueOrRethrowIO";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageVersionsFromArchives";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePyPIListFromWeb";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPackages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalPackages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillPackageDetails";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "usePackageReleases";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromPyPI";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromPyPI";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueOrRethrowIO";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromAdditionalRepositories";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestPackageVersion";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageVersionsFromArchives";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractVersionFromArtifactName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parsePyPIListFromWeb";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInPyPI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class PackageDetails {
        @SerializedName(value="info")
        private Info info = new Info();
        @SerializedName(value="releases")
        private Map<String, Object> releases = Collections.emptyMap();

        @NotNull
        public Info getInfo() {
            Info info = this.info;
            if (info == null) {
                PackageDetails.$$$reportNull$$$0(0);
            }
            return info;
        }

        @NotNull
        public List<String> getReleases() {
            List list = EntryStream.of(this.releases).filterValues(PackageDetails::isNotBrokenRelease).keys().toList();
            if (list == null) {
                PackageDetails.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static boolean isNotBrokenRelease(Object o) {
            return !(o instanceof List) || !((List)o).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReleases";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        public static final class Info {
            @SerializedName(value="version")
            private String version = "";
            @SerializedName(value="author")
            private String author = "";
            @SerializedName(value="author_email")
            private String authorEmail = "";
            @SerializedName(value="home_page")
            private String homePage = "";
            @SerializedName(value="summary")
            private String summary = "";

            @NotNull
            public String getVersion() {
                String string = StringUtil.notNullize((String)this.version);
                if (string == null) {
                    Info.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getAuthor() {
                String string = StringUtil.notNullize((String)this.author);
                if (string == null) {
                    Info.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getAuthorEmail() {
                String string = StringUtil.notNullize((String)this.authorEmail);
                if (string == null) {
                    Info.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String getHomePage() {
                String string = StringUtil.notNullize((String)this.homePage);
                if (string == null) {
                    Info.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = StringUtil.notNullize((String)this.summary);
                if (string == null) {
                    Info.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails$Info";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthorEmail";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHomePage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

