/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecutionStack
extends XExecutionStack {
    private final PyDebugProcess myDebugProcess;
    private final PyThreadInfo myThreadInfo;
    private PyStackFrame myTopFrame;

    public PyExecutionStack(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo) {
        if (debugProcess == null) {
            PyExecutionStack.$$$reportNull$$$0(0);
        }
        if (threadInfo == null) {
            PyExecutionStack.$$$reportNull$$$0(1);
        }
        super(threadInfo.getName());
        this.myDebugProcess = debugProcess;
        this.myThreadInfo = threadInfo;
    }

    public PyExecutionStack(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo, @Nullable Icon icon) {
        if (debugProcess == null) {
            PyExecutionStack.$$$reportNull$$$0(2);
        }
        if (threadInfo == null) {
            PyExecutionStack.$$$reportNull$$$0(3);
        }
        super(threadInfo.getName(), icon);
        this.myDebugProcess = debugProcess;
        this.myThreadInfo = threadInfo;
    }

    public PyStackFrame getTopFrame() {
        List frames;
        if (this.myTopFrame == null && (frames = this.myThreadInfo.getFrames()) != null) {
            this.myTopFrame = PyExecutionStack.convert(this.myDebugProcess, (PyStackFrameInfo)frames.get(0));
        }
        return this.myTopFrame;
    }

    public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        if (this.myThreadInfo.getState() != PyThreadInfo.State.SUSPENDED) {
            container.errorOccurred("Frames not available in non-suspended state");
            return;
        }
        List frames = this.myThreadInfo.getFrames();
        if (frames != null && firstFrameIndex <= frames.size()) {
            LinkedList<PyStackFrame> xFrames = new LinkedList<PyStackFrame>();
            for (int i = firstFrameIndex; i < frames.size(); ++i) {
                xFrames.add(PyExecutionStack.convert(this.myDebugProcess, (PyStackFrameInfo)frames.get(i)));
            }
            container.addStackFrames(xFrames, true);
        } else {
            container.addStackFrames(Collections.emptyList(), true);
        }
    }

    private static PyStackFrame convert(PyDebugProcess debugProcess, PyStackFrameInfo frameInfo) {
        return debugProcess.createStackFrame(frameInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PyExecutionStack that = (PyExecutionStack)((Object)o);
        return !(this.myThreadInfo != null ? !this.myThreadInfo.equals((Object)that.myThreadInfo) : that.myThreadInfo != null);
    }

    public int hashCode() {
        return this.myThreadInfo != null ? this.myThreadInfo.hashCode() : 0;
    }

    public String getThreadId() {
        return this.myThreadInfo.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "threadInfo";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/PyExecutionStack";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

