/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyClassTreeChooserDialog;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyExceptionBreakpointProperties;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExceptionBreakpointType
extends XBreakpointType<XBreakpoint<PyExceptionBreakpointProperties>, PyExceptionBreakpointProperties> {
    private static final String BASE_EXCEPTION = "BaseException";

    public PyExceptionBreakpointType() {
        super("python-exception", "Python Exception Breakpoint");
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public PyExceptionBreakpointProperties createProperties() {
        return new PyExceptionBreakpointProperties(BASE_EXCEPTION);
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<PyExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        PyClassTreeChooserDialog dialog = new PyClassTreeChooserDialog("Select Exception Class", project, GlobalSearchScope.allScope((Project)project), new PyExceptionCachingFilter(), null);
        dialog.showDialog();
        PyClass pyClass = (PyClass)dialog.getSelected();
        if (pyClass != null) {
            String qualifiedName = pyClass.getQualifiedName();
            assert (qualifiedName != null) : "Qualified name of the class shouldn't be null";
            return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new PyExceptionBreakpointProperties(qualifiedName)));
        }
        return null;
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    public String getDisplayText(XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
        PyExceptionBreakpointProperties properties = (PyExceptionBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            String exception = properties.getException();
            if (BASE_EXCEPTION.equals(exception)) {
                return "Any exception";
            }
            return exception;
        }
        return "";
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        return new PyDebuggerEditorsProvider();
    }

    public XBreakpoint<PyExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<PyExceptionBreakpointProperties> creator) {
        if (creator == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(4);
        }
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)PyExceptionBreakpointType.createDefaultBreakpointProperties());
        breakpoint.setEnabled(true);
        return breakpoint;
    }

    private static PyExceptionBreakpointProperties createDefaultBreakpointProperties() {
        PyExceptionBreakpointProperties p = new PyExceptionBreakpointProperties(BASE_EXCEPTION);
        p.setNotifyOnTerminate(true);
        p.setNotifyOnlyOnFirst(false);
        return p;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            PyExceptionBreakpointType.$$$reportNull$$$0(5);
        }
        return new PyExceptionBreakpointPropertiesPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyExceptionBreakpointType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyExceptionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyExceptionBreakpointPropertiesPanel
    extends XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> {
        private JCheckBox myNotifyOnTerminateCheckBox;
        private JCheckBox myNotifyOnRaiseCheckBox;
        private JCheckBox myIgnoreLibrariesCheckBox;
        private JBLabel myWarningIcon;

        private PyExceptionBreakpointPropertiesPanel() {
        }

        @NotNull
        public JComponent getComponent() {
            this.myNotifyOnTerminateCheckBox = new JCheckBox("On termination");
            this.myNotifyOnRaiseCheckBox = new JCheckBox("On raise");
            this.myIgnoreLibrariesCheckBox = new JCheckBox("Ignore library files");
            Box notificationsBox = Box.createVerticalBox();
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myNotifyOnTerminateCheckBox, "North");
            notificationsBox.add(panel);
            panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.setBorder((Border)JBUI.Borders.empty());
            panel.add((Component)this.myNotifyOnRaiseCheckBox, 0);
            this.myWarningIcon = new JBLabel(AllIcons.General.BalloonWarning);
            IdeTooltipManager.getInstance().setCustomTooltip((JComponent)this.myWarningIcon, (IdeTooltip)new TooltipWithClickableLinks.ForBrowser((JComponent)this.myWarningIcon, "This option may slow down the debugger"));
            this.myWarningIcon.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            panel.add((Component)this.myWarningIcon);
            notificationsBox.add(panel);
            panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myIgnoreLibrariesCheckBox, "North");
            notificationsBox.add(panel);
            panel = new JPanel(new BorderLayout());
            JPanel innerPanel = new JPanel(new BorderLayout());
            innerPanel.add((Component)notificationsBox, "Center");
            innerPanel.add(Box.createHorizontalStrut(3), "West");
            innerPanel.add(Box.createHorizontalStrut(3), "East");
            panel.add((Component)innerPanel, "North");
            panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Activation policy", (boolean)true));
            JPanel jPanel = panel;
            if (jPanel == null) {
                PyExceptionBreakpointPropertiesPanel.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        public void saveTo(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                PyExceptionBreakpointPropertiesPanel.$$$reportNull$$$0(1);
            }
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnTerminate(this.myNotifyOnTerminateCheckBox.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnlyOnFirst(this.myNotifyOnRaiseCheckBox.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setIgnoreLibraries(this.myIgnoreLibrariesCheckBox.isSelected());
        }

        public void loadFrom(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                PyExceptionBreakpointPropertiesPanel.$$$reportNull$$$0(2);
            }
            this.myIgnoreLibrariesCheckBox.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isIgnoreLibraries());
            this.myNotifyOnTerminateCheckBox.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnTerminate());
            this.myNotifyOnRaiseCheckBox.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnlyOnFirst());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "saveTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyExceptionCachingFilter
    implements TreeChooser.Filter<PyClass> {
        private final HashMap<Integer, Pair<WeakReference<PyClass>, Boolean>> processedElements = Maps.newHashMap();

        private PyExceptionCachingFilter() {
        }

        public boolean isAccepted(@NotNull PyClass pyClass) {
            boolean isException;
            VirtualFile virtualFile;
            if (pyClass == null) {
                PyExceptionCachingFilter.$$$reportNull$$$0(0);
            }
            if ((virtualFile = pyClass.getContainingFile().getVirtualFile()) == null) {
                return false;
            }
            int key = pyClass.hashCode();
            Pair<WeakReference<PyClass>, Boolean> pair = this.processedElements.get(key);
            if (pair == null || ((WeakReference)pair.first).get() != pyClass) {
                isException = (Boolean)ReadAction.compute(() -> PyUtil.isExceptionClass(pyClass));
                this.processedElements.put(key, (Pair<WeakReference<PyClass>, Boolean>)Pair.create(new WeakReference<PyClass>(pyClass), (Object)isException));
            } else {
                isException = (Boolean)pair.second;
            }
            return isException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionCachingFilter", "isAccepted"));
        }
    }
}

