/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ImportFromExistingAction
implements QuestionAction {
    PsiElement myTarget;
    List<? extends ImportCandidateHolder> mySources;
    String myName;
    boolean myUseQualifiedImport;
    private Runnable myOnDoneCallback;
    private final boolean myImportLocally;

    public ImportFromExistingAction(@NotNull PsiElement target, @NotNull List<? extends ImportCandidateHolder> sources, @NotNull String name, boolean useQualified, boolean importLocally) {
        if (target == null) {
            ImportFromExistingAction.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            ImportFromExistingAction.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ImportFromExistingAction.$$$reportNull$$$0(2);
        }
        this.myTarget = target;
        this.mySources = sources;
        this.myName = name;
        this.myUseQualifiedImport = useQualified;
        this.myImportLocally = importLocally;
    }

    public void onDone(Runnable callback) {
        assert (this.myOnDoneCallback == null);
        this.myOnDoneCallback = callback;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
        PyPsiUtils.assertValid(this.myTarget);
        if (this.myTarget instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myTarget).isQualified()) {
            return false;
        }
        for (ImportCandidateHolder importCandidateHolder : this.mySources) {
            PyPsiUtils.assertValid(importCandidateHolder.getImportable());
            PyPsiUtils.assertValid((PsiElement)importCandidateHolder.getFile());
            PyImportElement element = importCandidateHolder.getImportElement();
            if (element == null) continue;
            PyPsiUtils.assertValid((PsiElement)element);
        }
        if (this.mySources.isEmpty()) {
            return false;
        }
        if (this.mySources.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.doWriteAction(this.mySources.get(0));
        } else {
            this.selectSourceAndDo();
        }
        return true;
    }

    private void selectSourceAndDo() {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> JBPopupFactory.getInstance().createPopupChooserBuilder(this.mySources).setRenderer((ListCellRenderer)new CellRenderer(this.myName)).setTitle(this.myUseQualifiedImport ? PyBundle.message("ACT.qualify.with.module", new Object[0]) : PyBundle.message("ACT.from.some.module.import", new Object[0])).setItemChosenCallback(item -> {
            PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
            this.doWriteAction((ImportCandidateHolder)item);
        }).setNamerForFiltering(o -> o.getPresentableText(this.myName)).createPopup().showInBestPositionFor(dataContext));
    }

    private void doIt(ImportCandidateHolder item) {
        PyImportElement src = item.getImportElement();
        if (src != null) {
            this.addToExistingImport(src);
        } else {
            this.addImportStatement(item);
        }
    }

    private void addImportStatement(ImportCandidateHolder item) {
        Project project = this.myTarget.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project);
        PsiFileSystemItem filesystemAnchor = (PsiFileSystemItem)ObjectUtils.chooseNotNull((Object)PyUtil.as(item.getImportable(), PsiFileSystemItem.class), (Object)item.getFile());
        if (filesystemAnchor == null) {
            return;
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(this.myTarget, filesystemAnchor);
        PsiFile file = this.myTarget.getContainingFile();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        if (manager.isInjectedFragment(file)) {
            file = manager.getTopLevelFile(this.myTarget);
        }
        if (ImportFromExistingAction.isRoot(item.getFile())) {
            if (this.myImportLocally) {
                AddImportHelper.addLocalImportStatement(this.myTarget, this.myName);
            } else {
                AddImportHelper.addImportStatement(file, this.myName, item.getAsName(), priority, null);
            }
        } else {
            String qualifiedName;
            QualifiedName path = item.getPath();
            String string = qualifiedName = path != null ? path.toString() : "";
            if (this.myUseQualifiedImport) {
                String nameToImport = qualifiedName;
                if (item.getImportable() instanceof PsiFileSystemItem) {
                    nameToImport = nameToImport + "." + this.myName;
                }
                if (this.myImportLocally) {
                    AddImportHelper.addLocalImportStatement(this.myTarget, nameToImport);
                } else {
                    AddImportHelper.addImportStatement(file, nameToImport, item.getAsName(), priority, null);
                }
                this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement(this.myTarget), qualifiedName + "." + this.myName));
            } else if (this.myImportLocally) {
                AddImportHelper.addLocalFromImportStatement(this.myTarget, qualifiedName, this.myName);
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(file, qualifiedName, this.myName, item.getAsName(), priority, null);
            }
        }
    }

    private void addToExistingImport(PyImportElement src) {
        PyElementGenerator gen = PyElementGenerator.getInstance(this.myTarget.getProject());
        PsiElement parent = src.getParent();
        if (parent instanceof PyFromImportStatement) {
            PyImportElement newImportElement = gen.createImportElement(LanguageLevel.getDefault(), this.myName, null);
            parent.add((PsiElement)newImportElement);
            CodeStyleManager.getInstance((Project)this.myTarget.getProject()).reformat(parent);
        } else {
            this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement(this.myTarget), src.getVisibleName() + "." + this.myName));
        }
    }

    private void doWriteAction(ImportCandidateHolder item) {
        PsiElement src = item.getImportable();
        if (src == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)src.getProject(), (PsiFile[])new PsiFile[]{this.myTarget.getContainingFile()}).withName(PyBundle.message("ACT.CMD.use.import", new Object[0])).run(() -> this.doIt(item));
        if (this.myOnDoneCallback != null) {
            this.myOnDoneCallback.run();
        }
    }

    public static boolean isRoot(PsiFileSystemItem directory2) {
        if (directory2 == null) {
            return true;
        }
        VirtualFile vFile = directory2.getVirtualFile();
        if (vFile == null) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)directory2.getProject());
        return Comparing.equal((Object)fileIndex.getClassRootForFile(vFile), (Object)vFile) || Comparing.equal((Object)fileIndex.getContentRootForFile(vFile), (Object)vFile) || Comparing.equal((Object)fileIndex.getSourceRootForFile(vFile), (Object)vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer {
        private final Font FONT;
        private final String myName;

        CellRenderer(String name) {
            this.myName = name;
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.FONT = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            ImportCandidateHolder item = (ImportCandidateHolder)value;
            PsiElement importable = ((ImportCandidateHolder)value).getImportable();
            if (importable != null) {
                this.setIcon(importable.getIcon(0));
            }
            String item_name = item.getPresentableText(this.myName);
            this.append(item_name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setFont(this.FONT);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

