/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.commandLine.psi.impl;

import com.intellij.psi.PsiElement;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.Option;
import com.jetbrains.commandInterface.commandLine.CommandLinePart;
import com.jetbrains.commandInterface.commandLine.ValidationResult;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineArgument;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineOption;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandLinePsiImplUtils {
    private CommandLinePsiImplUtils() {
    }

    static boolean isLong(@NotNull CommandLineOption o) {
        if (o == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(0);
        }
        return o.getLongOptionNameToken() != null;
    }

    @Nullable
    static CommandLineArgument findArgument(@NotNull CommandLineOption option) {
        if (option == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(1);
        }
        if (option.getText().endsWith("=")) {
            return PyUtil.as(option.getNextSibling(), CommandLineArgument.class);
        }
        return null;
    }

    @Nullable
    static Option findRealOption(@NotNull CommandLineOption option) {
        ValidationResult validationResult;
        if (option == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(2);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(option)) == null) {
            return null;
        }
        return validationResult.getOption(option);
    }

    @NotNull
    static String getValueNoQuotes(@NotNull CommandLineArgument argument) {
        char[] chars;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(3);
        }
        if ((chars = argument.getText().toCharArray()).length == 0) {
            if ("" == null) {
                CommandLinePsiImplUtils.$$$reportNull$$$0(4);
            }
            return "";
        }
        char firstChar = chars[0];
        if (firstChar == chars[chars.length - 1] && firstChar == '\"' || firstChar == '\'') {
            String string = argument.getText().substring(1, argument.getTextLength() - 1);
            if (string == null) {
                CommandLinePsiImplUtils.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = argument.getText();
        if (string == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    static Help findBestHelp(@NotNull CommandLineArgument argument) {
        Option option;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(7);
        }
        if ((option = argument.findOptionForOptionArgument()) != null) {
            return option.getHelp();
        }
        Argument realArgument = argument.findRealArgument();
        return realArgument != null ? realArgument.getHelp() : null;
    }

    @Nullable
    static Argument findRealArgument(@NotNull CommandLineArgument argument) {
        ValidationResult validationResult;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(8);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(argument)) == null) {
            return null;
        }
        return validationResult.getArgument(argument);
    }

    @Nullable
    static Option findOptionForOptionArgument(@NotNull CommandLineArgument argument) {
        ValidationResult validationResult;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(9);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(argument)) == null) {
            return null;
        }
        return validationResult.getOptionForOptionArgument(argument);
    }

    @Nullable
    private static ValidationResult getValidationResult(@NotNull CommandLinePart commandLinePart) {
        CommandLineFile commandLineFile;
        if (commandLinePart == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(10);
        }
        if ((commandLineFile = commandLinePart.getCommandLineFile()) == null) {
            return null;
        }
        ValidationResult validationResult = commandLineFile.getValidationResult();
        if (validationResult == null) {
            return null;
        }
        return validationResult;
    }

    @Nullable
    @NonNls
    static String getOptionName(@NotNull CommandLineOption o) {
        PsiElement longNameToken;
        if (o == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(11);
        }
        if ((longNameToken = o.getLongOptionNameToken()) != null) {
            return longNameToken.getText();
        }
        PsiElement shortOptionNameToken = o.getShortOptionNameToken();
        if (shortOptionNameToken != null) {
            return shortOptionNameToken.getText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/commandLine/psi/impl/CommandLinePsiImplUtils";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLinePart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/commandLine/psi/impl/CommandLinePsiImplUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueNoQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLong";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArgument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRealOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueNoQuotes";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBestHelp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRealArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOptionForOptionArgument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValidationResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOptionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

