/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final DomElement myElement;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;
    private final DomElementNavigationProvider myNavigationProvider;

    public DomStructureTreeElement(@NotNull DomElement element, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor2, @Nullable DomElementNavigationProvider navigationProvider) {
        if (element == null) {
            DomStructureTreeElement.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            DomStructureTreeElement.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myDescriptor = descriptor2;
        this.myNavigationProvider = navigationProvider;
    }

    public DomElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Object getValue() {
        return this.myElement.isValid() ? this.myElement.getXmlElement() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        DomStructureTreeElement domStructureTreeElement = this;
        if (domStructureTreeElement == null) {
            DomStructureTreeElement.$$$reportNull$$$0(2);
        }
        return domStructureTreeElement;
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (!this.myElement.isValid()) {
            if (EMPTY_ARRAY == null) {
                DomStructureTreeElement.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        DomElementVisitor elementVisitor = new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                if (element instanceof GenericDomValue) {
                    return;
                }
                DomService.StructureViewMode viewMode = (DomService.StructureViewMode)DomStructureTreeElement.this.myDescriptor.fun((Object)element);
                switch (viewMode) {
                    case SHOW: {
                        result.add(DomStructureTreeElement.this.createChildElement(element));
                        break;
                    }
                    case SHOW_CHILDREN: {
                        DomUtil.acceptAvailableChildren((DomElement)element, (DomElementVisitor)this);
                        break;
                    }
                }
            }
        };
        DomUtil.acceptAvailableChildren((DomElement)this.myElement, (DomElementVisitor)elementVisitor);
        TreeElement[] treeElementArray = result.toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            DomStructureTreeElement.$$$reportNull$$$0(4);
        }
        return treeElementArray;
    }

    protected StructureViewTreeElement createChildElement(DomElement element) {
        return new DomStructureTreeElement(element, this.myDescriptor, this.myNavigationProvider);
    }

    public void navigate(boolean requestFocus) {
        if (this.myNavigationProvider != null) {
            this.myNavigationProvider.navigate(this.myElement, requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public String getPresentableText() {
        if (!this.myElement.isValid()) {
            return "<unknown>";
        }
        try {
            ElementPresentation presentation = this.myElement.getPresentation();
            String name = presentation.getElementName();
            return name != null ? name : presentation.getTypeName();
        }
        catch (IndexNotReadyException e) {
            return "Name not available during indexing";
        }
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean open2) {
        if (!this.myElement.isValid()) {
            return null;
        }
        return this.myElement.getPresentation().getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/structure/DomStructureTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/structure/DomStructureTreeElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

