/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;

public class IpnbMoveCellDownAction
extends AnAction {
    private final IpnbFileEditor myEditor;

    public IpnbMoveCellDownAction(IpnbFileEditor editor) {
        super("Move cell down", "Move cell down", AllIcons.Actions.MoveDown);
        this.myEditor = editor;
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)(SystemInfo.isMac ? "meta shift DOWN" : "control shift DOWN"))}), this.myEditor.getIpnbFilePanel());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IpnbMoveCellDownAction.$$$reportNull$$$0(0);
        }
        IpnbFilePanel ipnbFilePanel = this.myEditor.getIpnbFilePanel();
        ipnbFilePanel.executeSaveFileCommand();
        ipnbFilePanel.executeUndoableCommand(() -> ipnbFilePanel.moveCell(true), "Move Cell");
    }

    public void update(@NotNull AnActionEvent e) {
        IpnbFilePanel ipnbFilePanel;
        IpnbEditablePanel selectedCellPanel;
        if (e == null) {
            IpnbMoveCellDownAction.$$$reportNull$$$0(1);
        }
        if ((selectedCellPanel = (ipnbFilePanel = this.myEditor.getIpnbFilePanel()).getSelectedCellPanel()) != null) {
            boolean editing = selectedCellPanel.isEditing();
            e.getPresentation().setEnabled(!editing);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbMoveCellDownAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

