/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.FileIterationListener;

public class IgnoreGroupHelperAction {
    private boolean myAllCanBeIgnored;
    private boolean myAllAreIgnored;
    private FileIterationListener myListener;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(0);
        }
        this.myAllAreIgnored = true;
        this.myAllCanBeIgnored = true;
        Project project = e.getProject();
        SvnVcs vcs = project != null ? SvnVcs.getInstance(project) : null;
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean visible = project != null;
        e.getPresentation().setEnabled(visible && vcs != null && !ArrayUtil.isEmpty((Object[])files) && this.isEnabled(vcs, (VirtualFile[])files));
        e.getPresentation().setVisible(visible);
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files) {
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(1);
        }
        if (files == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(2);
        }
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && Stream.of(files).allMatch(file -> this.isEnabled(vcs, (VirtualFile)file));
    }

    public void setFileIterationListener(FileIterationListener listener) {
        this.myListener = listener;
    }

    private boolean isEnabledImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(4);
        }
        if (SvnStatusUtil.isIgnoredInAnySense(vcs.getProject(), file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored;
        }
        if (ChangeListManager.getInstance((Project)vcs.getProject()).isUnversioned(file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent)) {
            this.myAllAreIgnored = false;
            return this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        boolean result;
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(6);
        }
        if (result = this.isEnabledImpl(vcs, file)) {
            this.myListener.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

