/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;

public class ResolveAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.name.resolve.conflict", new Object[0]);
        if (string == null) {
            ResolveAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            ResolveAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ResolveAction.$$$reportNull$$$0(2);
        }
        FileStatus status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file);
        return file.isDirectory() || FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            ResolveAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ResolveAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ResolveAction.$$$reportNull$$$0(5);
        }
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) {
        if (vcs == null) {
            ResolveAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            ResolveAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ResolveAction.$$$reportNull$$$0(8);
        }
        boolean hasDirs = ContainerUtil.exists((Object[])files, VirtualFile::isDirectory);
        ArrayList fileList = ContainerUtil.newArrayList();
        if (!hasDirs) {
            Collections.addAll(fileList, files);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                for (VirtualFile file : files) {
                    if (file.isDirectory()) {
                        ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).iterateVcsRoot(file, filePath -> {
                            ProgressManager.checkCanceled();
                            VirtualFile fileOrDir = filePath.getVirtualFile();
                            if (fileOrDir != null && !fileOrDir.isDirectory() && this.isEnabled(vcs, fileOrDir) && !fileList.contains(fileOrDir)) {
                                fileList.add(fileOrDir);
                            }
                            return true;
                        });
                        continue;
                    }
                    if (fileList.contains(file)) continue;
                    fileList.add(file);
                }
            }, SvnBundle.message("progress.searching.for.files.with.conflicts", new Object[0]), true, vcs.getProject());
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)vcs.getProject()).ensureFilesWritable((Collection)fileList);
        fileList.removeAll(Arrays.asList(status.getReadonlyFiles()));
        AbstractVcsHelper.getInstance((Project)vcs.getProject()).showMergeDialog((List)fileList, (MergeProvider)new SvnMergeProvider(vcs.getProject()));
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/ResolveAction";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/ResolveAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

