/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.hierarchy.AbstractOWLPropertyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;

public class OWLObjectPropertyHierarchyProvider
extends AbstractOWLPropertyHierarchyProvider<OWLClassExpression, OWLObjectPropertyExpression, OWLObjectProperty> {
    public OWLObjectPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    protected Set<OWLObjectProperty> getPropertiesReferencedInChange(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLObjectProperty> properties = new HashSet<OWLObjectProperty>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange axiomChange = (OWLAxiomChange)oWLOntologyChange;
            for (OWLEntity entity : axiomChange.getSignature()) {
                if (!entity.isOWLObjectProperty()) continue;
                properties.add(entity.asOWLObjectProperty());
            }
        }
        return properties;
    }

    @Override
    protected Set<? extends OWLObjectProperty> getReferencedProperties(OWLOntology ont) {
        return ont.getObjectPropertiesInSignature();
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom> getSubPropertyAxiomForRHS(OWLObjectProperty prop, OWLOntology ont) {
        return ont.getObjectSubPropertyAxiomsForSuperProperty((OWLObjectPropertyExpression)prop);
    }

    @Override
    protected OWLObjectProperty getRoot() {
        return this.getManager().getOWLDataFactory().getOWLTopObjectProperty();
    }

    @Override
    protected boolean containsReference(OWLOntology ont, OWLObjectProperty prop) {
        return ont.containsObjectPropertyInSignature(prop.getIRI());
    }

    @Override
    protected Collection<OWLObjectProperty> getSuperProperties(OWLObjectProperty subProperty, Set<OWLOntology> ontologies) {
        return EntitySearcher.getSuperProperties((OWLObjectPropertyExpression)subProperty, ontologies).stream().filter(p -> !p.isAnonymous()).map(p -> (OWLObjectProperty)p).collect(Collectors.toList());
    }

    @Override
    protected Collection<OWLObjectProperty> getSubProperties(OWLObjectProperty superProp, Set<OWLOntology> ontologies) {
        ArrayList<OWLObjectProperty> result = new ArrayList<OWLObjectProperty>();
        for (OWLOntology ont : ontologies) {
            ont.getObjectSubPropertyAxiomsForSuperProperty((OWLObjectPropertyExpression)superProp).stream().map(OWLSubPropertyAxiom::getSubProperty).filter(p -> !p.isAnonymous()).map(p -> (OWLObjectProperty)p).forEach(result::add);
        }
        return result;
    }
}

