# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SurfaceLICInterface(Object):
    """
    SurfaceLICInterface - public API for surface lic parameters
     arbitrary geometry.
    
    Superclass: Object
    
    SurfaceLICInterface performs LIC on the surface of arbitrary
     geometry. Point vectors are used as the vector field for generating
    the LIC.
     The implementation was originallu  based on "Image Space Based
    Visualization
     on Unsteady Flow on Surfaces" by Laramee, Jobard and Hauser appeared
    in
     proceedings of IEEE Visualization '03, pages 131-138.
    
    
     Internal pipeline:
    
    noise
        |
        [ PROJ (GAT) (COMP) lic2d (SCAT) SHADE (CCE) DEP]
        |                                               | vectors        
                                    surface LIC  PROj  - prject vectors
    onto surface GAT   - gather data for compositing and guard pixel
    generation  (parallel only) COMP  - composite gathered data lic2d -
    line intengral convolution, see LineIntegralConvolution2D. SCAT  -
    scatter result (parallel only, not all compositors use it) SHADE -
    combine LIC and scalar colors CCE   - color contrast enhancement
    (optional) DEP   - depth test and copy to back buffer
    
    The result of each stage is cached in a texture so that during
    interaction a stage may be skipped if the user has not modified its
    parameters or input data.
    
    The parallel parts of algorithm are implemented in
    PSurfaceLICInterface. Note that for MPI enabled builds this class
    will be automatically created by the object factory.
    
    @sa
    LineIntegralConvolution2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSurfaceLICInterface, obj, update, **traits)
    
    anti_alias = tvtk_base.false_bool_trait(desc=\
        """
        Enable/Disable the anti-aliasing pass. This optional pass
        (disabled by default) can be enabled to reduce jagged patterns in
        the final LIC image. Values greater than 0 control the number of
        iterations, 1 is typically sufficient.
        """
    )

    def _anti_alias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAntiAlias,
                        self.anti_alias_)

    enable = tvtk_base.true_bool_trait(desc=\
        """
        Enable/Disable LIC.
        """
    )

    def _enable_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnable,
                        self.enable_)

    enhanced_lic = tvtk_base.true_bool_trait(desc=\
        """
        enhanced_lic mean compute the LIC twice with the second pass using
        the edge-enhanced result of the first pass as a noise texture.
        Edge enhancedment is made by a simple Laplace convolution.
        """
    )

    def _enhanced_lic_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhancedLIC,
                        self.enhanced_lic_)

    mask_on_surface = tvtk_base.false_bool_trait(desc=\
        """
        When set mask_on_surface computes |V| for use in the fragment
        masking tests on the surface. When not set the original
        un-projected un-transformed |V| is used.
        """
    )

    def _mask_on_surface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskOnSurface,
                        self.mask_on_surface_)

    normalize_vectors = tvtk_base.true_bool_trait(desc=\
        """
        Normalize vectors during integration. When set(the default) the
        input vector field is normalized during integration, and each
        integration occurs over the same arclength. When not set each
        integration occurs over an arc length proportional to the field
        magnitude as is customary in traditional numerical methods. See, "Imaging Vector Fields Using Line Integral
        Convolution" for an axample where normalization is used. See,
        "Image Space Based Visualization of Unsteady Flow on Surfaces"
        for an example of where no normalization is used.
        """
    )

    def _normalize_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalizeVectors,
                        self.normalize_vectors_)

    color_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the color mode. The color mode controls how scalar colors
        are combined with the LIC in the final image. The BLEND mode
        combines scalar colors with LIC intensities with proportional
        blending controlled by the LICIntensity parameter. The MAP mode
        combines scalar colors with LIC, by multiplication the HSL
        represntation of color's lightness.
        
        * The default is COLOR_MODE_BLEND.
        """
    )

    def _color_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorMode,
                        self.color_mode)

    composite_strategy = traits.Int(3, enter_set=True, auto_set=False, desc=\
        """
        Control the screen space decomposition where LIC is computed.
        """
    )

    def _composite_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeStrategy,
                        self.composite_strategy)

    enhance_contrast = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Enable/Disable contrast and dynamic range correction stages.
        Contrast enhancement can be enabled during LIC computations (See
        LineINtegralComvolution2D) and after the scalar colors have
        been combined with the LIC.
        
        * The best approach for using this feature is to enable LIC
          enhancement,
        * and only if the image is to dark or dull enable COLOR
          enhancement.
        
        * Both stages are implemented by a histogram stretching
          algorithm. During
        * LIC stages the contrast enhancement is applied to gray scale
          LIC image.
        * During the scalar coloring stage the contrast enhancement is
          applied to
        * the lightness channel of the color image in HSL color space.
          The
        * histogram stretching is implemented as follows:
        
        * L = (L-m)/(M-m)
        
        * where, L is the fragment intensity/lightness, m is the
          intensity/lightness
        * to map to 0, M is the intensity/lightness to map to 1. The
          default values
        * of m and M are the min and max taken over all fragments.
        
        * This increase the dynamic range and contrast in the LIC'd
          image, both of
        * which are natuarly attenuated by the convolution process.
        
        * Values
        
        * ENHANCE_CONTRAST_OFF   -- don't enhance LIC or scalar colors
        * ENHANCE_CONTRAST_LIC   -- enhance in LIC high-pass input and
          output
        * ENHANCE_CONTRAST_COLOR -- enhance after scalars are combined
          with LIC
        * ENHANCE_CONTRAST_BOTH  -- enhance in LIC stages and after
          scalar colors
        
        * This feature is disabled by default.
        """
    )

    def _enhance_contrast_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhanceContrast,
                        self.enhance_contrast)

    generate_noise_texture = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the noise texture source. When not set the default
        200x200 white noise texture is used (see
        VTKData/Data/Data/noise.png). When set a noise texture is
        generated based on the following parameters:
        
        * noise_type               - select noise type. Gaussian, Uniform,
        etc
        * noise_texture_size        - number of pixels in square noise
          texture(side)
        * noise_grain_size          - number of pixels each noise value
          spans(side)
        * min_noise_value           - minimum noise color >=0 && <
          max_noise_value
        * max_noise_value           - maximum noise color <=1 ** >
          min_noise_value
        * number_of_noise_levels     - number of discrete noise colors
        * impulse_noise_probability - impulse noise is generated when < 1
        * impulse_noise_background_value  - the background color for
          untouched pixels
        * noise_generator_seed      - seed the random number generators
        
        * Changing the noise texture gives one greater control over the
          look of the
        * final image. The default is 0 which results in the use of a
          static 200x200
        * Gaussian noise texture. See VTKData/Data/Data/noise.png.
        """
    )

    def _generate_noise_texture_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateNoiseTexture,
                        self.generate_noise_texture)

    has_vectors = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Does the data have vectors which we require
        """
    )

    def _has_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHasVectors,
                        self.has_vectors)

    high_color_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _high_color_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighColorContrastEnhancementFactor,
                        self.high_color_contrast_enhancement_factor)

    high_lic_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        This feature is used to fine tune the contrast enhancement. There
        are two modes AUTOMATIC and MANUAL.In AUTOMATIC mode values are
        provided indicating the fraction of the range to adjust M and m
        by, during contrast enahncement histogram stretching. M and m are
        the intensity/lightness values that map to 1 and 0. (see
        enhance_contrast for an explanation of the mapping procedure). m
        and M are computed using the factors as follows:
        
        * m = min(C) + m_factor * (max(C) - min(C))
        * M = max(C) - MFactor * (max(C) - min(C))
        
        * the default values for m_factor and MFactor are 0 which result
          in
        * m = min(C), M = max(C), taken over the entire image. Modifying
          m_factor and
        * MFactor above or below zero provide control over the
          saturation/
        * de-saturation during contrast enhancement.
        """
    )

    def _high_lic_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighLICContrastEnhancementFactor,
                        self.high_lic_contrast_enhancement_factor)

    impulse_noise_background_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        The color to use for untouched pixels when impulse noise
        probability < 1.
        """
    )

    def _impulse_noise_background_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImpulseNoiseBackgroundValue,
                        self.impulse_noise_background_value)

    impulse_noise_probability = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Control the density of of the noise. A value of 1.0 produces
        uniform random noise while values < 1.0 produce impulse noise
        with the given probability.
        """
    )

    def _impulse_noise_probability_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImpulseNoiseProbability,
                        self.impulse_noise_probability)

    lic_intensity = traits.Float(0.8, enter_set=True, auto_set=False, desc=\
        """
        Factor used when blend mode is set to COLOR_MODE_BLEND. This
        controls the contribution of the LIC in the final output image as
        follows:
        
        * c = LIC * LICIntensity + scalar * (1 - LICIntensity);
        
        * 0.0 produces same result as disabling LIC altogether, while 1.0
        implies
        * show LIC result alone.
        """
    )

    def _lic_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLICIntensity,
                        self.lic_intensity)

    low_color_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _low_color_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowColorContrastEnhancementFactor,
                        self.low_color_contrast_enhancement_factor)

    low_lic_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        This feature is used to fine tune the contrast enhancement. There
        are two modes AUTOMATIC and MANUAL.In AUTOMATIC mode values are
        provided indicating the fraction of the range to adjust M and m
        by, during contrast enahncement histogram stretching. M and m are
        the intensity/lightness values that map to 1 and 0. (see
        enhance_contrast for an explanation of the mapping procedure). m
        and M are computed using the factors as follows:
        
        * m = min(C) + m_factor * (max(C) - min(C))
        * M = max(C) - MFactor * (max(C) - min(C))
        
        * the default values for m_factor and MFactor are 0 which result
          in
        * m = min(C), M = max(C), taken over the entire image. Modifying
          m_factor and
        * MFactor above or below zero provide control over the
          saturation/
        * de-saturation during contrast enhancement.
        """
    )

    def _low_lic_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowLICContrastEnhancementFactor,
                        self.low_lic_contrast_enhancement_factor)

    map_mode_bias = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Factor used when blend mode is set to COLOR_MODE_MAP. This adds a
        bias to the LIC image. The purpose of this is to adjust the
        brightness when a brighter image is desired. The default of 0.0
        results in no change. Values gretaer than 0.0 will brighten the
        image while values less than 0.0 darken the image.
        """
    )

    def _map_mode_bias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMapModeBias,
                        self.map_mode_bias)

    mask_color = tvtk_base.vtk_color_trait((0.5, 0.5, 0.5), desc=\
        """
        The mask_color is used on masked fragments. The default of (0.5,
        0.5, 0.5) makes the masked fragments look similar to the LIC'd
        fragments. The mask color is applied only when mask_intensity > 0.
        """
    )

    def _mask_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskColor,
                        self.mask_color, False)

    mask_intensity = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        The mask_intensity controls the blending of the mask color and the
        geometry color. The color of masked fragments is given by:
        
        * c = mask_color * mask_intensity + geom_color * (1 - mask_intensity)
        
        * The default value of 0.0 results in the geometry color being
          used.
        """
    )

    def _mask_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskIntensity,
                        self.mask_intensity)

    mask_threshold = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        The mask_threshold controls the rendering of fragments in stagnant
        regions of flow.  // In these regions LIC noise texture will be
        masked, where |V| < mask_threshold is satisfied. The masking
        process blends a the mask_color with the scalar color of the
        surface proportional to mask_intesnsity. See mask_intensity for
        more information on the blending algorithm. This blending allows
        one control over the masking process so that masked fragments may
        be: highlighted (by setting a unique mask color and mask
        intensity > 0), made invisible with and without passing the
        un-convolved noise texture (by setting mask intensity 0), made to
        blend into the LIC.
        
        * mask_threshold units are in the original vector space. Note that
        the
        * threshold can be applied to the original vector field or to the
        surface
        * projected vector field. See mask_on_surface.
        """
    )

    def _mask_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskThreshold,
                        self.mask_threshold)

    max_noise_value = traits.Float(0.8, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the minimum and mximum  gray scale values that the
        generated noise can take on. The generated noise will be in the
        range of min_noise_value to max_noise_value. Values are clamped
        within 0 to 1. min_noise_value must be less than max_noise_value.
        """
    )

    def _max_noise_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNoiseValue,
                        self.max_noise_value)

    min_noise_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the minimum and mximum  gray scale values that the
        generated noise can take on. The generated noise will be in the
        range of min_noise_value to max_noise_value. Values are clamped
        within 0 to 1. min_noise_value must be less than max_noise_value.
        """
    )

    def _min_noise_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinNoiseValue,
                        self.min_noise_value)

    def _get_noise_data_set(self):
        return wrap_vtk(self._vtk_obj.GetNoiseDataSet())
    def _set_noise_data_set(self, arg):
        old_val = self._get_noise_data_set()
        self._wrap_call(self._vtk_obj.SetNoiseDataSet,
                        deref_vtk(arg))
        self.trait_property_changed('noise_data_set', old_val, arg)
    noise_data_set = traits.Property(_get_noise_data_set, _set_noise_data_set, desc=\
        """
        Set the data containing a noise array as active scalars. Active
        scalars array will be converted into a texture for use as noise
        in the LIC process. Noise datasets are expected to be gray scale.
        """
    )

    noise_generator_seed = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the seed value used by the random number generator.
        """
    )

    def _noise_generator_seed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseGeneratorSeed,
                        self.noise_generator_seed)

    noise_grain_size = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Each noise value will be length^2 pixels in area.
        """
    )

    def _noise_grain_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseGrainSize,
                        self.noise_grain_size)

    noise_texture_size = traits.Int(200, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the side length in pixels of the noise texture. The
        texture will be length^2 pixels in area.
        """
    )

    def _noise_texture_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseTextureSize,
                        self.noise_texture_size)

    noise_type = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Select the statistical distribution of randomly generated noise
        values. With uniform noise there is greater control over the
        range of values in the noise texture. The Default is
        NOISE_TYPE_GAUSSIAN.
        """
    )

    def _noise_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseType,
                        self.noise_type)

    number_of_noise_levels = traits.Int(256, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the number of discrete values a noise pixel may take on.
        Default 1024.
        """
    )

    def _number_of_noise_levels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfNoiseLevels,
                        self.number_of_noise_levels)

    number_of_steps = traits.Int(20, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the number of integration steps in each direction.
        """
    )

    def _number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSteps,
                        self.number_of_steps)

    step_size = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the step size (in pixels).
        """
    )

    def _step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepSize,
                        self.step_size)

    def apply_lic(self):
        """
        V.apply_lic()
        C++: void ApplyLIC()"""
        ret = self._vtk_obj.ApplyLIC()
        return ret
        

    def can_render_surface_lic(self, *args):
        """
        V.can_render_surface_lic(Actor) -> bool
        C++: bool CanRenderSurfaceLIC(Actor *actor)
        Returns true when rendering LIC is possible.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanRenderSurfaceLIC, *my_args)
        return ret

    def combine_colors_and_lic(self):
        """
        V.combine_colors_and_lic()
        C++: void CombineColorsAndLIC()"""
        ret = self._vtk_obj.CombineColorsAndLIC()
        return ret
        

    def completed_geometry(self):
        """
        V.completed_geometry()
        C++: void CompletedGeometry()"""
        ret = self._vtk_obj.CompletedGeometry()
        return ret
        

    def copy_to_screen(self):
        """
        V.copy_to_screen()
        C++: void CopyToScreen()"""
        ret = self._vtk_obj.CopyToScreen()
        return ret
        

    def create_communicator(self, *args):
        """
        V.create_communicator(Renderer, Actor, DataObject)
        C++: void CreateCommunicator(Renderer *, Actor *,
            DataObject *data)
        Creates a new communicator for internal use based on this rank's
        visible data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CreateCommunicator, *my_args)
        return ret

    def gather_vectors(self):
        """
        V.gather_vectors()
        C++: void GatherVectors()"""
        ret = self._vtk_obj.GatherVectors()
        return ret
        

    def initialize_resources(self):
        """
        V.initialize_resources()
        C++: void InitializeResources()
        resoucre allocators
        """
        ret = self._vtk_obj.InitializeResources()
        return ret
        

    def is_supported(self, *args):
        """
        V.is_supported(RenderWindow) -> bool
        C++: static bool IsSupported(RenderWindow *context)
        Returns true if the rendering context supports extensions needed
        by this painter.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def prepare_for_geometry(self):
        """
        V.prepare_for_geometry()
        C++: void PrepareForGeometry()"""
        ret = self._vtk_obj.PrepareForGeometry()
        return ret
        

    def release_graphics_resources(self, *args):
        """
        V.release_graphics_resources(Window)
        C++: virtual void ReleaseGraphicsResources(Window *win)
        Release any graphics resources that are being consumed by this
        mapper. The parameter window could be used to determine which
        graphic resources to release. In this case, releases the display
        lists.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def shallow_copy(self, *args):
        """
        V.shallow_copy(SurfaceLICInterface)
        C++: void ShallowCopy(SurfaceLICInterface *m)
        Make a shallow copy of this interface
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShallowCopy, *my_args)
        return ret

    def update_communicator(self, *args):
        """
        V.update_communicator(Renderer, Actor, DataObject)
        C++: void UpdateCommunicator(Renderer *renderer,
            Actor *actor, DataObject *data)
        Called from a mapper, does what is needed to make sure the
        communicators are ready
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateCommunicator, *my_args)
        return ret

    def validate_context(self, *args):
        """
        V.validate_context(Renderer)
        C++: void ValidateContext(Renderer *renderer)
        Look for changes that would trigger stage updates
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ValidateContext, *my_args)
        return ret

    def write_timer_log(self, *args):
        """
        V.write_timer_log(string)
        C++: virtual void WriteTimerLog(const char *)
        Methods used for parallel benchmarks. Use cmake to define
        SurfaceLICMapperTIME to enable benchmarks. During each update
        timing information is stored, it can be written to disk by
        calling write_log.
        """
        ret = self._wrap_call(self._vtk_obj.WriteTimerLog, *args)
        return ret

    _updateable_traits_ = \
    (('anti_alias', 'GetAntiAlias'), ('enable', 'GetEnable'),
    ('enhanced_lic', 'GetEnhancedLIC'), ('mask_on_surface',
    'GetMaskOnSurface'), ('normalize_vectors', 'GetNormalizeVectors'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('color_mode', 'GetColorMode'),
    ('composite_strategy', 'GetCompositeStrategy'), ('enhance_contrast',
    'GetEnhanceContrast'), ('generate_noise_texture',
    'GetGenerateNoiseTexture'), ('has_vectors', 'GetHasVectors'),
    ('high_color_contrast_enhancement_factor',
    'GetHighColorContrastEnhancementFactor'),
    ('high_lic_contrast_enhancement_factor',
    'GetHighLICContrastEnhancementFactor'),
    ('impulse_noise_background_value', 'GetImpulseNoiseBackgroundValue'),
    ('impulse_noise_probability', 'GetImpulseNoiseProbability'),
    ('lic_intensity', 'GetLICIntensity'),
    ('low_color_contrast_enhancement_factor',
    'GetLowColorContrastEnhancementFactor'),
    ('low_lic_contrast_enhancement_factor',
    'GetLowLICContrastEnhancementFactor'), ('map_mode_bias',
    'GetMapModeBias'), ('mask_color', 'GetMaskColor'), ('mask_intensity',
    'GetMaskIntensity'), ('mask_threshold', 'GetMaskThreshold'),
    ('max_noise_value', 'GetMaxNoiseValue'), ('min_noise_value',
    'GetMinNoiseValue'), ('noise_generator_seed',
    'GetNoiseGeneratorSeed'), ('noise_grain_size', 'GetNoiseGrainSize'),
    ('noise_texture_size', 'GetNoiseTextureSize'), ('noise_type',
    'GetNoiseType'), ('number_of_noise_levels', 'GetNumberOfNoiseLevels'),
    ('number_of_steps', 'GetNumberOfSteps'), ('step_size', 'GetStepSize'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['anti_alias', 'debug', 'enable', 'enhanced_lic',
    'global_warning_display', 'mask_on_surface', 'normalize_vectors',
    'color_mode', 'composite_strategy', 'enhance_contrast',
    'generate_noise_texture', 'has_vectors',
    'high_color_contrast_enhancement_factor',
    'high_lic_contrast_enhancement_factor',
    'impulse_noise_background_value', 'impulse_noise_probability',
    'lic_intensity', 'low_color_contrast_enhancement_factor',
    'low_lic_contrast_enhancement_factor', 'map_mode_bias', 'mask_color',
    'mask_intensity', 'mask_threshold', 'max_noise_value',
    'min_noise_value', 'noise_generator_seed', 'noise_grain_size',
    'noise_texture_size', 'noise_type', 'number_of_noise_levels',
    'number_of_steps', 'step_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SurfaceLICInterface, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SurfaceLICInterface properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['anti_alias', 'enable', 'enhanced_lic', 'mask_on_surface',
            'normalize_vectors'], [], ['color_mode', 'composite_strategy',
            'enhance_contrast', 'generate_noise_texture', 'has_vectors',
            'high_color_contrast_enhancement_factor',
            'high_lic_contrast_enhancement_factor',
            'impulse_noise_background_value', 'impulse_noise_probability',
            'lic_intensity', 'low_color_contrast_enhancement_factor',
            'low_lic_contrast_enhancement_factor', 'map_mode_bias', 'mask_color',
            'mask_intensity', 'mask_threshold', 'max_noise_value',
            'min_noise_value', 'noise_generator_seed', 'noise_grain_size',
            'noise_texture_size', 'noise_type', 'number_of_noise_levels',
            'number_of_steps', 'step_size']),
            title='Edit SurfaceLICInterface properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SurfaceLICInterface properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

