import { IrcBridge } from "./IrcBridge";
import { IrcServer } from "../irc/IrcServer";
export declare class PublicitySyncer {
    private ircBridge;
    private visibilityMap;
    private initModeQueue;
    constructor(ircBridge: IrcBridge);
    initModeForChannel(opts: {
        server: IrcServer;
        channel: string;
    }): Promise<void>;
    initModes(server: IrcServer): Promise<void>;
    /**
     * Returns the key used when calling `updateVisibilityMap` for updating an IRC channel
     * visibility mode (+s or -s).
     * ```
     * // Set channel on server to be +s
     * const key = publicitySyncer.getIRCVisMapKey(server.getNetworkId(), channel);
     * publicitySyncer.updateVisibilityMap(true, key, true);
     * ```
     * @param {string} networkId
     * @param {string} channel
     * @returns {string}
     */
    getIRCVisMapKey(networkId: string, channel: string): string;
    updateVisibilityMap(isMode: boolean, key: string, value: boolean, channel: string, server: IrcServer): void;
    private solveVisibility;
}
