/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class ModifierOrderer {
    static Modifier getModifier(int tokenId) {
        switch (tokenId) {
            case 103: {
                return Modifier.PUBLIC;
            }
            case 102: {
                return Modifier.PROTECTED;
            }
            case 101: {
                return Modifier.PRIVATE;
            }
            case 98: {
                return Modifier.ABSTRACT;
            }
            case 94: {
                return Modifier.STATIC;
            }
            case 212: {
                return null;
            }
            case 99: {
                return Modifier.FINAL;
            }
            case 105: {
                return Modifier.TRANSIENT;
            }
            case 106: {
                return Modifier.VOLATILE;
            }
            case 85: {
                return Modifier.SYNCHRONIZED;
            }
            case 100: {
                return Modifier.NATIVE;
            }
            case 104: {
                return Modifier.STRICTFP;
            }
        }
        return null;
    }

    public static String reorderModifiers(String text) throws FormatterException {
        return ModifierOrderer.reorderModifiers(text, Collections.singleton(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(text.length()))));
    }

    public static String reorderModifiers(String text, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput(text);
        if (javaInput.getTokens().isEmpty()) {
            return text;
        }
        RangeSet<Integer> tokenRanges = javaInput.characterRangesToTokenRanges(characterRanges);
        UnmodifiableIterator it = javaInput.getTokens().iterator();
        TreeRangeMap replacements = TreeRangeMap.create();
        while (it.hasNext()) {
            Modifier mod;
            Input.Token token = (Input.Token)it.next();
            if (!tokenRanges.contains((Comparable)Integer.valueOf(token.getTok().getIndex())) || (mod = ModifierOrderer.asModifier(token)) == null) continue;
            ArrayList<Input.Token> modifierTokens = new ArrayList<Input.Token>();
            ArrayList<Modifier> mods = new ArrayList<Modifier>();
            int begin = token.getTok().getPosition();
            mods.add(mod);
            modifierTokens.add(token);
            int end = -1;
            while (it.hasNext() && (mod = ModifierOrderer.asModifier(token = (Input.Token)it.next())) != null) {
                mods.add(mod);
                modifierTokens.add(token);
                end = token.getTok().getPosition() + token.getTok().length();
            }
            if (Ordering.natural().isOrdered(mods)) continue;
            Collections.sort(mods);
            StringBuilder replacement = new StringBuilder();
            for (int i = 0; i < mods.size(); ++i) {
                if (i > 0) {
                    ModifierOrderer.addTrivia(replacement, ((Input.Token)modifierTokens.get(i)).getToksBefore());
                }
                replacement.append(((Modifier)((Object)mods.get(i))).toString());
                if (i >= modifierTokens.size() - 1) continue;
                ModifierOrderer.addTrivia(replacement, ((Input.Token)modifierTokens.get(i)).getToksAfter());
            }
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end)), (Object)replacement.toString());
        }
        return ModifierOrderer.applyReplacements(javaInput.getText(), (TreeRangeMap<Integer, String>)replacements);
    }

    private static void addTrivia(StringBuilder replacement, ImmutableList<? extends Input.Tok> toks) {
        for (Input.Tok tok : toks) {
            replacement.append(tok.getText());
        }
    }

    private static Modifier asModifier(Input.Token token) {
        return ModifierOrderer.getModifier(((JavaInput.Tok)token.getTok()).id());
    }

    private static String applyReplacements(String text, TreeRangeMap<Integer, String> replacementMap) {
        Map ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        for (Map.Entry entry : ranges.entrySet()) {
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), (String)entry.getValue());
        }
        return sb.toString();
    }
}

