/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.internals.HtmlDomParserContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::HTML::Document"}, parent="Nokogiri::XML::Document")
public class HtmlDocument
extends XmlDocument {
    private static final String DEFAULT_CONTENT_TYPE = "html";
    private static final String DEFAULT_PUBLIC_ID = "-//W3C//DTD HTML 4.01//EN";
    private static final String DEFAULT_SYTEM_ID = "http://www.w3.org/TR/html4/strict.dtd";
    private String parsed_encoding = null;

    public HtmlDocument(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public HtmlDocument(Ruby ruby, RubyClass rubyClass, Document document) {
        super(ruby, rubyClass, document);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDocument htmlDocument;
        try {
            Document document = HtmlDocument.createNewDocument();
            htmlDocument = (HtmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
            htmlDocument.setDocumentNode(threadContext, document);
        }
        catch (Exception exception) {
            throw threadContext.getRuntime().newRuntimeError("couldn't create document: " + exception);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)htmlDocument, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return htmlDocument;
    }

    @Override
    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        Object object = super.getInternalSubset(threadContext);
        if (object.isNil()) {
            object = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_CONTENT_TYPE), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_PUBLIC_ID), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_SYTEM_ID));
            this.setInternalSubset((IRubyObject)object);
        }
        return object;
    }

    public static IRubyObject do_parse(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)4, (int)4);
        HtmlDomParserContext htmlDomParserContext = new HtmlDomParserContext(ruby, iRubyObjectArray[2], iRubyObjectArray[3]);
        htmlDomParserContext.setInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return htmlDomParserContext.parse(threadContext, iRubyObject, iRubyObjectArray[1]);
    }

    @Override
    public void setDocumentNode(ThreadContext threadContext, Node node) {
        super.setNode(threadContext, node);
        Ruby ruby = threadContext.getRuntime();
        if (node != null) {
            Document document = (Document)node;
            document.normalize();
            this.stabilzeAttrValue(document.getDocumentElement());
        }
        this.setInstanceVariable("@decorators", ruby.getNil());
    }

    private void stabilzeAttrValue(Node node) {
        int n;
        Object object;
        if (node == null) {
            return;
        }
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                Attr attr = (Attr)node2;
                String string = attr.getName();
                String string2 = attr.getValue();
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            this.stabilzeAttrValue(object.item(n));
        }
    }

    public void setParsedEncoding(String string) {
        this.parsed_encoding = string;
    }

    public String getPraedEncoding() {
        return this.parsed_encoding;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return HtmlDocument.do_parse(threadContext, iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return HtmlDocument.do_parse(threadContext, iRubyObject, iRubyObjectArray);
    }
}

