/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.epub;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import writer2latex.api.ContentEntry;
import writer2latex.api.ConverterResult;
import writer2latex.base.DOMDocument;
import writer2latex.util.Misc;

public class NavigationWriter
extends DOMDocument {
    public NavigationWriter(ConverterResult cr) {
        super("nav", "xhtml");
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("xhtml", "", "");
            contentDOM = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        Element doc = contentDOM.getDocumentElement();
        doc.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        doc.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        doc.setAttribute("xml:lang", cr.getMetaData().getLanguage());
        doc.setAttribute("lang", cr.getMetaData().getLanguage());
        Element head = contentDOM.createElement("head");
        doc.appendChild(head);
        Element title = contentDOM.createElement("title");
        head.appendChild(title);
        title.appendChild(contentDOM.createTextNode("EPUB 3 Navigation Document"));
        Element body = contentDOM.createElement("body");
        doc.appendChild(body);
        Element nav = contentDOM.createElement("nav");
        nav.setAttribute("epub:type", "toc");
        body.appendChild(nav);
        Element currentContainer = body;
        int nCurrentLevel = 0;
        int nCurrentEntryLevel = 0;
        for (ContentEntry entry : cr.getContent()) {
            int nEntryLevel = Math.max(entry.getLevel(), 1);
            if (nEntryLevel < nCurrentLevel) {
                for (int i = nEntryLevel; i < nCurrentLevel; ++i) {
                    currentContainer = (Element)currentContainer.getParentNode().getParentNode();
                }
                nCurrentLevel = nEntryLevel;
            } else if (nEntryLevel > nCurrentEntryLevel) {
                currentContainer = (Element)currentContainer.getLastChild();
                Element ol = contentDOM.createElement("ol");
                currentContainer.appendChild(ol);
                currentContainer = ol;
                ++nCurrentLevel;
            }
            nCurrentEntryLevel = nEntryLevel;
            Element li = contentDOM.createElement("li");
            currentContainer.appendChild(li);
            Element a = contentDOM.createElement("a");
            li.appendChild(a);
            String sHref = Misc.makeHref(entry.getFile().getFileName());
            if (entry.getTarget() != null) {
                sHref = sHref + "#" + entry.getTarget();
            }
            a.setAttribute("href", sHref);
            a.appendChild(contentDOM.createTextNode(entry.getTitle()));
        }
        this.setContentDOM(contentDOM);
    }
}

