"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var specs_1 = require("./actions/specs");
function usePrevious(value) {
    var ref = react_1.useRef();
    react_1.useEffect(function () {
        ref.current = value;
    });
    return ref.current;
}
function specComponentFactory(defaultProps) {
    var SpecInstance = function (props) {
        var prevId = usePrevious(props.id);
        var removeSpec = props.removeSpec, upsertSpec = props.upsertSpec, SpecInstance = __rest(props, ["removeSpec", "upsertSpec"]);
        react_1.useEffect(function () {
            if (prevId && prevId !== props.id) {
                removeSpec(prevId);
            }
            upsertSpec(SpecInstance);
        });
        react_1.useEffect(function () { return function () {
            removeSpec(props.id);
        }; }, []);
        return null;
    };
    SpecInstance.defaultProps = defaultProps;
    return SpecInstance;
}
exports.specComponentFactory = specComponentFactory;
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        upsertSpec: specs_1.upsertSpec,
        removeSpec: specs_1.removeSpec,
    }, dispatch);
};
function getConnect() {
    return react_redux_1.connect(null, mapDispatchToProps, null, { pure: false });
}
exports.getConnect = getConnect;
//# sourceMappingURL=spec_factory.js.map