"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
function renderRect(ctx, rect, fill, stroke, disableBoardOffset) {
    if (disableBoardOffset === void 0) { disableBoardOffset = false; }
    if (!fill && !stroke) {
        return;
    }
    if (fill) {
        var borderOffset = !disableBoardOffset && stroke && stroke.width > 0.001 ? stroke.width : 0;
        var x = rect.x + borderOffset;
        var y = rect.y + borderOffset;
        var width = rect.width - borderOffset * 2;
        var height = rect.height - borderOffset * 2;
        drawRect(ctx, { x: x, y: y, width: width, height: height });
        ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
        ctx.fill();
    }
    if (stroke && stroke.width > 0.001) {
        var borderOffset = !disableBoardOffset && stroke && stroke.width > 0.001 ? stroke.width / 2 : 0;
        var x = rect.x + borderOffset;
        var y = rect.y + borderOffset;
        var width = rect.width - borderOffset * 2;
        var height = rect.height - borderOffset * 2;
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        drawRect(ctx, { x: x, y: y, width: width, height: height });
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        else {
            ctx.lineCap = 'square';
        }
        ctx.stroke();
    }
}
exports.renderRect = renderRect;
function drawRect(ctx, rect) {
    var x = rect.x, y = rect.y, width = rect.width, height = rect.height;
    ctx.beginPath();
    ctx.moveTo(x, y);
    ctx.lineTo(x + width, y);
    ctx.lineTo(x + width, y + height);
    ctx.lineTo(x, y + height);
    ctx.lineTo(x, y);
}
function renderMultiRect(ctx, rects, fill, stroke) {
    if (!fill && !stroke && rects.length > 0) {
        return;
    }
    var rectsLength = rects.length;
    ctx.beginPath();
    for (var i = 0; i < rectsLength; i++) {
        var _a = rects[i], width = _a.width, height = _a.height, x = _a.x, y = _a.y;
        ctx.moveTo(x, y);
        ctx.lineTo(x + width, y);
        ctx.lineTo(x + width, y + height);
        ctx.lineTo(x, y + height);
        ctx.lineTo(x, y);
    }
    if (fill) {
        ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
        ctx.fill();
    }
    if (stroke && stroke.width > 0.001) {
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        ctx.stroke();
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        else {
            ctx.lineCap = 'square';
        }
    }
}
exports.renderMultiRect = renderMultiRect;
//# sourceMappingURL=rect.js.map