/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.ObjectReference;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IEvent;
import com.openshift.restclient.model.IObjectReference;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class KubernetesEvent
extends KubernetesResource
implements IEvent {
    public KubernetesEvent(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public String getReason() {
        return this.asString("reason");
    }

    @Override
    public String getMessage() {
        return this.asString("message");
    }

    @Override
    public IObjectReference getInvolvedObject() {
        return new ObjectReference(this.get("involvedObject"));
    }

    @Override
    public String getFirstSeenTimestamp() {
        return this.asString("firstTimestamp");
    }

    @Override
    public String getLastSeenTimestamp() {
        return this.asString("lastTimestamp");
    }

    @Override
    public int getCount() {
        return this.asInt("count");
    }

    @Override
    public String getType() {
        return this.asString("type");
    }

    @Override
    public IEvent.IEventSource getEventSource() {
        return new EventSource(this.get("source"), this.getPropertyKeys());
    }

    private static class EventSource
    extends ModelNodeAdapter
    implements IEvent.IEventSource {
        protected EventSource(ModelNode node, Map<String, String[]> propertyKeys) {
            super(node, propertyKeys);
        }

        @Override
        public String getComponent() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "component");
        }

        @Override
        public String getHost() {
            return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "host");
        }
    }
}

