/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Calendar;
import java.util.TimeZone;
import org.wildfly.clustering.marshalling.Externalizer;

public class CalendarExternalizer
implements Externalizer<Calendar> {
    public void writeObject(ObjectOutput output, Calendar calendar) throws IOException {
        output.writeUTF(calendar.getCalendarType());
        output.writeLong(calendar.getTimeInMillis());
        output.writeBoolean(calendar.isLenient());
        output.writeUTF(calendar.getTimeZone().getID());
        output.writeInt(calendar.getFirstDayOfWeek());
        output.writeInt(calendar.getMinimalDaysInFirstWeek());
    }

    public Calendar readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return new Calendar.Builder().setCalendarType(input.readUTF()).setInstant(input.readLong()).setLenient(input.readBoolean()).setTimeZone(TimeZone.getTimeZone(input.readUTF())).setWeekDefinition(input.readInt(), input.readInt()).build();
    }

    public Class<Calendar> getTargetClass() {
        return Calendar.class;
    }
}

