/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.GeometricConstants;
import org.hibernate.search.spatial.impl.Point;

public final class Rectangle {
    private final Point lowerLeft;
    private final Point upperRight;

    public Rectangle(Point lowerLeft, Point upperRight) {
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
    }

    public static Rectangle fromBoundingCircle(Coordinates centerCoordinates, double radius) {
        double minimumLongitude;
        double maximumLongitude;
        Point center = Point.fromCoordinates(centerCoordinates);
        double maximumLatitude = radius > center.getDistanceTo(GeometricConstants.NORTH_POLE) ? 90.0 : center.computeDestination(radius, 0.0).getLatitude();
        double minimumLatitude = radius > center.getDistanceTo(GeometricConstants.SOUTH_POLE) ? -90.0 : center.computeDestination(radius, 180.0).getLatitude();
        if (radius > 40030.173592041145 * Math.cos(Math.toRadians(minimumLatitude)) || radius > 40030.173592041145 * Math.cos(Math.toRadians(maximumLatitude))) {
            maximumLongitude = 180.0;
            minimumLongitude = -180.0;
        } else {
            Point referencePoint = Point.fromDegrees(Math.max(Math.abs(minimumLatitude), Math.abs(maximumLatitude)), center.getLongitude());
            maximumLongitude = referencePoint.computeDestination(radius, 90.0).getLongitude();
            minimumLongitude = referencePoint.computeDestination(radius, 270.0).getLongitude();
        }
        return new Rectangle(Point.fromDegreesInclusive(minimumLatitude, minimumLongitude), Point.fromDegreesInclusive(maximumLatitude, maximumLongitude));
    }

    public Point getLowerLeft() {
        return this.lowerLeft;
    }

    public Point getUpperRight() {
        return this.upperRight;
    }
}

