/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldBridgeDirectMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.NormalizerDefMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class PropertySpatialMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final PropertyDescriptor property;
    private final Map<String, Object> spatial = new HashMap<String, Object>();

    public PropertySpatialMapping(PropertyDescriptor property, EntityDescriptor entity, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.property = property;
        this.property.setSpatial(this.spatial);
    }

    public PropertySpatialMapping spatial() {
        return new PropertySpatialMapping(this.property, this.entity, this.mapping);
    }

    public PropertySpatialMapping name(String fieldName) {
        this.spatial.put("name", fieldName);
        return this;
    }

    public PropertySpatialMapping store(Store store) {
        this.spatial.put("store", (Object)store);
        return this;
    }

    public PropertySpatialMapping boost(float boost) {
        HashMap<String, Float> boostAnn = new HashMap<String, Float>();
        boostAnn.put("value", Float.valueOf(boost));
        this.spatial.put("boost", boostAnn);
        return this;
    }

    public PropertySpatialMapping spatialMode(SpatialMode spatialMode) {
        this.spatial.put("spatialMode", (Object)spatialMode);
        return this;
    }

    public PropertySpatialMapping topSpatialHashLevel(int topSpatialHashLevel) {
        this.spatial.put("topSpatialHashLevel", topSpatialHashLevel);
        return this;
    }

    public PropertySpatialMapping bottomSpatialHashLevel(int bottomSpatialHashLevel) {
        this.spatial.put("bottomSpatialHashLevel", bottomSpatialHashLevel);
        return this;
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public NormalizerDefMapping normalizerDef(String name) {
        return new NormalizerDefMapping(name, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public PropertyMapping bridge(Class<? extends FieldBridge> fieldBridge) {
        return new FieldBridgeDirectMapping(this.property, this.entity, this.mapping, fieldBridge);
    }
}

