/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class FilterMechanismSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final Predicate<String> predicate;

    public FilterMechanismSaslServerFactory(SaslServerFactory delegate, Predicate<String> predicate) {
        super(delegate);
        Assert.checkNotNullParam("predicate", predicate);
        this.predicate = predicate;
    }

    public FilterMechanismSaslServerFactory(SaslServerFactory delegate, boolean include, String ... mechanisms) {
        super(delegate);
        Assert.checkNotNullParam("mechanisms", mechanisms);
        HashSet set = new HashSet(mechanisms.length);
        Collections.addAll(set, mechanisms);
        Predicate<String> predicate = set::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    public FilterMechanismSaslServerFactory(SaslServerFactory delegate, boolean include, Collection<String> mechanisms) {
        super(delegate);
        Assert.checkNotNullParam("mechanisms", mechanisms);
        HashSet<String> set = new HashSet<String>(mechanisms);
        Predicate<String> predicate = set::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.predicate.test(mechanism) ? this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh) : null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names = this.delegate.getMechanismNames(props);
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            if (!this.predicate.test(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }
}

