#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.19.1
visibility:           public
id:                   hledger-web-1.19.1-61FYWVh9bxB50G87NLLHsT
key:                  hledger-web-1.19.1-61FYWVh9bxB50G87NLLHsT
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web-based user interface for the hledger accounting system
description:
    A simple web-based user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing/adding/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  05f200fed7a9c390697fa6b4de9e73a6
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.WebOptions
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-8.10.2/site-local/hledger-web-1.19.1
library-dirs:         /usr/lib/ghc-8.10.2/site-local/hledger-web-1.19.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.19.1-61FYWVh9bxB50G87NLLHsT
depends:
    Decimal-0.5.1-9IPt8BNm5MJ4Nt8J3lN05k
    aeson-1.5.4.1-KnFYQBtHaFk4DA2IEtMGGQ base-4.14.1.0
    blaze-html-0.9.1.2-GgRyndNAgYNKWOUjOsNqWL
    blaze-markup-0.8.2.7-LxYHHNtMMqd23FQvjJOkWQ bytestring-0.10.10.0
    case-insensitive-1.2.1.0-6j421Scg55hFNBQMOoQNh8
    clientsession-0.9.1.2-QQo5zJfhPU8kkcUQKC49s
    cmdargs-0.10.20-2pbK0xjyKWW1JFcGNWMDNe
    conduit-1.3.2.1-5dakMObNLok49pmlrMaNyb
    conduit-extra-1.3.5-JTlBLrvJxpl4QvgCIFssj1 containers-0.6.2.1
    data-default-0.7.1.1-1SXVr298bbN7TPT9oLTXkF directory-1.3.6.0
    extra-1.7.8-6e1u65nmIqT5kWQKi3WqHa filepath-1.4.2.1
    hjsmin-0.2.0.4-4G295z2VBCvFqhhVlKtbZf
    hledger-1.19.1-4AmRhyAgNcH9GefzKQ4DD4
    hledger-lib-1.19.1-9YSQmRB1DEdCfPujRdbYac
    http-client-0.7.2.1-7OhvwwnPZ621huXJguhv86
    http-conduit-2.3.7.3-JiQaWP3paIHG9sFc3Aegrf
    http-types-0.12.3-FxLAfw9EIlw5rHRJhgWond
    megaparsec-8.0.0-KxUaQFqNRX78KSxLwjdwOI mtl-2.2.2
    network-3.1.2.0-LV2SyCoH19f7UojfDeoOvT
    shakespeare-2.0.25-3l53jo95QEvD6of2L8gPbH template-haskell-2.16.0.0
    text-1.2.3.2 time-1.9.3 transformers-0.5.6.2
    unix-compat-0.5.2-7IcOHcLTxJI58jp45CNrGP
    unordered-containers-0.2.13.0-Fo8OAKTvtDP9k6MoYlsfQq
    utf8-string-1.0.1.1-G1tzxDqsWge3erFqc4Oe2R
    wai-3.2.2.1-4aXUvXhxq8PJNiszMuAPDj
    wai-cors-0.2.7-BGWsir4syr7Ab5cpKFaIVV
    wai-extra-3.1.1-C11dfwl8hDU4tlGMaSAP0x
    wai-handler-launch-3.0.3.1-J1cvNbFJEfa1SFyAF4lQu5
    warp-3.3.13-7J3eaVzNmU4CK22LX78ZlH
    yaml-0.11.5.0-2l4AtImX00lG1s1Z6WRplb
    yesod-1.6.1.0-C1lW2KJ5VeP3zUo6tdzyIb
    yesod-core-1.6.18.4-FbzFaPAaws6JOgMpBR61bR
    yesod-form-1.6.7-FVMUWkCmEy6BVGu7s84IpX
    yesod-static-1.6.1.0-XbTSDvnMUXHNHSq6voqcx

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

