#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 skylighting-core
version:              0.10.2
visibility:           public
id:                   skylighting-core-0.10.2-Kk1XwcDC2JXJ0Un8xxu7ld
key:                  skylighting-core-0.10.2-Kk1XwcDC2JXJ0Un8xxu7ld
license:              BSD-3-Clause
copyright:            (C) 2016-2018 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             https://github.com/jgm/skylighting
synopsis:             syntax highlighting library
description:
    Skylighting is a syntax highlighting library.
    It derives its tokenizers from XML syntax
    definitions used by KDE'\''s KSyntaxHighlighting
    framework, so any syntax supported by that
    framework can be added. An optional command-line
    program is provided.
    Skylighting is intended to be the successor to
    highlighting-kate.
    This package provides the core highlighting
    functionality under a permissive license. It also
    bundles XML parser definitions licensed under the
    GPL.

category:             Text
abi:                  68fa7bb5e8fcb9d522514ec3e51f0478
exposed:              True
exposed-modules:
    Skylighting.Core Skylighting.Format.ANSI Skylighting.Format.HTML
    Skylighting.Format.LaTeX Skylighting.Loader Skylighting.Parser
    Skylighting.Regex Skylighting.Styles Skylighting.Tokenizer
    Skylighting.Types

hidden-modules:
    Regex.KDE Regex.KDE.Regex Regex.KDE.Compile Regex.KDE.Match

import-dirs:          /usr/lib/ghc-8.10.3/site-local/skylighting-core-0.10.2
library-dirs:         /usr/lib/ghc-8.10.3/site-local/skylighting-core-0.10.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.3/skylighting-core-0.10.2
hs-libraries:         HSskylighting-core-0.10.2-Kk1XwcDC2JXJ0Un8xxu7ld
depends:
    aeson-1.5.5.1-9jeVsPSyrWB7SomB2C4Dbq
    ansi-terminal-0.11-2SXi8ZhU18i2uWLidRUotS
    attoparsec-0.13.2.5-APBF3gkjEXXADhQ6HMA5Ra base-4.14.1.0
    base64-bytestring-1.2.0.1-Fx8xBDFFRCm23zUlyCTZ2o binary-0.8.8.0
    blaze-html-0.9.1.2-1G5zFEF9qTw1N2uwiYtfOf bytestring-0.10.12.0
    case-insensitive-1.2.1.0-DhSgn3Eyd6B2JRqNU1iPe
    colour-2.3.5-C29WD8Qg69AL3qeQgayHy7 containers-0.6.2.1
    directory-1.3.6.0 filepath-1.4.2.1
    hxt-9.3.1.21-IzkRplD6FYE8cPGgfKEc88 mtl-2.2.2
    safe-0.3.19-AfrHSVViU1189qUhjBUb5b text-1.2.4.1
    transformers-0.5.6.2 utf8-string-1.0.2-7pqBkplor7g1hjwTjVt3SV

haddock-interfaces:
    /usr/share/doc/haskell-skylighting-core/html/skylighting-core.haddock

haddock-html:         /usr/share/doc/haskell-skylighting-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

