/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.LifecycleAwareTaskProperty;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.tasks.TaskDependency;

public class CalculatedTaskInputFileCollection
extends AbstractFileCollection
implements LifecycleAwareTaskProperty {
    private final String taskPath;
    private MinimalFileSet calculatedFiles;
    private List<LifecycleAwareTaskProperty> targets;
    private Set<File> cachedFiles;
    private boolean taskIsExecuting;

    public CalculatedTaskInputFileCollection(String taskPath, MinimalFileSet calculatedFiles, Object[] inputs) {
        this.taskPath = taskPath;
        this.calculatedFiles = calculatedFiles;
        this.targets = new ArrayList<LifecycleAwareTaskProperty>(1 + inputs.length);
        for (Object input : inputs) {
            if (!(input instanceof LifecycleAwareTaskProperty)) continue;
            this.targets.add((LifecycleAwareTaskProperty)input);
        }
        if (calculatedFiles instanceof LifecycleAwareTaskProperty) {
            this.targets.add((LifecycleAwareTaskProperty)calculatedFiles);
        }
    }

    public String getDisplayName() {
        return this.calculatedFiles.getDisplayName();
    }

    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    public Set<File> getFiles() {
        if (!this.taskIsExecuting) {
            throw new IllegalStateException("Can only query " + this.calculatedFiles.getDisplayName() + " while task " + this.taskPath + " is running");
        }
        if (this.cachedFiles == null) {
            this.cachedFiles = this.calculatedFiles.getFiles();
        }
        return this.cachedFiles;
    }

    @Override
    public void prepareValue() {
        this.taskIsExecuting = true;
        for (LifecycleAwareTaskProperty target : this.targets) {
            target.prepareValue();
        }
    }

    @Override
    public void cleanupValue() {
        this.taskIsExecuting = false;
        this.cachedFiles = null;
        for (LifecycleAwareTaskProperty target : this.targets) {
            target.cleanupValue();
        }
        this.targets = null;
    }
}

