/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class RuntimeClasspathResourceHasher
implements ResourceHasher {
    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return fileSnapshot.getHash();
    }

    @Override
    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        HashingOutputStream hasher = Hashing.primitiveStreamHasher();
        ByteStreams.copy((InputStream)zipInput, (OutputStream)hasher);
        return hasher.hash();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
    }
}

