/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.codeInsight.javadoc.JavaDocUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.ClassReferenceTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

class ExceptionTagInfo
extends ClassReferenceTagInfo {
    ExceptionTagInfo(String name) {
        super(name);
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return element instanceof PsiMethod;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        String result2 = super.checkTagValue(value);
        if (result2 != null) {
            return result2;
        }
        PsiClass exceptionClass = JavaDocUtil.resolveClassInTagValue(value);
        if (exceptionClass == null) {
            return null;
        }
        PsiClass throwable = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.Throwable", value.getResolveScope());
        if (throwable != null && !exceptionClass.equals(throwable) && !exceptionClass.isInheritor(throwable, true)) {
            return JavaErrorMessages.message("javadoc.exception.tag.class.is.not.throwable", exceptionClass.getQualifiedName());
        }
        PsiClass runtimeException = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.RuntimeException", value.getResolveScope());
        if (runtimeException != null && (exceptionClass.isInheritor(runtimeException, true) || exceptionClass.equals(runtimeException))) {
            return null;
        }
        PsiClass errorException = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.Error", value.getResolveScope());
        if (errorException != null && (exceptionClass.isInheritor(errorException, true) || exceptionClass.equals(errorException))) {
            return null;
        }
        PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
        if (method == null) {
            return null;
        }
        for (PsiClassType reference : method.getThrowsList().getReferencedTypes()) {
            PsiClass psiClass = reference.resolve();
            if (psiClass == null || !exceptionClass.isInheritor(psiClass, true) && !exceptionClass.equals(psiClass)) continue;
            return null;
        }
        return JavaErrorMessages.message("javadoc.exception.tag.exception.is.not.thrown", exceptionClass.getName(), method.getName());
    }
}

