#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 recursion-schemes
version:              5.2.2.1
visibility:           public
id:                   recursion-schemes-5.2.2.1-DGZ4zZTrYYW99XlW9W13rJ
key:                  recursion-schemes-5.2.2.1-DGZ4zZTrYYW99XlW9W13rJ
license:              BSD-2-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:
    "Samuel Gélineau" <gelisam@gmail.com>,
    "Ryan Scott" <ryan.gl.scott@gmail.com>,
    "Luc Tielen" <luc.tielen@gmail.com>

author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/recursion-schemes/
synopsis:
    Representing common recursion patterns as higher-order functions

description:
    Many recursive functions share the same structure, e.g. pattern-match on the input and, depending on the data constructor, either recur on a smaller input or terminate the recursion with the base case. Another one: start with a seed value, use it to produce the first element of an infinite list, and recur on a modified seed in order to produce the rest of the list. Such a structure is called a recursion scheme. Using higher-order functions to implement those recursion schemes makes your code clearer, faster, and safer. See README for details.

category:             Control, Recursion
abi:                  682ebf0797b842512820ba89ccf54b16
exposed:              True
exposed-modules:
    Data.Functor.Base Data.Functor.Foldable Data.Functor.Foldable.TH

hidden-modules:       Paths_recursion_schemes
import-dirs:          /usr/lib/ghc-8.10.5/site-local/recursion-schemes-5.2.2.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/recursion-schemes-5.2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/recursion-schemes-5.2.2.1
hs-libraries:         HSrecursion-schemes-5.2.2.1-DGZ4zZTrYYW99XlW9W13rJ
depends:
    base-4.14.2.0 base-orphans-0.8.4-B4zsXTdczgN9mmNUwgnmE3
    comonad-5.0.8-8a10YHmXJVq2BoDg3RtKOL containers-0.6.4.1
    data-fix-0.3.1-D9MFel1sX0UA9T9qsnfRBB
    free-5.1.7-G4cc1Y718fXDuPxii9x6Pg template-haskell-2.16.0.0
    th-abstraction-0.4.2.0-5X2XqBZ7rCLBwJXut5dQBZ transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-recursion-schemes/html/recursion-schemes.haddock

haddock-html:         /usr/share/doc/haskell-recursion-schemes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

