#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 config-ini
version:              0.2.4.0
visibility:           public
id:                   config-ini-0.2.4.0-827d4CfWMXDBb2Mym8Kku3
key:                  config-ini-0.2.4.0-827d4CfWMXDBb2Mym8Kku3
license:              BSD-3-Clause
copyright:            ©2018 Getty Ritter
maintainer:           Getty Ritter <config-ini@infinitenegativeutility.com>
author:               Getty Ritter <config-ini@infinitenegativeutility.com>
homepage:             https://github.com/aisamanra/config-ini
synopsis:             A library for simple INI-based configuration files.
description:
    The @config-ini@ library is a set of small monadic languages
    for writing simple configuration languages with convenient,
    human-readable error messages.

    > parseConfig :: IniParser (Text, Int, Bool)
    > parseConfig = section "NETWORK" $ do
    >   user <- field        "user"
    >   port <- fieldOf      "port" number
    >   enc  <- fieldFlagDef "encryption" True
    >   return (user, port, enc)

category:             Configuration
abi:                  14d4869aed77f8342091d09fd2cf7691
exposed:              True
exposed-modules:
    Data.Ini.Config Data.Ini.Config.Bidir Data.Ini.Config.Raw

import-dirs:          /usr/lib/ghc-8.10.5/site-local/config-ini-0.2.4.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/config-ini-0.2.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/config-ini-0.2.4.0
hs-libraries:         HSconfig-ini-0.2.4.0-827d4CfWMXDBb2Mym8Kku3
depends:
    base-4.14.2.0 containers-0.6.4.1
    megaparsec-9.0.1-IyAio6GA8vt39fw1sjLrjI text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O

haddock-interfaces:   /usr/share/doc/haskell-config-ini/html/config-ini.haddock
haddock-html:         /usr/share/doc/haskell-config-ini/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

