/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.IsolatableEnumValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedManagedNamedTypeSnapshot;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;

public class CoercingStringValueSnapshot
extends StringValueSnapshot {
    private final String value;
    private final NamedObjectInstantiator instantiator;

    public CoercingStringValueSnapshot(String value, NamedObjectInstantiator instantiator) {
        super(value);
        this.value = value;
        this.instantiator = instantiator;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isInstance(this.value)) {
            return (Isolatable)Cast.uncheckedCast((Object)this);
        }
        if (type.isEnum()) {
            return (Isolatable)Cast.uncheckedCast((Object)new IsolatableEnumValueSnapshot(Enum.valueOf(type.asSubclass(Enum.class), (String)this.getValue())));
        }
        if (Named.class.isAssignableFrom(type)) {
            return (Isolatable)Cast.uncheckedCast((Object)new IsolatedManagedNamedTypeSnapshot(this.instantiator.named(type, (String)this.getValue()), this.instantiator));
        }
        return null;
    }
}

