/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.util.Arrays;
import java.util.List;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileSystems;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.PosixFiles;
import net.rubygrapefruit.platform.file.WindowsFiles;
import net.rubygrapefruit.platform.internal.DefaultFileEvents;
import net.rubygrapefruit.platform.internal.DefaultMemory;
import net.rubygrapefruit.platform.internal.DefaultOsxMemory;
import net.rubygrapefruit.platform.internal.DefaultPosixFiles;
import net.rubygrapefruit.platform.internal.DefaultProcess;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import net.rubygrapefruit.platform.internal.DefaultSystemInfo;
import net.rubygrapefruit.platform.internal.DefaultWindowsFiles;
import net.rubygrapefruit.platform.internal.DefaultWindowsRegistry;
import net.rubygrapefruit.platform.internal.MutableTypeInfo;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.PosixFileSystems;
import net.rubygrapefruit.platform.internal.PosixTerminals;
import net.rubygrapefruit.platform.internal.WindowsProcessLauncher;
import net.rubygrapefruit.platform.internal.WindowsTerminals;
import net.rubygrapefruit.platform.internal.WrapperProcess;
import net.rubygrapefruit.platform.internal.WrapperProcessLauncher;
import net.rubygrapefruit.platform.internal.jni.PosixTypeFunctions;
import net.rubygrapefruit.platform.internal.jni.TerminfoFunctions;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.memory.OsxMemory;
import net.rubygrapefruit.platform.terminal.Terminals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private static Platform platform;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Platform current() {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform == null) {
                String osName = Platform.getOperatingSystem().toLowerCase();
                String arch = Platform.getArchitecture();
                if (osName.contains("windows")) {
                    if (arch.equals("x86")) {
                        platform = new Window32Bit();
                    } else if (arch.equals("amd64")) {
                        platform = new Window64Bit();
                    }
                } else if (osName.contains("linux")) {
                    if (arch.equals("amd64") || arch.equals("x86_64")) {
                        platform = new Linux64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new Linux32Bit();
                    }
                } else if (osName.contains("os x") || osName.contains("darwin")) {
                    if (arch.equals("i386")) {
                        platform = new MacOs32Bit();
                    } else if (arch.equals("x86_64") || arch.equals("amd64") || arch.equals("universal")) {
                        platform = new MacOs64Bit();
                    }
                } else if (osName.contains("freebsd")) {
                    if (arch.equals("amd64")) {
                        platform = new FreeBSD64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new FreeBSD32Bit();
                    }
                }
                if (platform == null) {
                    platform = new Unsupported();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isMacOs() {
        return false;
    }

    public boolean isFreeBSD() {
        return false;
    }

    public boolean isWindows() {
        return false;
    }

    public String toString() {
        return String.format("%s %s", Platform.getOperatingSystem(), Platform.getArchitecture());
    }

    public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type2) {
        return type2;
    }

    public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", type2.getSimpleName(), this.toString()));
    }

    public String getLibraryName() {
        throw new NativeIntegrationUnavailableException(String.format("Native integration is not available for %s.", this.toString()));
    }

    public List<String> getLibraryVariants() {
        return Arrays.asList(this.getId());
    }

    public abstract String getId();

    private static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    private static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    private static class Unsupported
    extends Platform {
        private Unsupported() {
        }

        public String getId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MacOs64Bit
    extends MacOs {
        private MacOs64Bit() {
        }

        public String getId() {
            return "osx-amd64";
        }
    }

    private static class MacOs32Bit
    extends MacOs {
        private MacOs32Bit() {
        }

        public String getId() {
            return "osx-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MacOs
    extends Posix {
        private MacOs() {
        }

        @Override
        public boolean isMacOs() {
            return true;
        }

        @Override
        public String getLibraryName() {
            return "libnative-platform.dylib";
        }

        @Override
        String getCursesLibraryName() {
            return "libnative-platform-curses.dylib";
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            if (type2.equals(OsxMemory.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultOsxMemory()));
            }
            if (type2.equals(Memory.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultMemory()));
            }
            return super.get(type2, nativeLibraryLoader);
        }
    }

    private static class FreeBSD64Bit
    extends FreeBSD {
        private FreeBSD64Bit() {
        }

        public String getId() {
            return "freebsd-amd64";
        }
    }

    private static class FreeBSD32Bit
    extends FreeBSD {
        private FreeBSD32Bit() {
        }

        public String getId() {
            return "freebsd-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FreeBSD
    extends Unix {
        private FreeBSD() {
        }

        @Override
        public List<String> getLibraryVariants() {
            return Arrays.asList(this.getId() + "-libcpp", this.getId() + "-libstdcpp");
        }

        @Override
        public boolean isFreeBSD() {
            return true;
        }
    }

    private static class Linux64Bit
    extends Linux {
        private Linux64Bit() {
        }

        public String getId() {
            return "linux-amd64";
        }
    }

    private static class Linux32Bit
    extends Linux {
        private Linux32Bit() {
        }

        public String getId() {
            return "linux-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Linux
    extends Unix {
        private Linux() {
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            return super.get(type2, nativeLibraryLoader);
        }

        @Override
        List<String> getCursesVariants() {
            return Arrays.asList(this.getId() + "-ncurses5", this.getId() + "-ncurses6");
        }

        @Override
        public boolean isLinux() {
            return true;
        }
    }

    private static abstract class Unix
    extends Posix {
        private Unix() {
        }

        public String getLibraryName() {
            return "libnative-platform.so";
        }

        String getCursesLibraryName() {
            return "libnative-platform-curses.so";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Posix
    extends Platform {
        private Posix() {
        }

        abstract String getCursesLibraryName();

        List<String> getCursesVariants() {
            return this.getLibraryVariants();
        }

        @Override
        public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type2) {
            if (type2.equals(Files.class)) {
                return PosixFiles.class.asSubclass(type2);
            }
            return super.canonicalise(type2);
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            if (type2.equals(PosixFiles.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultPosixFiles()));
            }
            if (type2.equals(Process.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcess(new DefaultProcess(), false)));
            }
            if (type2.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcessLauncher(new DefaultProcessLauncher())));
            }
            if (type2.equals(Terminals.class)) {
                nativeLibraryLoader.load(this.getCursesLibraryName(), this.getCursesVariants());
                int nativeVersion = TerminfoFunctions.getVersion();
                if (nativeVersion != 28) {
                    throw new NativeException(String.format("Unexpected native library version loaded. Expected %s, was %s.", nativeVersion, 28));
                }
                return (T)((NativeIntegration)type2.cast(new PosixTerminals()));
            }
            if (type2.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultSystemInfo()));
            }
            if (type2.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type2.cast(new PosixFileSystems()));
            }
            if (type2.equals(FileEvents.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultFileEvents()));
            }
            if (type2.equals(MutableTypeInfo.class)) {
                MutableTypeInfo typeInfo = new MutableTypeInfo();
                PosixTypeFunctions.getNativeTypeInfo(typeInfo);
                return (T)((NativeIntegration)type2.cast(typeInfo));
            }
            return super.get(type2, nativeLibraryLoader);
        }
    }

    private static class Window64Bit
    extends Windows {
        private Window64Bit() {
        }

        public String getId() {
            return "windows-amd64";
        }
    }

    private static class Window32Bit
    extends Windows {
        private Window32Bit() {
        }

        public String getId() {
            return "windows-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Windows
    extends Platform {
        private Windows() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getLibraryName() {
            return "native-platform.dll";
        }

        @Override
        public List<String> getLibraryVariants() {
            return Arrays.asList(this.getId(), this.getId() + "-min");
        }

        @Override
        public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type2) {
            if (type2.equals(Files.class)) {
                return WindowsFiles.class.asSubclass(type2);
            }
            return super.canonicalise(type2);
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            if (type2.equals(WindowsFiles.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultWindowsFiles()));
            }
            if (type2.equals(Process.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcess(new DefaultProcess(), true)));
            }
            if (type2.equals(Terminals.class)) {
                return (T)((NativeIntegration)type2.cast(new WindowsTerminals()));
            }
            if (type2.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcessLauncher(new WindowsProcessLauncher(new DefaultProcessLauncher()))));
            }
            if (type2.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultSystemInfo()));
            }
            if (type2.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type2.cast(new PosixFileSystems()));
            }
            if (type2.equals(WindowsRegistry.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultWindowsRegistry()));
            }
            if (type2.equals(FileEvents.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultFileEvents()));
            }
            return super.get(type2, nativeLibraryLoader);
        }
    }
}

