/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;

public abstract class DirectoryTrees {
    private DirectoryTrees() {
    }

    public static boolean contains(FileSystem fileSystem, DirectoryTree tree, File file) {
        String prefix = tree.getDir().getAbsolutePath() + File.separator;
        if (!file.getAbsolutePath().startsWith(prefix)) {
            return false;
        }
        RelativePath path = RelativePath.parse((boolean)true, (String)file.getAbsolutePath().substring(prefix.length()));
        return tree.getPatterns().getAsSpec().isSatisfiedBy((Object)new DefaultFileTreeElement(file, path, (Chmod)fileSystem, (Stat)fileSystem));
    }
}

