/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * OMAP44xx CM1 instance offset macros
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * XXX This file needs to be updated to align on one of "OMAP4", "OMAP44XX",
 *     or "OMAP4430".
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CM1_44XX_H
#define __ARCH_ARM_MACH_OMAP2_CM1_44XX_H

/* CM1 base address */
#define OMAP4430_CM1_BASE		0x4a004000

#define OMAP44XX_CM1_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(OMAP4430_CM1_BASE + (inst) + (reg))

/* CM1 instances */
#define OMAP4430_CM1_OCP_SOCKET_INST	0x0000
#define OMAP4430_CM1_CKGEN_INST		0x0100
#define OMAP4430_CM1_MPU_INST		0x0300
#define OMAP4430_CM1_TESLA_INST		0x0400
#define OMAP4430_CM1_ABE_INST		0x0500

/* CM1 clockdomain register offsets (from instance start) */
#define OMAP4430_CM1_MPU_MPU_CDOFFS	0x0000
#define OMAP4430_CM1_TESLA_TESLA_CDOFFS	0x0000
#define OMAP4430_CM1_ABE_ABE_CDOFFS	0x0000

#endif
