/* strlist.h
 *	Copyright (C) 1998, 2000, 2001 Free Software Foundation, Inc.
 *
 * This file is part of GnuPG.
 *
 * GnuPG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GnuPG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef LIBJNLIB_STRLIST_H
#define LIBJNLIB_STRLIST_H

struct string_list {
  struct string_list *next;
  unsigned int flags;
  char d[1];
};
typedef struct string_list *STRLIST;


void    free_strlist( STRLIST sl );
STRLIST add_to_strlist( STRLIST *list, const char *string );
/*STRLIST add_to_strlist2( STRLIST *list, const char *string, int is_utf8 );*/
STRLIST append_to_strlist( STRLIST *list, const char *string );
/*STRLIST append_to_strlist2( STRLIST *list, const char *string, int is_utf8 );*/
STRLIST strlist_prev( STRLIST head, STRLIST node );
STRLIST strlist_last( STRLIST node );
char * strlist_pop (STRLIST *list);

#define FREE_STRLIST(a) do { free_strlist((a)); (a) = NULL ; } while(0)


#endif /*LIBJNLIB_STRLIST_H*/
