/* wptGpgCmds.h - All valid gpg arguments
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_GPG_COMMANDS_H
#define WPT_GPG_COMMANDS_H

/***************
 * This is the array with all valid gnupg arguments. It it only used
 * by the config parser. It was generated with gpg --dump-options and 
 * formatted with a little perl script include in 'Utils'.
 */
/* gpg 1.4.1 */
static const char *valid_gpg_args[] = {
	"sign",
	"clearsign",
	"detach-sign",
	"encrypt",
	"encrypt-files",
	"symmetric",
	"store",
	"decrypt",
	"decrypt-files",
	"verify",
	"verify-files",
	"list-keys",
	"list-public-keys",
	"list-sigs",
	"check-sigs",
	"fingerprint",
	"list-secret-keys",
	"gen-key",
	"delete-keys",
	"delete-secret-keys",
	"sign-key",
	"lsign-key",
	"edit-key",
	"gen-revoke",
	"desig-revoke",
	"export",
	"send-keys",
	"recv-keys",
	"search-keys",
	"refresh-keys",
	"export-secret-keys",
	"export-secret-subkeys",
	"import",
	"fast-import",
	"card-status",
	"card-edit",
	"change-pin",
	"list-config",
	"gpgconf-list",
	"list-packets",
	"export-ownertrust",
	"import-ownertrust",
	"update-trustdb",
	"check-trustdb",
	"fix-trustdb",
	"dearmor",
	"dearmour",
	"enarmor",
	"enarmour",
	"print-md",
	"gen-prime",
	"gen-random",
	"armor",
	"armour",
	"recipient",
	"hidden-recipient",
	"remote-user",
	"default-recipient",
	"default-recipient-self",
	"no-default-recipient",
	"temp-directory",
	"exec-path",
	"encrypt-to",
	"hidden-encrypt-to",
	"no-encrypt-to",
	"local-user",
	"compress-level",
	"bzip2-compress-level",
	"bzip2-decompress-lowmem",
	"textmode",
	"no-textmode",
	"expert",
	"no-expert",
	"ask-sig-expire",
	"no-ask-sig-expire",
	"ask-cert-expire",
	"no-ask-cert-expire",
	"ask-cert-level",
	"no-ask-cert-level",
	"output",
	"max-output",
	"verbose",
	"quiet",
	"no-tty",
	"force-v3-sigs",
	"no-force-v3-sigs",
	"force-v4-certs",
	"no-force-v4-certs",
	"force-mdc",
	"no-force-mdc",
	"disable-mdc",
	"no-disable-mdc",
	"dry-run",
	"interactive",
	"use-agent",
	"no-use-agent",
	"gpg-agent-info",
	"batch",
	"yes",
	"no",
	"keyring",
	"primary-keyring",
	"secret-keyring",
	"show-keyring",
	"default-key",
	"keyserver",
	"keyserver-options",
	"import-options",
	"export-options",
	"list-options",
	"verify-options",
	"display-charset",
	"charset",
	"options",
	"debug",
	"debug-all",
	"status-fd",
	"status-file",
	"attribute-fd",
	"attribute-file",
	"no-sk-comments",
	"sk-comments",
	"completes-needed",
	"marginals-needed",
	"max-cert-depth",
	"trusted-key",
	"load-extension",
	"gnupg",
	"no-pgp2",
	"no-pgp6",
	"no-pgp7",
	"no-pgp8",
	"rfc1991",
	"rfc2440",
	"openpgp",
	"pgp2",
	"pgp6",
	"pgp7",
	"pgp8",
	"rfc2440-text",
	"no-rfc2440-text",
	"s2k-mode",
	"s2k-digest-algo",
	"s2k-cipher-algo",
	"simple-sk-checksum",
	"cipher-algo",
	"digest-algo",
	"cert-digest-algo",
	"compress-algo",
	"compression-algo",
	"throw-keyid",
	"throw-keyids",
	"no-throw-keyid",
	"no-throw-keyids",
	"show-photos",
	"no-show-photos",
	"photo-viewer",
	"set-notation",
	"notation-data",
	"sig-notation",
	"cert-notation",
	"list-ownertrust",
	"print-mds",
	"list-trustdb",
	"pipemode",
	"passphrase-fd",
	"passphrase-file",
	"command-fd",
	"command-file",
	"quick-random",
	"no-verbose",
	"trustdb-name",
	"no-secmem-warning",
	"require-secmem",
	"no-require-secmem",
	"no-permission-warning",
	"no-mdc-warning",
	"no-armor",
	"no-armour",
	"no-default-keyring",
	"no-greeting",
	"no-options",
	"homedir",
	"no-batch",
	"with-colons",
	"with-key-data",
	"list-key",
	"list-sig",
	"check-sig",
	"skip-verify",
	"compress-keys",
	"compress-sigs",
	"default-cert-check-level",
	"default-cert-level",
	"min-cert-level",
	"always-trust",
	"trust-model",
	"force-ownertrust",
	"run-as-shm-coprocess",
	"set-filename",
	"for-your-eyes-only",
	"no-for-your-eyes-only",
	"set-policy-url",
	"sig-policy-url",
	"cert-policy-url",
	"show-policy-url",
	"no-show-policy-url",
	"sig-keyserver-url",
	"show-notation",
	"no-show-notation",
	"comment",
	"default-comment",
	"no-comments",
	"emit-version",
	"no-emit-version",
	"no-version",
	"not-dash-escaped",
	"escape-from-lines",
	"no-escape-from-lines",
	"lock-once",
	"lock-multiple",
	"lock-never",
	"logger-fd",
	"logger-file",
	"use-embedded-filename",
	"no-use-embedded-filename",
	"utf8-strings",
	"no-utf8-strings",
	"with-fingerprint",
	"disable-cipher-algo",
	"disable-pubkey-algo",
	"allow-non-selfsigned-uid",
	"no-allow-non-selfsigned-uid",
	"allow-freeform-uid",
	"no-allow-freeform-uid",
	"no-literal",
	"set-filesize",
	"honor-http-proxy",
	"fast-list-mode",
	"fixed-list-mode",
	"list-only",
	"ignore-time-conflict",
	"ignore-valid-from",
	"ignore-crc-error",
	"ignore-mdc-error",
	"show-session-key",
	"override-session-key",
	"no-random-seed-file",
	"auto-key-retrieve",
	"no-auto-key-retrieve",
	"no-sig-cache",
	"no-sig-create-check",
	"auto-check-trustdb",
	"no-auto-check-trustdb",
	"merge-only",
	"allow-secret-key-import",
	"try-all-secrets",
	"enable-special-filenames",
	"no-expensive-trust-checks",
	"delete-secret-and-public-keys",
	"rebuild-keydb-caches",
	"preserve-permissions",
	"default-preference-list",
	"personal-cipher-preferences",
	"personal-digest-preferences",
	"personal-compress-preferences",
	"personal-cipher-prefs",
	"personal-digest-prefs",
	"personal-compress-prefs",
	"display",
	"ttyname",
	"ttytype",
	"lc-ctype",
	"lc-messages",
	"group",
	"ungroup",
	"no-groups",
	"strict",
	"no-strict",
	"mangle-dos-filenames",
	"no-mangle-dos-filenames",
	"enable-progress-filter",
	"multifile",
	"keyid-format",
	"reader-port",
	"ctapi-driver",
	"pcsc-driver",
	"disable-ccid",
	"dump-options",
	"help",
	"version",
	"warranty",
	NULL
};


#endif /* WPT_GPG_COMMANDS_H_ */