/*  SHA256, SHA384, SHA512 Copyright 2001 by Jari Ruusu.
 *  Redistribution of this file is permitted under the GNU Public License.
 */
#ifndef GPGLIB_MD_H
#define GPGLIB_MD_H

/****************
 * Rotate a 32 bit integer by n bytes
 */
#define rol(x,n) ( ((x) << (n)) | ((x) >> (32-(n))) )

#include <sys/types.h>

typedef unsigned __int64 u_int64_t;
typedef unsigned __int32 u_int32_t;

typedef struct {
    unsigned char   sha_out[64];    /* results are here, bytes 0...31 */
    u_int32_t       sha_H[8];
    u_int64_t       sha_blocks;
    int             sha_bufCnt;
} sha256_context;

typedef struct {
    unsigned char   sha_out[128];   /* results are here, bytes 0...63 */
    u_int64_t       sha_H[8];
    u_int64_t       sha_blocks;
    u_int64_t       sha_blocksMSB;
    int             sha_bufCnt;
} sha512_context;

typedef struct {
    unsigned long  h0,h1,h2,h3,h4;
    unsigned long  nblocks;
    unsigned char buf[64];
    int  count;
} RMD160_CONTEXT;

typedef struct {
    unsigned long  h0,h1,h2,h3,h4;
    unsigned long  nblocks;
    unsigned char buf[64];
    int  count;
} SHA1_CONTEXT;

typedef struct {
    unsigned long A,B,C,D;	  /* chaining variables */
    unsigned long  nblocks;
    unsigned char buf[64];
    int  count;
} MD5_CONTEXT;


unsigned char * sha1_read( SHA1_CONTEXT *hd );
void sha1_final( SHA1_CONTEXT *hd );
void sha1_write( SHA1_CONTEXT *hd, unsigned char *inbuf, size_t inlen );
void sha1_init( SHA1_CONTEXT *hd );

unsigned char * md5_read( MD5_CONTEXT * hd );
void md5_final( MD5_CONTEXT * hd );
void md5_write( MD5_CONTEXT * hd, unsigned char *inbuf, size_t inlen );
void md5_init( MD5_CONTEXT * hd );

unsigned char * rmd160_read( RMD160_CONTEXT *hd );
void rmd160_init( RMD160_CONTEXT *hd );
void rmd160_write( RMD160_CONTEXT *hd, unsigned char *inbuf, size_t inlen);
void rmd160_final( RMD160_CONTEXT *hd );
void rmd160_mixblock( RMD160_CONTEXT *hd, char *buffer );

void sha256_init(sha256_context *);
void sha256_write(sha256_context *, unsigned char *, size_t);
void sha256_final(sha256_context *);
unsigned char * sha256_read (sha256_context *);

void sha512_init(sha512_context *);
void sha512_write(sha512_context *, unsigned char *, size_t);
void sha512_final(sha512_context *);
unsigned char * sha512_read (sha512_context *);

void sha384_init(sha512_context *);



#endif /* GPGLIB_MD_H */