#if 0
	filedisk_init_info			@600
	filedisk_free_info			@601
	filedisk_mount				@602
	filedisk_unmount			@603
	filedisk_status				@604
#endif
/* wptFileDisk.c - Control program for a virtual disk driver for WinNT/2000/XP.

    Copyright (C) 1999, 2000, 2001, 2002 Bo Brantn.

    Heavily modified for the use with Cryptdisk by Timo Schulz
    (C) 2004 Timo Schulz

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include <sys/types.h>

#include "openpgp.h"
#include "../Include/wptCryptdisk.h"

/* remember to change the values in wptErrors.h also */
#define CDISK_ERR_LOCK	 201
#define CDISK_ERR_MOUNT  202
#define CDISK_ERR_UMOUNT 203
#define CDISK_ERR_OPEN   204
#define CDISK_ERR_BUSY	 205
#define CDISK_ERR_QUERY  206

static void 
print_lasterr (char * prefix)
{
    LPVOID msg;

    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_FROM_SYSTEM |
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL,
        GetLastError(),
        0,
        (LPTSTR) &msg,
        0,
        NULL
        );
    MessageBox (NULL, (LPTSTR)msg, prefix, MB_ICONERROR|MB_OK);
    LocalFree (msg);
}

#if 0
static int
add_key (POPEN_FILE_INFORMATION ka, const char * key, size_t len)
{
    gpg_md_t md=NULL;

    if (ka->KeyNum >= MAX_KEYS) 
	return -1;

    switch (ka->KeyType) {
    case 1: /* 2fish */
	md = gpg_md_open (MD_RMD160);
	ka->KeyLength=20;
	break;
    case 2: /* AES256 */
	md = gpg_md_open (MD_SHA512);
	ka->KeyLength=32;	
	break;
    case 3: /* AES128 */
	md = gpg_md_open (MD_SHA256);
	ka->KeyLength=16;
	break;
    case 4: /* AES192 */
	ka->KeyLength=24;
	md = gpg_md_open (MD_SHA384);
	break;
    }
    if (!md)
	return -1;
    gpg_md_write (md, (char *)key, len);
    gpg_md_final (md);
    memcpy (ka->Key[ka->KeyNum++], gpg_md_read (md), ka->KeyLength);
    gpg_md_close (md);
    return 0;
}
#endif


int
filedisk_mount (int                     DeviceNumber,
		POPEN_FILE_INFORMATION  ofi,
		char                    drivelet,
		BOOLEAN                 CdImage)
{
    char    VolumeName[] = "\\\\.\\ :";
    char    DeviceName[255];
    HANDLE  Device;
    DWORD   BytesReturned;

    VolumeName[4] = drivelet;

    Device = CreateFile (VolumeName,
			 GENERIC_READ | GENERIC_WRITE,
			 FILE_SHARE_READ | FILE_SHARE_WRITE,
			 NULL,
			 OPEN_EXISTING,
			 FILE_FLAG_NO_BUFFERING,
			 NULL);
    if (Device != INVALID_HANDLE_VALUE) {
        SetLastError (ERROR_BUSY);
        print_lasterr (&VolumeName[4]);
        return CDISK_ERR_BUSY;
    }

    if (CdImage)
        sprintf (DeviceName, DEVICE_NAME_PREFIX "Cd" "%u", DeviceNumber);
    else
        sprintf (DeviceName, DEVICE_NAME_PREFIX "%u", DeviceNumber);

    if (!DefineDosDevice (DDD_RAW_TARGET_PATH,
			  &VolumeName[4],
			  DeviceName)) {
        print_lasterr (&VolumeName[4]);
        return CDISK_ERR_OPEN;
    }

    Device = CreateFile (VolumeName,
			 GENERIC_READ | GENERIC_WRITE,
			 FILE_SHARE_READ | FILE_SHARE_WRITE,
			 NULL,
			 OPEN_EXISTING,
			 FILE_FLAG_NO_BUFFERING,
			 NULL);

    if (Device == INVALID_HANDLE_VALUE) {
        print_lasterr (&VolumeName[4]);
        DefineDosDevice (DDD_REMOVE_DEFINITION, &VolumeName[4], NULL);
        return CDISK_ERR_OPEN;
    }

    if (!DeviceIoControl (Device,
			  IOCTL_FILE_DISK_OPEN_FILE,
			  ofi,
			  sizeof(OPEN_FILE_INFORMATION) + ofi->FileNameLength - 1,
			  NULL, 0, &BytesReturned, NULL)) {
        print_lasterr ("Cryptdisk Error");
        DefineDosDevice (DDD_REMOVE_DEFINITION, &VolumeName[4], NULL);
        return CDISK_ERR_MOUNT;
    }

    return 0;
}


static int 
filedisk_unmount2 (char drivelet, int flags, int forced)
{
    char    VolumeName[60] = "\\\\.\\ :";
    HANDLE  Device;
    DWORD   BytesReturned;

    if (!flags)
	VolumeName[4] = drivelet;
    else if (flags & 1)
	sprintf(VolumeName,"\\\\.\\FileDisk%d", drivelet);
    else if (flags & 2)
	sprintf(VolumeName,"\\\\.\\FileDiskCd%d",drivelet);

    Device = CreateFile (VolumeName,
			 GENERIC_READ | GENERIC_WRITE,
			 FILE_SHARE_READ | FILE_SHARE_WRITE,
			 NULL,
			 OPEN_EXISTING,
			 FILE_FLAG_NO_BUFFERING,
			 NULL);
    if (Device == INVALID_HANDLE_VALUE) {
	if (forced)
	    print_lasterr(&VolumeName[4]);
        return CDISK_ERR_OPEN;
    }

    if (!DeviceIoControl (Device, 
			  FSCTL_LOCK_VOLUME,
			  NULL, 0, NULL, 0,
			  &BytesReturned, NULL)) {
	if (forced) {
	    print_lasterr(&VolumeName[4]);
	    return CDISK_ERR_LOCK;
	}
    }

    if (!DeviceIoControl (Device,
			  IOCTL_FILE_DISK_CLOSE_FILE,
			  NULL, 0, NULL, 0, 
			  &BytesReturned, NULL )) {
	if (forced)
	    print_lasterr ("Cryptdisk Error");
        return CDISK_ERR_UMOUNT;
    }

    if (!DeviceIoControl (
        Device, FSCTL_DISMOUNT_VOLUME,
        NULL, 0, NULL, 0,
        &BytesReturned, NULL)) {
	if (forced)
	    print_lasterr (&VolumeName[4]);
        return CDISK_ERR_UMOUNT;
    }

    if (!DeviceIoControl (Device, 
			  FSCTL_UNLOCK_VOLUME,
			  NULL, 0, NULL, 0,
			  &BytesReturned, NULL)) {
	if (forced) {
	    print_lasterr (&VolumeName[4]);
	    return CDISK_ERR_LOCK;
	}
    }

    CloseHandle (Device);

    if (!DefineDosDevice (
        DDD_REMOVE_DEFINITION,
        &VolumeName[4], NULL)) {
	if (forced)
	    print_lasterr (&VolumeName[4]);
        return CDISK_ERR_UMOUNT;
    }

    return 0;
}

int 
filedisk_unmount (char drivelet, int forced)
{	    
    char i;

    if (drivelet) {
	int rc = filedisk_unmount2 (drivelet, 0, forced);
	if (rc) 
	    print_lasterr ("Unmount");
	return rc;
    }
    for (i=0; i<20;i++) {
	if (filedisk_unmount2 (i, 1, 0) == CDISK_ERR_OPEN)
	    break;
    }
    for (i=0; i<20;i++) {
	if (filedisk_unmount2 (i, 2, 0) == CDISK_ERR_OPEN)
	    break;
    }
    return 0;
}


int
filedisk_status (char drivelet, LARGE_INTEGER * size, int * rdonly)
{
    char                    VolumeName[] = "\\\\.\\ :";
    HANDLE                  Device;
    POPEN_FILE_INFORMATION  ofi;
    DWORD                   BytesReturned;

    VolumeName[4] = drivelet;

    Device = CreateFile (VolumeName,
			 GENERIC_READ,
			 FILE_SHARE_READ | FILE_SHARE_WRITE,
			 NULL,
			 OPEN_EXISTING,
			 FILE_FLAG_NO_BUFFERING,
			NULL);

    if (Device == INVALID_HANDLE_VALUE) {
        print_lasterr(&VolumeName[4]);
        return CDISK_ERR_OPEN;
    }

    ofi = malloc (sizeof(OPEN_FILE_INFORMATION) + MAX_PATH);

    if (!DeviceIoControl (Device,
			  IOCTL_FILE_DISK_QUERY_FILE,
			  NULL,
			  0,
			  ofi,
			  sizeof(OPEN_FILE_INFORMATION) + MAX_PATH,
			  &BytesReturned, NULL)) {
        print_lasterr (&VolumeName[4]);
        return CDISK_ERR_QUERY;
    }

    if (BytesReturned < sizeof(OPEN_FILE_INFORMATION)) {
        SetLastError (ERROR_INSUFFICIENT_BUFFER);
        print_lasterr (&VolumeName[4]);
        return CDISK_ERR_QUERY;
    }

    if (size)
	*size = ofi->FileSize;
    if (rdonly)
	*rdonly = ofi->ReadOnly;

    return 0;
}


POPEN_FILE_INFORMATION
filedisk_init_info (int devnum, char drivelet, const char * file,
		    int ro, int cd_img, unsigned long size, const char * key,
		    int keyalgo)
{
    POPEN_FILE_INFORMATION pfi;

    pfi = calloc (1, sizeof(OPEN_FILE_INFORMATION) + strlen (file) + 7);
    if (!pfi)
	return NULL;

    /*pfi->version = CCVERSION;*/
    if (file[0] == '\\') {
	if (file[1] == '\\' && file[2] != '.') {
	    /* \\server\share\path\filedisk.img */
	    strcpy(pfi->FileName, "\\??\\UNC");
	    strcat(pfi->FileName, file + 1);
	}
	else /* \Device\Harddisk0\Partition1\path\filedisk.img */
	    strcpy(pfi->FileName, file);
    }	
    else { // c:\path\filedisk.img
	strcpy (pfi->FileName, "\\??\\");
	strcat (pfi->FileName, file);
    }

    pfi->FileNameLength = (USHORT) strlen (pfi->FileName);
    pfi->ReadOnly = ro? TRUE : FALSE;
    if (cd_img)
	pfi->ReadOnly = TRUE;
    if (size)
	pfi->FileSize.QuadPart = size * 1024;
    if (key) {
	/*
	if (keyalgo < 1 || keyalgo > 4)
	    pfi->KeyType = 1;
	else
	    pfi->KeyType = keyalgo;
	add_key (pfi, key, strlen (key));
	*/
    }

    return pfi;
}


void
filedisk_free_info (POPEN_FILE_INFORMATION pfi)
{
    if (!pfi)
	return;
    /*memset (pfi->Key, 0, sizeof pfi->Key);*/
    free (pfi);
}

